// blackboard.inc - POV include file for the schoolroom blackboard
//
// The blackboard is hung at the front of the room.  It is about 
// 6' (72") in height, and 3' less than width of the room in width.
// The blackboard is enclosed in an aluminum frame that is 1" in
// thickness and width.  The texture of the blackboard is a granite
// of different very close shades of very dark gray, it offers
// no specular reflection, and maybe a small amount of phong highlight.
//
// Written on the blackboard is the message "Welcome to Geography 101".
// The message is written with white chalk.  The white chalk letters
// extent about 0.02" out from the blackboard.  The letters are written
// with the font file "balloon.ttf"   The material of the letters
// is a granite of White mixed with Clear, with very sharp dividing
// lines.  Be careful not to make the granite too small!
//

#include "school1.inc"




#declare BlackboardBasicHoleShape = box {
   <0,0,-1>,<1,1,0>
   scale <BlackboardWidth, BlackboardHeight, 10>
}

#declare BlackboardFrameShape = difference {
   box { <-BlackboardFrameSize, -1, 0>, 
	 <0, BlackboardHeight, BlackboardWidth>
   }
   box { <-2*BlackboardFrameSize, BlackboardFrameSize, BlackboardFrameSize>,
	 <1, BlackboardHeight-BlackboardFrameSize, BlackboardWidth - BlackboardFrameSize>
   }
}

#declare BlackboardFrameObject = object {
   BlackboardFrameShape
   texture { // roughly based on Dan Farmers Brushed_Aluminum
     pigment { color rgb<0.84,0.84,0.85> }
     normal { 
       bumps -0.45
       scale <0.0012, 0.35, 0.0035>
     }
     finish {
       ambient 0.25       diffuse 0.65
       reflection 0.11       brilliance 8
       specular 0.68       roughness 0.05
     }
   }
}

#declare BlackboardSlateShape = box {
  <-BlackboardThickness, -0.5, -0.5>,<0, 0.5, 0.5>
  scale <1, 
         BlackboardHeight - (BlackboardFrameSize/2),
         BlackboardWidth - (BlackboardFrameSize/2)>
  translate <0, BlackboardHeight/2, BlackboardWidth/2>
}

#declare BlackboardSlateObject = object {
  BlackboardSlateShape
  texture {
    pigment {
      crackle
	color_map {
	   [0.0 color rgb<0.1,0.101,0.1>]
	   [0.5 color rgb<0.08,0.08,0.08>]
           [0.8 color rgb<0.1,0.1,0.1>]
	   [1.0 color rgb<0.1,0.101,0.1>]
	}
      turbulence 3.5
      octaves 2
      scale 0.33
    }
    finish { ambient BasicAmbient diffuse BasicDiffuse }
  }
}

#declare BlackboardObject = union {
  object { BlackboardFrameObject }
  object { BlackboardSlateObject }
}


// now work on the writing

#declare TextObject1WELCOME = text {
  ttf "balloon.ttf"
  "WELCOME" 1,0
  rotate <0,-90,0>
  scale <-ChalkThickness, ChalkTextLineHeight, ChalkTextLineHeight>
  scale <1, 0.98, 0.97> // random part
  // rotate <-1,0,0>
  translate <-BlackboardThickness,0,0>
}

#declare TextObject2To = text {
  ttf "balloon.ttf"
  "To" 1,0.03
  rotate <0,-90,0>
  scale <-ChalkThickness, ChalkTextLineHeight, ChalkTextLineHeight>
  scale <1, 1.01, 0.96> // random part
  translate <-BlackboardThickness,0,0>
}

#declare TextObject3Geography = text {
  ttf "balloon.ttf"
  "Geography" 1,0
  rotate <0,-90,0>
  scale <-ChalkThickness, ChalkTextLineHeight, ChalkTextLineHeight>
  scale <1, 0.96, 0.99> // random part
  rotate <2,0,0>
  translate <-BlackboardThickness,0,0>
}

#declare TextObject4101 = text {
  ttf "balloon.ttf"
  "101" 1,0
  rotate <0,-90,0>
  scale <-ChalkThickness, ChalkTextLineHeight, ChalkTextLineHeight>
  scale <1, 1.02, 1.04> // random part
  rotate <3,0,0>
  translate <-BlackboardThickness,0,0>
}

#declare BlackboardChalkWritingShape = union {
  object { TextObject1WELCOME 
	   translate <0, 3.01 * ChalkTextLineHeight, -0.5> }
  object { TextObject2To translate <0, 2 * ChalkTextLineHeight, 2> }
  object { TextObject3Geography 
	   translate <0, 0.98 * ChalkTextLineHeight, -1> }
  object { TextObject4101 translate <0, -BasicFudge, 3> }
}

#declare BlackboardChalkWriting = object {
  BlackboardChalkWritingShape
  texture {
    pigment { 
      granite
      color_map {
	    [0.0 color White]
	    [0.12 color White]
	    [0.26 color rgb<1.0,1.0,0.93>]
	    [0.27 color Clear]
	    [0.51 color Clear]
	    [0.515 color White]
	    [0.82 color White]
	    [0.83 color Clear]
	    [1.0  color Clear]
      }
      scale 0.6
    }
    finish { ambient BasicAmbient diffuse BasicDiffuse }
  }
  translate <0, ChalkTextYLoc, ChalkTextXLoc>
}



// the whole chalkboard with writing

#declare FullBlackboardObject = union {
  object { BlackboardObject }
  object { BlackboardChalkWriting }
  rotate <0,90,0>
  translate <BlackboardLLXPosition - RoomGlobePositionX, BlackboardLLYPosition, RoomLength - RoomGlobePositionZ>
}

#declare FullBlackboardHole = object {
  BlackboardBasicHoleShape
  translate <BlackboardLLXPosition - RoomGlobePositionX, BlackboardLLYPosition, RoomLength - RoomGlobePositionZ>  
}
    

	    
