#ifdef(Constants_Inc_Temp)
// do nothing
#else
#declare Constants_Inc_Temp=version
#version 3.0


// overall constants
#declare BasicAmbient = 0.33
#declare BasicDiffuse = 0.79

#declare BasicFudge = 0.05

// constants for the globe
#declare GlobeRadius   =    12
#declare GlobeRotation1 = <0,4,0>
#declare GlobeRotation2 = <0,0,22>
#declare GlobeCenterHeight = 30
#declare GlobePosition = <0,GlobeCenterHeight,0>

#declare GlobeRingMajorRadius = 13
#declare GlobeRingMinorRadius = 0.78
#declare GlobeRingThickness = 0.25
#declare GlobeRingEmptyPad = (GlobeRadius + 0.5)

#declare GlobeRodRadius = 0.38

#declare GlobeRimRadius = 15.75
#declare GlobeRimHeight =  1.3

#declare GlobeRimLegRadius = 0.68
#declare GlobeRimLegLength = 24
#declare GlobeRimLegDecorationMinorRadius  = 0.31

#declare GlobeStandBaseRadius = GlobeRimRadius - (GlobeRimLegRadius/3)
#declare GlobeStandBaseHeight = (GlobeCenterHeight - GlobeRimLegLength)
#declare GlobeStandBaseThickness = 0.95

#declare GlobeStandFootWheelRadius = 0.5

#declare GlobeStandFootRadius = 0.59
#declare GlobeStandFootLength = (GlobeStandBaseHeight - 1)
 
// constants for the textbook
#declare BookCoverLength = 9.0
#declare BookCoverWidth  = 5.6
#declare BookCoverThickness = 0.2
#declare BookCoverEWRoundness = 0.12
#declare BookCoverNSRoundness = 0.07

#declare BookHingeWidth = 0.4
#declare BookHingeThickness = 0.09

#declare BookSpineEWRoundness = 0.17
#declare BookSpineNSRoundness = 0.02
#declare BookSpineThickness = 0.011

#declare BookOverallThickness = 2.1
#declare BookCoverExtension = 0.19


// constants for the apple
#declare AppleStemRadius    = 0.08
#declare AppleStemCurveRadius = 2.05
#declare AppleStemSizeRadius = 1.20

// constants for the classroom
#declare RoomLength = (20 * 12.)
#declare RoomWidth  = (22 * 12.)
#declare RoomHeight = (11 * 12.)
#declare RoomWallThickness = 4

#declare RoomFloorMoldingHeight = 3
#declare RoomFloorMoldingThickness = 1

#declare RoomChairRailHeight = 6.7
#declare RoomChairRailThickness = 1.25
#declare RoomChairRailPosition = (3.35 * 12.)

#declare RoomWindowWidth = (3.25*12)
#declare RoomWindowHeight= (5.5*12)
#declare RoomWindowLLYPosition= (2.4*12)
#declare RoomWindowLLXPosition= (2.75 * 12)

#declare RoomWindowFrameSize      = 2
#declare RoomWindowFrameThickness = (RoomWallThickness+2)
#declare RoomWindowSillHeight     = 0.75
#declare RoomWindowSillExtension  = 1.25

#declare RoomWindowPaneFrameSize  = 1.35
#declare RoomWindowSlideGrooveDepth = 0.35
#declare RoomWindowPaneGlassThickness = 0.2
#declare RoomWindowPaneWidth = ((RoomWindowWidth - (2*RoomWindowFrameSize)) + (2* RoomWindowSlideGrooveDepth))
#declare RoomWindowPaneHeight=((RoomWindowHeight - (2*RoomWindowFrameSize))/2 + RoomWindowPaneFrameSize + RoomWindowSlideGrooveDepth)
#declare RoomWindowPaneMuttonBarSize  = 0.85

#declare RoomWindowOpenByHowMuch = 7
#declare RoomClosedWindowZOffset = 18

#declare RoomGlobePositionX = (2.75 * 12)
#declare RoomGlobePositionZ = (RoomLength - (3.25 * 12))

#declare RoomFloorboardGap = 0.11
#declare RoomFloorboardBasicWidth =  4
#declare RoomFloorboardBasicLength = (2.5*12)
#declare RoomFloorboardThickness = BasicFudge


// stuff for the blackboard
#declare BlackboardHeight = 72
#declare BlackboardWidth  = (RoomWidth - 42)
#declare BlackboardLLYPosition = (3.025 * 12)
#declare BlackboardLLXPosition = (1.5 * 12)
#declare BlackboardFrameSize = 1.28
#declare BlackboardThickness = 1.0
#declare ChalkThickness = 1.02
#declare ChalkTextLineHeight = 5.8

#declare ChalkTextYLoc = 5.1
#declare ChalkTextXLoc = 31


// ****************************************************************
// constants for the student's tabletop

#declare TableLength = 26
#declare TableWidth  = 16
#declare TableCornerRadius = 1
#declare TableInitialThickness = 2
#declare TableFinalThickness = 0.75
#declare TableEdgeRadiusRatio = 0.9

#declare TableXLocation = 4.5
#declare TableYLocation = 40.2
#declare TableZLocation = -124.65

// ****************************************************************
// constants for the pencils

#declare PencilPointRadius = 0.002

         // dont change these 
#declare PencilRadius = 0.15
#declare PencilTotalLength = 6.5

         // these two must add up to PencilTotalLength
#declare PencilPointLength = 0.5
#declare PencilBodyLength = (PencilTotalLength - PencilPointLength)

// ****************************************************************
// viewpoint constants
#declare CameraLocationX = 3.92
#declare CameraLocationY = 55
#declare CameraLocationZ = -153

#declare CameraCenterPoint = <-0.75, (0.795 * GlobeCenterHeight), 0>
#declare CameraAngle = 36



#version Constants_Inc_Temp
#end
