#! /usr/bin/perl
##
#
# Generate a set of floorboards of irregular width and length
#
# the usual way to run this is:
# 
#		perl -w genfloor.pl >floorboards.inc
#

$lengthlim = 20/2.5;
$widthlim = 22*3;

$widthvarmin = 0.8;
$widthvarmax = 1.34;

$lengthvarmin = 0.65;
$lengthvarmax = 1.57;

$texturexlatemin =  -13;
$texturexlatemax =  19.5;

$texturerotatemin = -3.0;
$texturerotatemax = 3.1;

$texturescalemin = 0.527;
$texturescalemax = 1.2;

$boardyoffsetmin = -0.02;
$boardyoffsetmax =  0.02;

$warpprobability = 56;
$warpradiusmin = 0.40;
$warpradiusmax = 0.9;

$textureName = "RoomFloorBasicPigment";

srand(139173);


sub getRandom {
    my $minval = shift;
    my $maxval = shift;
    my $val = 0.0;

    $val = (rand() * ($maxval - $minval)) + $minval;
    $val;
}

$rotx = 0.0;
$roty = 0.0;
$rotz = 0.0;
$scalex = 0;
$scaley = 1;
$scalez = 0;
$movex = 0;
$movey = 0;
$movez = 0;
$usewarp = 0;
$warpx = 0;
$warpz = 0;
$warprad = 0;
$yoffset = 0;

$boardcount = 0;
$knotcount = 0;
$currentwid = 0;

print "   // These floorboards generated by perl script genfloor.pl\n";

while ($currentwid < $widthlim) {
    $thiswidth = getRandom($widthvarmin,$widthvarmax);
    $currentlen = 0;
    while ($currentlen < $lengthlim) {
	$thislength = getRandom($lengthvarmin,$lengthvarmax);
	print <<ShapeStuff;
   box {
     <0, -(RoomFloorboardThickness), 0>
     <($thiswidth * RoomFloorboardBasicWidth) - RoomFloorboardGap,  0, 
      ($thislength * RoomFloorboardBasicLength) - RoomFloorboardGap*1.5>
     texture { 
	 pigment { $textureName
ShapeStuff

    $usewarp = getRandom(0,100);
    if ($usewarp < $warpprobability) {
	$warpx = getRandom(0.01,0.99);
	$warpz = getRandom(0.02,0.98);
	$warprad = getRandom($warpradiusmin,$warpradiusmax);
	$knotcount += 1;
	print <<WarpStuff;
	          warp { black_hole
		      <RoomFloorboardBasicWidth * $thiswidth * $warpx, 0, RoomFloorboardBasicLength * $thislength * $warpz>,
		      $warprad * RoomFloorboardBasicWidth
		      strength 2
	          }
WarpStuff
    }
    $roty = getRandom($texturerotatemin,$texturerotatemax);
    $scalex = getRandom($texturescalemin,$texturescalemax);
    $scalez = getRandom($texturescalemin,$texturescalemax);
    $movex  = getRandom($texturexlatemin,$texturexlatemax);
    $movez  = getRandom($texturexlatemin,$texturexlatemax);

    print <<TextureStuff;
	   }
	   finish {
		   ambient BasicAmbient
		   diffuse BasicDiffuse*0.8
		   specular 0.18 roughness 0.011
		   // take this in or out for speed
                   reflection <0.08,0.08,0.03>
	   }
           rotate <0,0,90>
	   rotate <$rotx,$roty,$rotz>
	   scale <$scalex,$scaley,$scalez * 2>
	   translate <$movex * 2, $movey, $movez>
TextureStuff

    $yoffset = getRandom($boardyoffsetmin,$boardyoffsetmax);
    if ($yoffset < 0.01 && $yoffset > -0.006) { $yoffset = 0; }
    print <<PositionStuff;
	}
        translate <$currentwid * RoomFloorboardBasicWidth,
		   $yoffset * RoomFloorboardThickness, 
		   $currentlen * RoomFloorboardBasicLength>
PositionStuff

    print <<EndStuff;
   }
EndStuff

      $boardcount += 1;

      $currentlen += $thislength;
    }
    $currentwid += $thiswidth;
}

print "   // generated a total of ",$boardcount," boards with ",$knotcount," knots.\n";

