#include "school1.inc"


// define our spiral

#declare SpRadius     = 0.3
#declare SpThickness  = 0.025
#declare SpTurn       = 10
#declare SpSinOfTurn  = 0.1736481776669

#declare sp_halfturn1pre = torus { SpRadius, SpThickness
         rotate <0,0,90>
         clipped_by { box { <-0.1,0,-1>,<0.1,1,1> } }
}

#declare sp_halfturn1 = object {
         sp_halfturn1pre
         translate <0,0,SpRadius>
         rotate <0, SpTurn, 0>
}

#declare sp_halfturn2 = object {
         sp_halfturn1
         scale <-1,-1,1>
}

#declare sp_turn = union {
         object { sp_halfturn1 }
         object { sp_halfturn2 }
         translate <SpRadius * SpSinOfTurn * 2, 0, 0>
}

#declare sp_x_offset = (SpRadius * SpSinOfTurn)*4

#declare spiral30 = union {
         object { sp_turn }
         object { sp_turn translate <1*sp_x_offset,0,0> }
         object { sp_turn translate <2*sp_x_offset,0,0> }
         object { sp_turn translate <3*sp_x_offset,0,0> }
         object { sp_turn translate <4*sp_x_offset,0,0> }
         object { sp_turn translate <5*sp_x_offset,0,0> }
         object { sp_turn translate <6*sp_x_offset,0,0> }
         object { sp_turn translate <7*sp_x_offset,0,0> }
         object { sp_turn translate <8*sp_x_offset,0,0> }
         object { sp_turn translate <9*sp_x_offset,0,0> }
         object { sp_turn translate <10*sp_x_offset,0,0> }
         object { sp_turn translate <11*sp_x_offset,0,0> }
         object { sp_turn translate <12*sp_x_offset,0,0> }
         object { sp_turn translate <13*sp_x_offset,0,0> }
         object { sp_turn translate <14*sp_x_offset,0,0> }
         object { sp_turn translate <15*sp_x_offset,0,0> }
         object { sp_turn translate <16*sp_x_offset,0,0> }
         object { sp_turn translate <17*sp_x_offset,0,0> }
         object { sp_turn translate <18*sp_x_offset,0,0> }
         object { sp_turn translate <19*sp_x_offset,0,0> }
         object { sp_turn translate <20*sp_x_offset,0,0> }
         object { sp_turn translate <21*sp_x_offset,0,0> }
         object { sp_turn translate <22*sp_x_offset,0,0> }
         object { sp_turn translate <23*sp_x_offset,0,0> }
         object { sp_turn translate <24*sp_x_offset,0,0> }
         object { sp_turn translate <25*sp_x_offset,0,0> }
         object { sp_turn translate <26*sp_x_offset,0,0> }
         object { sp_turn translate <27*sp_x_offset,0,0> }
         object { sp_turn translate <28*sp_x_offset,0,0> }
         object { sp_turn translate <29*sp_x_offset,0,0> }
         texture { Silver3 }
}

#declare Spiral60 = union {
         object { spiral30 translate <0,0, -SpRadius> }
         object { spiral30 translate <-30*sp_x_offset,0, -SpRadius> }
}


// now make the notebook
#declare NBCoverThickness = 0.08

#declare NBcover1pre = superellipsoid {
  <0.04,     0.1>
  translate <0,1,1>
  scale <31*sp_x_offset,NBCoverThickness/2, 4.5>
}

#declare NBcovercolor = Maroon

#declare NBcovertexture1 = texture {
     pigment { color NBcovercolor }
     finish { ambient 0.2 diffuse 0.8 phong 0.3 phong_size 50 }
}

#declare NBcovertexture2 = texture {
     pigment { color LightGray }
     normal { dents scale <0.5,0.06,0.5> }
     finish { ambient 0.2 diffuse 0.85 }
}

#declare NBcovertexturepre = texture {
         gradient y
         texture_map {
                     [0.08 NBcovertexture1]
                     [0.92 NBcovertexture2]
                     [1.00 NBcovertexture1]
         }
}

#declare NBcover = object {
         NBcover1pre
         texture { NBcovertexturepre scale <1,NBCoverThickness,1> }
}

#declare NBthickness = 1.4 * SpRadius
#declare NBpaperthickness = NBthickness - 2*NBCoverThickness

#declare NBpapertexture = texture {
         pigment {
                 gradient y
                 color_map {
                           [0.0 color White]
                           [0.23 color White]
                           [0.4 color Blue]
                           [0.5 color Blue]
                           [0.6 color White]
                           [1.0 color White]
                 }
                 scale <1,0.02,1>
         }
         normal { gradient y scale <1,0.02,1> }
         finish { ambient 0.2 diffuse 0.82 }
}

#declare NBpapershape = superellipsoid {
  <0.4,     0.1>
  translate <0,1,1>
  scale <31*sp_x_offset - 0.02,NBpaperthickness/2,4.5 - 0.02>
  texture { NBpapertexture }
}

#declare NBshape = union {
         object { NBcover translate <0,NBpaperthickness + NBCoverThickness,0> }
         object { NBpapershape translate <0,NBCoverThickness,0> }
         object { NBcover }
}

#declare NBdrillhole = cylinder {
         <0,-0.1,0>,<0,2,0>, sp_x_offset/3
         translate <sp_x_offset/5,0,SpRadius*0.83>
}

#declare NBholes = union {
         object { NBdrillhole translate < 0 * sp_x_offset,0,0> }
         object { NBdrillhole translate < 1 * sp_x_offset,0,0> }
         object { NBdrillhole translate < 2 * sp_x_offset,0,0> }
         object { NBdrillhole translate < 3 * sp_x_offset,0,0> }
object { NBdrillhole translate < 4 * sp_x_offset,0,0> }
object { NBdrillhole translate < 5 * sp_x_offset,0,0> }
object { NBdrillhole translate < 6 * sp_x_offset,0,0> }
object { NBdrillhole translate < 7 * sp_x_offset,0,0> }
object { NBdrillhole translate < 8 * sp_x_offset,0,0> }
object { NBdrillhole translate < 9 * sp_x_offset,0,0> }
object { NBdrillhole translate <10 * sp_x_offset,0,0> }
object { NBdrillhole translate <11 * sp_x_offset,0,0> }
object { NBdrillhole translate <12 * sp_x_offset,0,0> }
object { NBdrillhole translate <13 * sp_x_offset,0,0> }
object { NBdrillhole translate <14 * sp_x_offset,0,0> }
object { NBdrillhole translate <15 * sp_x_offset,0,0> }
object { NBdrillhole translate <16 * sp_x_offset,0,0> }
object { NBdrillhole translate <17 * sp_x_offset,0,0> }
object { NBdrillhole translate <18 * sp_x_offset,0,0> }
object { NBdrillhole translate <19 * sp_x_offset,0,0> }
object { NBdrillhole translate <20 * sp_x_offset,0,0> }
object { NBdrillhole translate <21 * sp_x_offset,0,0> }
object { NBdrillhole translate <22 * sp_x_offset,0,0> }
object { NBdrillhole translate <23 * sp_x_offset,0,0> }
object { NBdrillhole translate <24 * sp_x_offset,0,0> }
object { NBdrillhole translate <25 * sp_x_offset,0,0> }
object { NBdrillhole translate <26 * sp_x_offset,0,0> }
object { NBdrillhole translate <27 * sp_x_offset,0,0> }
object { NBdrillhole translate <28 * sp_x_offset,0,0> }
       object { NBdrillhole translate <29 * sp_x_offset,0,0> }
}


#declare NBallholes = union {
         object { NBholes }
         object { NBholes scale <-1,1,1> }
}

#declare NBFinal = difference {
         object { NBshape }
         object { NBallholes }
}

#declare NB = union {
         object { Spiral60 translate <0,SpRadius + SpThickness,0> }
         object {
                NBFinal
                rotate <1,0,0>
                translate <0,0.14,0>
         }
}
