#ifdef(Pencils_Inc_Temp)
// do nothing
#else
#declare Pencils_Inc_Temp=version
#version 3.0

// pencils.inc - include file for colored pencils
//
// A pencil is a round object 6 inches long and 1/8 inches in radius.
// The point is a cone 1/2" in length.  Total length is 6.5", and total
// circumference is 0.7854".
// The radial composition of writing stuff, wood, and paint is handled
// with a radial texture-map.  The label on the outside of the pencil
// is handled with a material_map of map_type 2.

#include "school1.inc"


#declare PencilBasicShape = merge {
  cylinder { <0,PencilPointLength,0>, <0,PencilTotalLength,0>
		PencilRadius }
  cone { <0,0,0>, PencilPointRadius
	 <0,PencilPointLength,0>, PencilRadius }
}

#declare PencilLabelTexture = texture { 
  pigment { P_Brass4 } finish { F_MetalD ambient BasicAmbient } 
}
#declare PencilWoodTexture = texture {
  pigment { 
    wood
    turbulence 1.1
    color_map {
        [0.0, 0.8 color rgb <0.88, 0.60, 0.30>
                  color rgb <0.88, 0.60, 0.30>]
        [0.8, 1.0 color rgb <0.50, 0.340, 0.1820>
                  color rgb <0.340, 0.230, 0.120>]
    }
    scale 0.3
    rotate <45,13,9>
  }
  finish { ambient BasicAmbient diffuse BasicDiffuse*0.9 }
}

#declare PencilPaintFinish =   finish { ambient BasicAmbient diffuse BasicDiffuse * 0.7 specular 0.617 roughness 0.035 brilliance 0.1}
#declare PencilWritingFinish =   finish { ambient BasicAmbient diffuse BasicDiffuse * 1.1 phong 0.05 phong_size 20 }


// define a red colored pencil
#declare PencilPaintColor = color rgb<1.0,0.01,0.01>
#declare PencilPaintTexture = texture {
  pigment { color PencilPaintColor }
  finish { PencilPaintFinish }
}
#declare PencilWritingTexture = texture {
  pigment { color PencilPaintColor }
  finish { PencilWritingFinish }
}
#declare PencilMainTexture = texture {
    wood 
    texture_map {
      [0.0 PencilWritingTexture]
      [0.32 PencilWritingTexture]
      [0.32 PencilWoodTexture]
      [0.99 PencilWoodTexture]
      [0.99 PencilPaintTexture]
      [1.00 PencilPaintTexture]
    }
    scale <PencilRadius*2,PencilRadius*2,1>
}

#declare PencilFinalTexture = texture {
   material_map {
	gif "penciltext.gif"
	map_type 2
	texture { PencilLabelTexture }
	texture { PencilMainTexture rotate <-90,0,0>}
   }
   scale <1,PencilTotalLength,1>
}

#declare RedPencilObject = object {
   PencilBasicShape
   texture { PencilFinalTexture }
}


// define a green colored pencil
#declare PencilPaintColor = color rgb<0.01,1.0,0.01>
#declare PencilPaintTexture = texture {
  pigment { color PencilPaintColor }
  finish { PencilPaintFinish }
}
#declare PencilWritingTexture = texture {
  pigment { color PencilPaintColor }
  finish { PencilWritingFinish }
}
#declare PencilMainTexture = texture {
    wood 
    texture_map {
      [0.0 PencilWritingTexture]
      [0.32 PencilWritingTexture]
      [0.32 PencilWoodTexture]
      [0.99 PencilWoodTexture]
      [0.99 PencilPaintTexture]
      [1.00 PencilPaintTexture]
    }
    scale <PencilRadius*2,PencilRadius*2,1>
}

#declare PencilFinalTexture = texture {
   material_map {
	gif "penciltext.gif"
	map_type 2
	texture { PencilLabelTexture }
	texture { PencilMainTexture rotate <-90,0,0>}
   }
   scale <1,PencilTotalLength,1>
}

#declare GreenPencilObject = object {
   PencilBasicShape
   texture { PencilFinalTexture }
}

// define a blue colored pencil
#declare PencilPaintColor = color rgb<0.01,0.01,1.0>
#declare PencilPaintTexture = texture {
  pigment { color PencilPaintColor }
  finish { PencilPaintFinish }
}
#declare PencilWritingTexture = texture {
  pigment { color PencilPaintColor }
  finish { PencilWritingFinish }
}
#declare PencilMainTexture = texture {
    wood 
    texture_map {
      [0.0 PencilWritingTexture]
      [0.32 PencilWritingTexture]
      [0.32 PencilWoodTexture]
      [0.99 PencilWoodTexture]
      [0.99 PencilPaintTexture]
      [1.00 PencilPaintTexture]
    }
    scale <PencilRadius*2,PencilRadius*2,1>
}

#declare PencilFinalTexture = texture {
   material_map {
	gif "penciltext.gif"
	map_type 2
	texture { PencilLabelTexture }
	texture { PencilMainTexture rotate <-90,0,0>}
   }
   scale <1,PencilTotalLength,1>
}

#declare BluePencilObject = object {
   PencilBasicShape
   texture { PencilFinalTexture }
}


// define a purple colored pencil
#declare PencilPaintColor = color Med_Purple
#declare PencilPaintTexture = texture {
  pigment { color PencilPaintColor }
  finish { PencilPaintFinish }
}
#declare PencilWritingTexture = texture {
  pigment { color PencilPaintColor }
  finish { PencilWritingFinish }
}
#declare PencilMainTexture = texture {
    wood 
    texture_map {
      [0.0 PencilWritingTexture]
      [0.32 PencilWritingTexture]
      [0.32 PencilWoodTexture]
      [0.99 PencilWoodTexture]
      [0.99 PencilPaintTexture]
      [1.00 PencilPaintTexture]
    }
    scale <PencilRadius*2,PencilRadius*2,1>
}

#declare PencilFinalTexture = texture {
   material_map {
	gif "penciltext.gif"
	map_type 2
	texture { PencilLabelTexture }
	texture { PencilMainTexture rotate <-90,0,0>}
   }
   scale <1,PencilTotalLength,1>
}

#declare PurplePencilObject = object {
   PencilBasicShape
   texture { PencilFinalTexture }
}




// define a black colored pencil
#declare PencilPaintColor = color rgb<0.04,0.04,0.04>
#declare PencilPaintTexture = texture {
  pigment { color PencilPaintColor }
  finish { PencilPaintFinish }
}
#declare PencilWritingTexture = texture {
  pigment { color PencilPaintColor }
  finish { PencilWritingFinish }
}
#declare PencilMainTexture = texture {
    wood 
    texture_map {
      [0.0 PencilWritingTexture]
      [0.32 PencilWritingTexture]
      [0.32 PencilWoodTexture]
      [0.99 PencilWoodTexture]
      [0.99 PencilPaintTexture]
      [1.00 PencilPaintTexture]
    }
    scale <PencilRadius*2,PencilRadius*2,1>
}

#declare PencilFinalTexture = texture {
   material_map {
	gif "penciltext.gif"
	map_type 2
	texture { PencilLabelTexture }
	texture { PencilMainTexture rotate <-90,0,0>}
   }
   scale <1,PencilTotalLength,1>
}

#declare BlackPencilObject = object {
   PencilBasicShape
   texture { PencilFinalTexture }
}


#version Pencils_Inc_Temp
#end
