// room.inc - POV include file for the schoolroom
//
// The classroom consists of a rectangular room, 36' by 24' by 11'.
// It has walls painted some neutal color, a wooden slat floor,
// a 3" floor molding, and a 7" chair rail at 4' off the floor.
// The walls of the room are 5" thick.  There is chairrail molding
// only on the east and west walls.
// 
// In one wall of the room, about 3' off the floor, is a window
// which is 3.5' by 5'.  The frame of the window is painted white
// with a glossy paint.  The moldings of the window are about 2"
// in width, and 7" thick (ie. they stick out from the wall by 1")
// The window glass consists of two panes.  Each pane is half the
// size of the whole (inner) window, 28" high by 38" wide.  The
// frame of each window is 1.5" square.
//


#include "school1.inc"


// ****************************************************************
// First, the basic box of the room itself

#declare RoomBoxBasisPre1 = box {
  <-RoomWallThickness,-RoomWallThickness,-RoomWallThickness>,
  <RoomWidth+RoomWallThickness,RoomHeight+RoomWallThickness,RoomLength+RoomWallThickness>
}

#declare RoomBoxBasisPre2 = box {
  <0,0 -(2*BasicFudge),0>,<RoomWidth,RoomHeight+BasicFudge,RoomLength>
}

#declare RoomBoxBasis = difference { 
  object { RoomBoxBasisPre1 }
  object { RoomBoxBasisPre2 }
  translate <-RoomGlobePositionX, 0, -RoomGlobePositionZ>
}


// ****************************************************************
// more about the walls

#declare RoomWallTexture = texture {
  pigment {
    gradient z
      color_map {
        [0.0 color rgb<0.912,0.903,0.651>]
        [0.44 color rgb<0.912,0.903,0.651>]
	[0.77 color rgb<0.903,0.890, 0.63>]
	[1.00 color rgb<0.912,0.903,0.650>]
      }
  }
  finish {
    ambient BasicAmbient diffuse BasicDiffuse 
  }
  scale 0.55
  rotate <0,43,1>
}

#declare RoomWalls = object {
  RoomBoxBasis
  texture { RoomWallTexture }
}


// ****************************************************************
// floor and floorboard stuff here 

#declare RoomFloorBox = box {
  <0,-(2*BasicFudge),0>, <RoomWidth,0 -(BasicFudge/3),RoomLength>
  texture {
    pigment { color Black }
    finish { ambient 1 }
  }
  translate <-RoomGlobePositionX, 0, -RoomGlobePositionZ>
}  



#declare RoomFloorBasicPigment = pigment {
  // this is similar to POV's default T_Wood35 underlayer
    wood
    turbulence 0.04
    omega 0.667
    lambda 2.5
    color_map {
            [0.250 color rgbf <1.00000, 0.54373, 0.11665, 0.000>]
            [0.350 color rgbf <0.66275, 0.28607, 0.00000, 0.000>]
            [0.525 color rgbf <1.00000, 0.54363, 0.11715, 0.000>]
            [0.600 color rgbf <0.66475, 0.28647, 0.00000, 0.000>]
            [0.750 color rgbf <1.00000, 0.54354, 0.11565, 0.000>]
            [0.850 color rgbf <0.66275, 0.28667, 0.00000, 0.000>]
            [1.000 color rgbf <1.00000, 0.54143, 0.11795, 0.000>]
    }
    scale <0.91,1.25,1>
}



#declare RoomFloorBoardsPre = union {
#include "floorboards.inc"
}

#declare RoomFloorBoards = object {
  RoomFloorBoardsPre
  translate <-RoomGlobePositionX, 0, -RoomGlobePositionZ>
}

#declare RoomFloor = union {
  object { RoomFloorBox }
  object { RoomFloorBoards }
}

// ****************************************************************
// floor molding stuff here 

#declare BasicGlossyMoldingPaintTexture = texture {
    pigment { color White }
    finish { ambient BasicAmbient*0.9 diffuse BasicDiffuse*0.56
	       specular 0.38 roughness 0.03 }
}

#declare GlossyMoldingPaintTexture =
texture {
  BasicGlossyMoldingPaintTexture
}
texture {
    pigment { bozo 
		color_map {
			[0.0 color Clear]
			[0.991 color Clear]
			[0.995 color Gray80]
			[1.0   color Gray75]
		}
		turbulence 2.05
		octaves 2
		scale 2.6
    }
    finish { ambient BasicAmbient*0.9 diffuse BasicDiffuse*0.6 }
}


#declare RoomFloorMoldingBasicShape = union {
  box { 
    <-RoomFloorMoldingThickness,0,0>,<RoomFloorMoldingThickness,RoomFloorMoldingHeight-RoomFloorMoldingThickness,1>
  }
  cylinder {
    <0,RoomFloorMoldingHeight-RoomFloorMoldingThickness,0>,
    <0,RoomFloorMoldingHeight-RoomFloorMoldingThickness,1>
    RoomFloorMoldingThickness
  }
}

#declare RoomFloorMoldingBasic = object {
  RoomFloorMoldingBasicShape
}

#declare RoomFloorMoldingWest = object {
  RoomFloorMoldingBasic
  scale <1,1, RoomLength>
  translate <-RoomGlobePositionX, 0, -RoomGlobePositionZ>
  texture { GlossyMoldingPaintTexture }
}

#declare RoomFloorMoldingEast = object {
  RoomFloorMoldingBasic
  scale <1,1, RoomLength>
  translate <RoomWidth,0,0>
  translate <-RoomGlobePositionX, 0, -RoomGlobePositionZ>
  texture { GlossyMoldingPaintTexture }
}
 
#declare RoomFloorMoldingSouth = object {
  RoomFloorMoldingBasic
  scale <1,1, RoomWidth>
  rotate <0,90,0>
  translate <-RoomGlobePositionX, 0, -RoomGlobePositionZ>
  texture { GlossyMoldingPaintTexture }
}

#declare RoomFloorMoldingNorth = object {
  RoomFloorMoldingBasic
  scale <1,1, RoomWidth>
  rotate <0,90,0>
  translate <0,0, RoomLength>
  translate <-RoomGlobePositionX, 0, -RoomGlobePositionZ>
  texture { GlossyMoldingPaintTexture }
}
	       
// ****************************************************************
// chairrail molding stuff here 

#declare RoomChairRailBasicPre1 = prism {
  linear_sweep
  linear_spline
  -1, 0,
  11,
  <0,0>, 
  <0.2, 0>
  <RoomChairRailThickness, RoomChairRailThickness/2>
  <RoomChairRailThickness,RoomChairRailHeight - 0.2>,
  <RoomChairRailThickness - 0.2, RoomChairRailHeight>,
  <0, RoomChairRailHeight>, 
  <-(RoomChairRailThickness - 0.2), RoomChairRailHeight>,
  <-(RoomChairRailThickness),RoomChairRailHeight - 0.2>,
  <-(RoomChairRailThickness), RoomChairRailThickness/2>
  <-0.2, 0>
  <0,0>
}

#declare RoomChairRailBasicPre2 = union {
  object {
    RoomChairRailBasicPre1
    rotate <-90,0,0>
  }
  cylinder {
    <0,0,0>,<0,0,1>,RoomChairRailHeight/7
    scale <1.1,1.45,1>
    translate <RoomChairRailThickness *  0.49,RoomChairRailHeight * 0.61,0>
  }
  cylinder {
    <0,0,0>,<0,0,1>,RoomChairRailHeight/7
    scale <1,1.45,1>
    translate <RoomChairRailThickness * -0.49,RoomChairRailHeight * 0.61,0>
  }
}


#declare RoomChairRailBasic = object {
  RoomChairRailBasicPre2
  translate <0, RoomChairRailPosition, 0>
}

#declare RoomChairRailMoldingWest = object {
  RoomChairRailBasic
  scale <1,1, RoomLength>
  translate <-RoomGlobePositionX, 0, -RoomGlobePositionZ>
  texture { GlossyMoldingPaintTexture }
}

#declare RoomChairRailMoldingEast = object {
  RoomChairRailBasic
  scale <1,1, RoomLength>
  translate <RoomWidth,0,0>
  translate <-RoomGlobePositionX, 0, -RoomGlobePositionZ>
  texture { GlossyMoldingPaintTexture }
}

#declare RoomChairRailMoldingNorth = object {
  RoomChairRailBasic
  rotate <0,90,0>
  scale <BlackboardLLXPosition,1,1>
  translate <0,0, RoomLength>
  translate <-RoomGlobePositionX, 0, -RoomGlobePositionZ>
  texture { GlossyMoldingPaintTexture }
}



// ****************************************************************
// final room shape (with textures but no window yet) goes here

#declare BasicRoom = union {
  object { RoomWalls }
  object { RoomFloor }
  object { RoomFloorMoldingNorth }
  object { RoomFloorMoldingWest }
  object { RoomFloorMoldingEast }
  // object { RoomFloorMoldingSouth }
  object { RoomChairRailMoldingNorth }
  object { RoomChairRailMoldingWest }
  object { RoomChairRailMoldingEast }
  // object { RoomChairRailMoldingSouth }
}


// ****************************************************************
// define stuff for the window

#declare BasicWindowShape = box {
  <-RoomWindowFrameThickness/2,0,0>,
  <RoomWindowFrameThickness/2,RoomWindowHeight,RoomWindowWidth>
}

#declare BasicWindowFrameShapePre = difference {
  object { BasicWindowShape }
  box {
    <-RoomWindowFrameThickness,RoomWindowFrameSize,RoomWindowFrameSize>,
    < RoomWindowFrameThickness,RoomWindowHeight-RoomWindowFrameSize,RoomWindowWidth-RoomWindowFrameSize>
  }
  box {
    <(RoomWindowFrameThickness/2) - 0.15 ,RoomWindowFrameSize,RoomWindowFrameSize-0.9>
    <RoomWindowFrameThickness, RoomWindowHeight - (RoomWindowFrameSize - 0.9), RoomWindowWidth - (RoomWindowFrameSize - 0.9)>
  }
  texture { BasicGlossyMoldingPaintTexture }
}

#declare BasicWindowFrameShape = union {
  object { BasicWindowFrameShapePre }
  box {  // the sill
    <0, RoomWindowFrameSize - RoomWindowSillHeight, RoomWindowFrameSize/3>,
    <RoomWindowSillExtension + (RoomWindowFrameThickness/2),
     RoomWindowFrameSize,
     RoomWindowWidth - RoomWindowFrameSize/3>
     texture { GlossyMoldingPaintTexture }
  }
}


#declare WindowFrameHole = object {
  BasicWindowShape
  scale <2,1,1>
  translate <-(RoomWallThickness/2),0,0>
  translate <0, RoomWindowLLYPosition, -RoomWindowLLXPosition>
  translate <-RoomGlobePositionX, 0, 0>
}

// take out some space for the window to slide in
#declare WindowSlideGrooveShape = box {
  <0 - BasicFudge, 
   RoomWindowFrameSize - RoomWindowSlideGrooveDepth,
   RoomWindowFrameSize - RoomWindowSlideGrooveDepth>
  <2 * RoomWindowPaneFrameSize + BasicFudge, 
   RoomWindowHeight - RoomWindowFrameSize,
   RoomWindowWidth - (RoomWindowFrameSize - RoomWindowSlideGrooveDepth)>
  texture {
    pigment { color DarkBrown }
    finish { ambient BasicAmbient * 0.9 diffuse BasicDiffuse * 0.9 }
  }
}

#declare PaintedWindowFrameShape = difference {
  object { BasicWindowFrameShape }
  object { WindowSlideGrooveShape translate <-0.7,0,0> }
}

#declare PaintedWindowFrame = object {
  PaintedWindowFrameShape
  translate <-(RoomWallThickness/2),0,0>
  translate <0, RoomWindowLLYPosition, -RoomWindowLLXPosition>
  translate <-RoomGlobePositionX, 0, 0>
}

#declare WindowPaneBasicFrameShape = difference {
  box { <0,0,0>, 
	<RoomWindowPaneFrameSize,RoomWindowPaneHeight,RoomWindowPaneWidth> 
  }
  box { <-1,RoomWindowPaneFrameSize,RoomWindowPaneFrameSize>,
	<RoomWindowPaneFrameSize+1,
	 RoomWindowPaneHeight - RoomWindowPaneFrameSize,
	 RoomWindowPaneWidth - RoomWindowPaneFrameSize>
  }
}

#declare WindowPaneFrameShape = union {
  object { WindowPaneBasicFrameShape }
  box { <-0.5,-0.5,-0.5>,<0.5,0.5,0.5>
	scale <RoomWindowPaneMuttonBarSize,RoomWindowPaneMuttonBarSize,RoomWindowPaneWidth>
	translate <RoomWindowPaneFrameSize/2, RoomWindowPaneHeight/2, RoomWindowPaneWidth/2>
  }
  box { <-0.5,-0.5,-0.5>,<0.5,0.5,0.5>
	scale <RoomWindowPaneMuttonBarSize,RoomWindowPaneHeight,RoomWindowPaneMuttonBarSize>
        translate <RoomWindowPaneFrameSize/2, RoomWindowPaneHeight/2, RoomWindowPaneWidth/2>
  }
}

#declare WindowPaneFrame = object {
  WindowPaneFrameShape
  texture { BasicGlossyMoldingPaintTexture }
}

#declare WindowPaneGlass = box {
   <-0.5,-0.5,-0.5>,<0.5,0.5,0.5>
   scale <RoomWindowPaneGlassThickness,RoomWindowPaneHeight,RoomWindowPaneWidth>
   translate <RoomWindowPaneFrameSize/2, RoomWindowPaneHeight/2, RoomWindowPaneWidth/2>
   texture { T_Old_Glass }
}

#declare WindowPaneHandle = box {
   <-0.5,-0.5,-0.5>,<0.5,0.5,0.5>
   scale <1.3, 0.5, 6>
   translate <RoomWindowPaneFrameSize, RoomWindowPaneFrameSize/2, RoomWindowPaneWidth/2>
  texture { pigment { P_Brass4 } finish { F_MetalD ambient BasicAmbient } }
}

#declare WindowPaneObject = union {
  object { WindowPaneFrame }
  object { WindowPaneGlass }
  object { WindowPaneHandle }
}

#declare OpenPaintedWindowObject = union {
  object { PaintedWindowFrameShape }
  object { WindowPaneObject 
	   translate <0, 
	              (RoomWindowFrameSize - RoomWindowSlideGrooveDepth) + RoomWindowOpenByHowMuch,
		      RoomWindowFrameSize - RoomWindowSlideGrooveDepth>
	   translate <-0.7,0,0>
	     }
  object { WindowPaneObject 
	   translate <RoomWindowPaneFrameSize,
	              (RoomWindowFrameSize - RoomWindowSlideGrooveDepth) + (RoomWindowPaneHeight - RoomWindowPaneFrameSize),
		      RoomWindowFrameSize - RoomWindowSlideGrooveDepth>
	   translate <-0.7,0,0>
         }
}

#declare OpenPaintedWindow = object {
  OpenPaintedWindowObject
  translate <-(RoomWallThickness/2),0,0>
  translate <0, RoomWindowLLYPosition, -RoomWindowLLXPosition>
  translate <-RoomGlobePositionX, 0, 0>
}

#declare ClosedPaintedWindowObject = union {
  object { PaintedWindowFrameShape }
  object { WindowPaneObject 
	   translate <0, 
	              (RoomWindowFrameSize - RoomWindowSlideGrooveDepth) + 0.03,
		      RoomWindowFrameSize - RoomWindowSlideGrooveDepth>
	   translate <-0.7,0,0>
	     }
  object { WindowPaneObject 
	   translate <RoomWindowPaneFrameSize,
	              (RoomWindowFrameSize - RoomWindowSlideGrooveDepth) + (RoomWindowPaneHeight - RoomWindowPaneFrameSize),
		      RoomWindowFrameSize - RoomWindowSlideGrooveDepth>
	   translate <-0.7,0,0>
         }
}

#declare ClosedPaintedWindow = object {
  ClosedPaintedWindowObject
  translate <-(RoomWallThickness/2),0,0>
  translate <0, RoomWindowLLYPosition, (-RoomWindowLLXPosition) - (RoomWindowWidth + RoomClosedWindowZOffset)>
  translate <-RoomGlobePositionX, 0, 0>
}

