#ifdef(Table_Inc_Temp)
// do nothing
#else
#declare Table_Inc_Temp=version
#version 3.0


// table.inc - POV include file for the student desk tabletop
//
// The tabletop has a formica surface using my favorite formica1
// texture, scaled way down, and sporting rounded rim.
// The bulk material of the tabletop is particle board, a 
// granite of brown, dark brown, and tan.   The texturing is done
// using a material_map on a y gradient.
//
// The tabletop is 25" long and 14" wide and 0.75" thick.
// 


#declare TableInitBasicShape = union {
  box { <-0.5,-0.5,-0.5>,<0.5,0.5,0.5>
	scale <TableWidth, TableInitialThickness, TableLength - 2*TableCornerRadius>
  }
  box { <-0.5,-0.5,-0.5>,<0.5,0.5,0.5>
	scale <TableWidth - 2*TableCornerRadius, TableInitialThickness, TableLength>
  }

  cylinder { <0,-0.5,0>, <0,0.5,0>, TableCornerRadius 
	scale <1,TableInitialThickness,1>
	translate <(TableWidth/2) - TableCornerRadius, 0, (TableLength/2) - TableCornerRadius>
  }
  cylinder { <0,-0.5,0>, <0,0.5,0>, TableCornerRadius 
	scale <1,TableInitialThickness,1>
	translate <-((TableWidth/2) - TableCornerRadius), 0, (TableLength/2) - TableCornerRadius>
  }
  cylinder { <0,-0.5,0>, <0,0.5,0>, TableCornerRadius 
	scale <1,TableInitialThickness,1>
	translate <-((TableWidth/2) - TableCornerRadius), 0, -((TableLength/2) - TableCornerRadius)>
  }
  cylinder { <0,-0.5,0>, <0,0.5,0>, TableCornerRadius 
	scale <1,TableInitialThickness,1>
	translate <(TableWidth/2) - TableCornerRadius, 0, -((TableLength/2) - TableCornerRadius)>
  }

  cylinder { <0,0,-0.5>,<0,0,0.5>, (TableInitialThickness/2)/TableEdgeRadiusRatio
        scale <1, TableEdgeRadiusRatio, TableLength - 2*TableCornerRadius>
	translate <-(TableWidth/2), 0, 0>
  }
  cylinder { <0,0,-0.5>,<0,0,0.5>, (TableInitialThickness/2)/TableEdgeRadiusRatio
        scale <1, TableEdgeRadiusRatio, TableLength - 2*TableCornerRadius>
	translate <(TableWidth/2), 0, 0>
  }

  cylinder { <-0.5,0,0>,<0.5,0,0>, (TableInitialThickness/2)/TableEdgeRadiusRatio
        scale <TableWidth - 2*TableCornerRadius, TableEdgeRadiusRatio, 1>
	translate <0, 0, -(TableLength/2)>
  }
  cylinder { <-0.5,0,0>,<0.5,0,0>, (TableInitialThickness/2)/TableEdgeRadiusRatio
        scale <TableWidth - 2*TableCornerRadius, TableEdgeRadiusRatio, 1>
	translate <0, 0, (TableLength/2)>
  }
    
  torus { TableCornerRadius, (TableInitialThickness/2)/TableEdgeRadiusRatio
	  scale <1, TableEdgeRadiusRatio, 1>
	  translate <-((TableWidth/2) - TableCornerRadius), 0, -((TableLength/2) - TableCornerRadius)>
  }
  torus { TableCornerRadius, (TableInitialThickness/2)/TableEdgeRadiusRatio
	  scale <1, TableEdgeRadiusRatio, 1>
	  translate <((TableWidth/2) - TableCornerRadius), 0, -((TableLength/2) - TableCornerRadius)>
  }
  torus { TableCornerRadius, (TableInitialThickness/2)/TableEdgeRadiusRatio
	  scale <1, TableEdgeRadiusRatio, 1>
	  translate <((TableWidth/2) - TableCornerRadius), 0, ((TableLength/2) - TableCornerRadius)>
  }
  torus { TableCornerRadius, (TableInitialThickness/2)/TableEdgeRadiusRatio
	  scale <1, TableEdgeRadiusRatio, 1>
	  translate <-((TableWidth/2) - TableCornerRadius), 0, ((TableLength/2) - TableCornerRadius)>
  }
}



#declare TableBasicShape = intersection {
  object { TableInitBasicShape }
  box { <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
	scale <TableWidth + 3*TableCornerRadius, TableFinalThickness, TableLength + 3*TableCornerRadius>
  }
}


// ****************************************************************
// multilayers texture for the table

#declare formica1 = pigment {
	image_map {
	 	png "formica1.png"
	}
	scale 4
}


#declare formicatexture_clean = 
texture {
    pigment { formica1 }
    finish  { ambient BasicAmbient diffuse BasicDiffuse specular 0.09 roughness 0.005 }
    rotate <90,0,0>
    // scale 0.95
}
texture {
    pigment {
	    granite
	    turbulence 0.48
	    color_map {
		  [0.00, 0.979 color Clear color Clear]
		  [0.979 ,0.981 color Clear color rgbf<0.45,0.45,0.15,0.35> ]
		  [0.981, 0.994 color rgbf<0.3,0.3,0.15,0.25> color Gray90 ]
		  [0.994, 1.00 color Gray90 color Black]
	     }
	}
    finish { ambient BasicAmbient diffuse 0.6 }
    scale 2.1
}

#declare particle_board_pigment = 
pigment {
    granite
    turbulence 0.9
    color_map {
      [0.0 0.3 color DarkBrown color DarkBrown]
      [0.3 0.31 color DarkBrown color Tan]
      [0.31 0.5 color Tan color Tan]
      [0.5 0.51 color Tan color Brown]
      [0.51 0.6 color Brown color Tan]
      [0.6 0.8  color Tan color Tan]
      [0.8 0.81 color Tan color DarkBrown]
      [0.81 0.98 color DarkBrown color DarkBrown]
      [0.98 1.0  color DarkBrown color Tan]
    }
    scale 0.9
}

#declare particle_board_texture =
texture {
  pigment { particle_board_pigment }
  finish { ambient BasicAmbient diffuse 0.6 specular 0.12 roughness 0.0005 }
}

#declare TableTestObject = object {
  TableBasicShape 
  texture {
       formicatexture_clean
  }
  translate <TableWidth/2, TableFinalThickness / 2, TableLength/2>
}


#declare TableVerticalTexture = texture {
  gradient y
  texture_map {
      [0.0 formicatexture_clean]
      [0.1 formicatexture_clean]
      [0.1 particle_board_texture]
      [0.9 particle_board_texture]
      [0.9 formicatexture_clean]
      [1.0 formicatexture_clean]
  }
  scale <1,TableFinalThickness,1>
}


#declare TableObject = object {
  TableBasicShape
  translate <TableWidth/2, TableFinalThickness / 2, TableLength/2>
  texture { TableVerticalTexture }
}




#version Table_Inc_Temp
#end
