// test of book object


// povray include files
#include "school1.inc"

#include "book1.inc"

// define some lights

light_source {
    <-30000,40000,-20000>
    color rgb<1.0,1.0,0.9>
}

light_source {
    <40,120,-36>
    color rgb<0.75,0.85,0.99>
    area_light <12,0,0>,<0,0,48>,2,5
    adaptive 1
    jitter
}


camera {
   location <0,60,-108>
   look_at  <0,(0.79 * GlobeCenterHeight),0>
   angle 40
}

// some useful textures and stuff


// put the object or objects to be tested here

object {
	BookTest
	rotate <-29,64,6>
	scale 6
	translate <0,23,0>
}




// starry sky for a background
sky_sphere {
   // adapted from Jim Burton's Starfield texture
   pigment {
      granite
      color_map {
	 [0.00 0.81 color Black color Black]
	 [0.82 0.85 color Gray80 color Gray90]
	 [0.85 0.88 color Gray90 color Gray95]
	 [0.88 0.91 color Gray95 color White]
	 [0.91 1.00 color Black color Black]
      }
      scale 0.02
      translate -1
   }
}

// tile floor to sit on
box {
   <-160,-12,-100>,<160,0,100>
   texture {
     pigment { hexagon
		 pigment { color Red }
                 pigment { color CadetBlue }
                 pigment { color SeaGreen }
     }
     finish { diffuse 0.6 ambient BasicAmbient phong 0.3 }
     scale 5
   }
}
