// test of globe object


// povray include files
#include "school1.inc"

#include "globe.inc"
#include "book1.inc"

// define some lights

light_source {
    <0,0,0>
    color rgb<1.0,1.0,0.9>
    looks_like { sphere { <0,0,0>, 150000 } }
    translate <0,3000,-270000>

}

camera {
   location <CameraLocationX,CameraLocationY/15,CameraLocationZ> * 0.5
   look_at  <0,0,0>
   angle 29.
}

// some useful textures and stuff

#declare GlobeBody2 = sphere
{
   <0,0,0>,1
   texture {
     GlobeContentTexture
   }
      
   scale GlobeRadius
}

#declare GlobeAir = sphere
{
   <0,0,0>,1.012
   texture {
      pigment {
	 bozo
	 turbulence 2.4
	 octaves 7
	 // lambda 2.1
	 omega 0.89
	 color_map {
	     [0.0 color rgbt<.985,.985,.99,.18>] 
	     [0.1 color rgbt<1,1,1,0.18>]
	     [0.36 color rgbt<1,1,1,0.27>]
	     [0.36 0.43 rgbt<1,1,1,0.27> color Clear]
	     [0.43 1.0  color Clear color Clear]           
	 }
	 scale <2.3,0.3,2.3>
	 scale 3.4
	 warp { black_hole <0,-0.1,-1>, 0.53 }
	 warp { black_hole <1,0.1,0>, 0.533 }
	 warp { black_hole <-0.7,-0.4,-0.03>, 0.633 }
      }
      finish {
	  ambient 0.7
	  diffuse 1
	  brilliance 4
	  // specular 0.0025
	  // roughness 0.1
      }
   }
   scale GlobeRadius
}


union {
   object { GlobeBody2 }
   object { GlobeAir }
   rotate GlobeRotation1
   rotate GlobeRotation2
}

// starry sky for a background
sky_sphere {
   // adapted from Jim Burton's Starfield texture
   pigment {
      granite
      color_map {
	 [0.00 0.81 color Black color Black]
	 [0.82 0.85 color Gray80 color Gray90]
	 [0.85 0.88 color Gray90 color Gray95]
	 [0.88 0.91 color Gray95 color White]
	 [0.91 1.00 color Black color Black]
      }
      scale 0.02
      translate -1
   }
}

