// test of room and globe objects


// povray include files
#include "school1.inc"

#include "globe.inc"
#include "book1.inc"
#include "notebook1.inc"
#include "room.inc"
#include "apple1.inc"
#include "blackboard.inc"
#include "table.inc"
#include "pencils.inc"

// define some lights

// light_source {
//     <-16,43,-155>
//     color rgb<0.56,0.63,0.62>
//     fade_distance 80
//     fade_power 1
// }

light_source {
    <35,110,-48>
    color rgb<0.875,0.915,0.99>
    area_light <12,0,0>,<0,0,48>,2,5
    adaptive 1
    fade_distance 70
    fade_power 1
}

light_source {
    <35,110,-198>
    color rgb<0.875,0.915,0.99>
    area_light <12,0,0>,<0,0,12>,2,2
    adaptive 1
    fade_distance 70
    fade_power 1
}

light_source {
    <-194000, 102000, -107000> 
    color rgb<1.00,1.00,0.40>
}


camera {
   location <CameraLocationX, CameraLocationY, CameraLocationZ>
   look_at  CameraCenterPoint
   angle    CameraAngle
}

// some useful textures and stuff

// #declare NBcovercolor = SeaGreen
#declare NBcovercolor = Tan

#declare NBcovertexture1 = texture {
     pigment { bozo
               color_map {
                         [0.0 color NBcovercolor]
                         [0.69 color NBcovercolor]
                         [0.9  color White]
                         [1  color White]
                        }
                turbulence 1.05
                octaves 4
                scale 0.39
             }
     finish { ambient BasicAmbient diffuse BasicDiffuse phong 0.3 phong_size 50 }
}

#declare NBcovertexture2 = texture {
     pigment { color LightGray }
     normal { dents scale <0.5,0.06,0.5> }
     finish { ambient 0.2 diffuse 0.85 }
}

#declare NBcovertexturepre = texture {
         gradient y
         texture_map {
                     [0.00 NBcovertexture1]
                     [0.05 NBcovertexture1]
                     [0.07 NBcovertexture2]
                     [0.93 NBcovertexture2]
                     [0.95 NBcovertexture1]
                     [1.00 NBcovertexture1]
         }
}

#declare NBcover = object {
         NBcover1pre
         texture { NBcovertexturepre scale <1,NBCoverThickness,1> }
}

#declare NBthickness = 1.4 * SpRadius
#declare NBpaperthickness = NBthickness - 2*NBCoverThickness

#declare NBpapertexture = texture {
         pigment {
                 gradient y
                 color_map {
                           [0.0 color White]
                           [0.23 color White]
                           [0.4 color Blue]
                           [0.5 color Blue]
                           [0.6 color White]
                           [1.0 color White]
                 }
                 scale <1,0.02,1>
         }
         normal { gradient y scale <1,0.02,1> }
         finish { ambient 0.2 diffuse 0.82 }
}

#declare NBpapershape = superellipsoid {
  <0.1,     0.1>
  translate <0,1,1>
  scale <31*sp_x_offset - 0.02,NBpaperthickness/2,4.5 - 0.02>
  texture { NBpapertexture }
}

#declare NBshape = union {
         object { NBcover translate <0,NBpaperthickness + NBCoverThickness,0> }
         object { NBpapershape translate <0,NBCoverThickness,0> }
         object { NBcover }
}

#declare NBFinal = difference {
         object { NBshape }
         object { NBallholes texture { NBcovertexture2 } }
}

#declare NB = union {
         object { Spiral60 translate <0,SpRadius + SpThickness,0> }
         object {
                NBFinal
                rotate <1,0,0>
                translate <0,0.1,0>
         }
}


// put the object or objects to be tested here

#declare ExtraGlobeOffset = <-3,0,0>

#declare FullRoomObject = union {
  difference {
    object { BasicRoom }
    object { WindowFrameHole }
    object { WindowFrameHole translate <0,0, - (RoomWindowWidth + RoomClosedWindowZOffset)> }
    object { WindowFrameHole translate <0,0, - (RoomWindowWidth + RoomClosedWindowZOffset + RoomWindowWidth + RoomClosedWindowZOffset)> }
  }
  object { OpenPaintedWindow translate <0.2,0,0> }
  object { ClosedPaintedWindow translate <0.2,0,0> }
  object { ClosedPaintedWindow translate <0.2,RoomWindowWidth + RoomClosedWindowZOffset,0> }
}

union {
  object { FullRoomObject }
  object { FullBlackboardObject translate <0,0,-0.4> }
}

object {
  TableObject 
  translate <TableXLocation, TableYLocation, TableZLocation>
}

object {
     GlobeFinalObject
     translate ExtraGlobeOffset
}


object { NB
        rotate <0,73,0>
        scale 1.2
        translate <TableXLocation + 2.74, TableYLocation + TableFinalThickness, TableZLocation + 8>
}
object {
       BookTest
       scale 1.2
       rotate <0,70,0>
       translate <TableXLocation + 2.68 + 5, 
	           TableYLocation + TableFinalThickness + (NBthickness * 1.2) + 0.01,
	           TableZLocation + 8 + 0.5>
}

object {
       WholeApple
       scale 1.1
       translate <TableXLocation + 6.36
	           TableYLocation + TableFinalThickness,
	           TableZLocation + (TableLength - 2.75)>
}

object {
       RedPencilObject
       rotate <0,-101,0>
       rotate <90,0,0>
       translate <0,PencilRadius,0>
       scale 1.2
       rotate <0,1,0>
       translate <TableXLocation,TableYLocation + TableFinalThickness,TableZLocation>
       translate <0.3,0,1.5>
}
object {
       GreenPencilObject
       rotate <90,0,0>
       rotate <0,0,-104>
       translate <0,PencilRadius,0>
       scale 1.2
       rotate <0,-3,0>
       translate <TableXLocation,TableYLocation + TableFinalThickness,TableZLocation>
       translate <1.3,0,2.0>
}
object {
       BluePencilObject
       rotate <90,0,0>
       rotate <0,0,-97>
       rotate <0,180,0>
       translate <0,PencilRadius,PencilTotalLength>
       scale 1.2
       rotate <0,-2,0>
       translate <TableXLocation,TableYLocation + TableFinalThickness,TableZLocation>
       translate <1.87,0,0.5>
}
object {
       BlackPencilObject
       rotate <90,0,0>
       rotate <0,0,-24>
       translate <0,PencilRadius,0>
       scale 1.2
       rotate <0,-16,0>
       translate <TableXLocation + 1.85,TableYLocation + TableFinalThickness,TableZLocation + 8>
       translate <0.99,NBthickness * 1.2,1>
}





object {
       BookTest
       scale 1.2
       rotate <0,94,0>
       translate <1.25, GlobeStandBaseHeight + GlobeStandBaseThickness, -6>
       translate ExtraGlobeOffset
}
object {
       BookTest
       scale 1.2
       rotate <0,-7,0>
       translate <-5.75, GlobeStandBaseHeight + GlobeStandBaseThickness, 1.2>
       translate ExtraGlobeOffset
}
object {
       BookTest
       scale 1.2
       rotate <0,83,0>
       translate <1.1, GlobeStandBaseHeight + GlobeStandBaseThickness + BookOverallThickness + 0.02, -5.6>
       translate ExtraGlobeOffset
}


// grass for the ground
sphere { 
  <0, -60005, 0>, 60000
  texture { pigment { ForestGreen }
	   normal { bumps 0.6 scale <0.12,0.6,0.12> }
	   finish { ambient BasicAmbient diffuse (0.9-BasicAmbient) 
		    specular 0.31 roughness 0.001
		    brilliance 4
		  }
  }
}


// summer sky for a background
sky_sphere {
  pigment { bozo
     turbulence 0.875
     octaves 5
     omega 0.78
     lambda 2.3
     color_map {
      [0.0 color SkyBlue]
      [0.6 color SkyBlue]
      [0.775 color White]
      [0.95 color White]
      [0.98 color Gray95]
      [1.00 color Gray90]
     }
  }
  scale <0.36, 0.113, 1.0>
}

