// Test file for the spiral-bound notebook

#include "school1.inc"
#include "notebook1.inc"


#declare FullView = camera
{
  location  <0.0 , 16.5 ,-29.9>
  look_at   <0.0 , 0.0 , 0.0>
  angle 29.1
}

#declare CloseUp = camera
{
  location <-3, 7, -11>
  look_at <-3.1, 0, 0>
  angle 30
}

camera { FullView }


// Create an infinite sphere around scene and allow any texture on it
sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [0.87 color rgb 1] }
  }
}

// An area light (creates soft shadows)
light_source
{
  0*x // light's position (translated below)
  color rgb<0.55,0.79,0.891> // light's color
  area_light
  <12, 0, 0> <0, 0, 1> // lights spread out across this distance (x * z)
  5, 2                // total number of lights in grid (4x*4z = 16 lights)
  translate <0, 69, 50>   // <x y z> position of light
}


// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 0.9  blue 0.70  // light's color
  translate <20, 140, -290>
}



// create a box that extends between the 2 specified points
box
{
  <-24, -1, -19>  // one corner position <X1 Y1 Z1>
  < 24,  0,  10>  // other corner position <X2 Y2 Z2>
  texture {
          pigment { Tan_Wood }
          // normal { bumps }
          finish { ambient 0.2 diffuse 0.6 specular 0.4 roughness 0.01 }
  }
}


object { NB
         rotate <0,79,0>
         translate <-6.55,0,-1.25>
}

#declare NBcovercolor = SeaGreen

#declare NBcovertexture1 = texture {
     pigment { bozo
               color_map {
                         [0.0 color NBcovercolor]
                         [0.66 color NBcovercolor]
                         [0.9  color White]
                         [1  color White]
                        }
                turbulence 0.99
                octaves 3
                scale 0.4
             }
     finish { ambient 0.2 diffuse 0.8 phong 0.3 phong_size 50 }
}

#declare NBcovertexture2 = texture {
     pigment { color LightGray }
     normal { dents scale <0.5,0.06,0.5> }
     finish { ambient 0.2 diffuse 0.85 }
}

#declare NBcovertexturepre = texture {
         gradient y
         texture_map {
                     [0.00 NBcovertexture1]
                     [0.05 NBcovertexture1]
                     [0.07 NBcovertexture2]
                     [0.93 NBcovertexture2]
                     [0.95 NBcovertexture1]
                     [1.00 NBcovertexture1]
         }
}

#declare NBcover = object {
         NBcover1pre
         texture { NBcovertexturepre scale <1,NBCoverThickness,1> }
}

#declare NBthickness = 1.4 * SpRadius
#declare NBpaperthickness = NBthickness - 2*NBCoverThickness

#declare NBpapertexture = texture {
         pigment {
                 gradient y
                 color_map {
                           [0.0 color White]
                           [0.23 color White]
                           [0.4 color Blue]
                           [0.5 color Blue]
                           [0.6 color White]
                           [1.0 color White]
                 }
                 scale <1,0.02,1>
         }
         normal { gradient y scale <1,0.02,1> }
         finish { ambient 0.2 diffuse 0.82 }
}

#declare NBpapershape = superellipsoid {
  <0.1,     0.1>
  translate <0,1,1>
  scale <31*sp_x_offset - 0.02,NBpaperthickness/2,4.5 - 0.02>
  texture { NBpapertexture }
}

#declare NBshape = union {
         object { NBcover translate <0,NBpaperthickness + NBCoverThickness,0> }
         object { NBpapershape translate <0,NBCoverThickness,0> }
         object { NBcover }
}

#declare NBFinal = difference {
         object { NBshape }
         object { NBallholes }
}

#declare NB = union {
         object { Spiral60 translate <0,SpRadius + SpThickness,0> }
         object {
                NBFinal
                rotate <1,0,0>
                translate <0,0.14,0>
         }
}

object { NB
         rotate <0,-1,0>
         translate <1,NBthickness,-3.5>
}


#declare NBcovercolor = Red

#declare NBcovertexture1 = texture {
     pigment { color NBcovercolor }
     finish { ambient 0.2 diffuse 0.8 phong 0.3 phong_size 50 }
}

#declare NBcovertexture2 = texture {
     pigment { color LightGray }
     normal { dents scale <0.5,0.06,0.5> }
     finish { ambient 0.2 diffuse 0.85 }
}

#declare NBcovertexturepre = texture {
         gradient y
         texture_map {
                     [0.00 NBcovertexture1]
                     [0.05 NBcovertexture1]
                     [0.07 NBcovertexture2]
                     [0.93 NBcovertexture2]
                     [0.95 NBcovertexture1]
                     [1.00 NBcovertexture1]
         }
}

#declare NBcover = object {
         NBcover1pre
         texture { NBcovertexturepre scale <1,NBCoverThickness,1> }
}

#declare NBthickness = 1.4 * SpRadius
#declare NBpaperthickness = NBthickness - 2*NBCoverThickness

#declare NBpapertexture = texture {
         pigment {
                 gradient y
                 color_map {
                           [0.0 color White]
                           [0.23 color White]
                           [0.4 color Blue]
                           [0.5 color Blue]
                           [0.6 color White]
                           [1.0 color White]
                 }
                 scale <1,0.02,1>
         }
         normal { gradient y scale <1,0.02,1> }
         finish { ambient 0.2 diffuse 0.82 }
}

#declare NBpapershape = superellipsoid {
  <0.1,     0.1>
  translate <0,1,1>
  scale <31*sp_x_offset - 0.02,NBpaperthickness/2,4.5 - 0.02>
  texture { NBpapertexture }
}

#declare NBshape = union {
         object { NBcover translate <0,NBpaperthickness + NBCoverThickness,0> }
         object { NBpapershape translate <0,NBCoverThickness,0> }
         object { NBcover }
}

#declare NBFinal = difference {
         object { NBshape }
         object { NBallholes }
}

#declare NB = union {
         object { Spiral60 translate <0,SpRadius + SpThickness,0> }
         object {
                NBFinal
                rotate <1,0,0>
                translate <0,0.14,0>
         }
}

object { NB
         rotate <0,183,0>
         translate <7,0,10>
}


