// Fichero de POVRAY 3 por:
// POVRAY 3 file by:
//  Guillermo S. Romero

// E-mail:     famrom@ran.es
// Snail-mail: P.O.Box 35099-28080 Madrid (Espaa)

// Este fichero contiene:
//  Una clase.
//--
// This file contains:
//  A class room.

// ** IMPORTANT ** Wrong use can cause errors, I decline ALL responsability.
// INCLUDE FLAGS
//  RoomLights :
// For multiple "include"s of this file use multiple flags, think about this
//  condition as arguments required by functions.

global_settings { assumed_gamma 2.4 }
background {Blue}

#declare Chair =
    union {
        box { <-.2, .45, -.2>, <.2, .5, .2> } // Seat
        box { <-.2, .6, .18>, <.2, .89, .2> } // Back
        union {
            cylinder { <-.2, 0, -.2>, <-.2, .5, -.2>, .0125 }
            cylinder { <-.2, 0, .2>, <-.2, .9, .2>, .0125 }
            cylinder { <.2, 0, -.2>, <.2, .5, -.2>, .0125 }
            cylinder { <.2, 0, .2>, <.2, .9, .2>, .0125 }
            texture {
                T_Silver_3C
                normal { dents .01    scale .015 }
            }
        }
        texture {
            pigment { DarkGreen }
            normal { wrinkles .2    scale .125 }
            finish { specular .2    roughness .1 }
        }
        rotate -100*y
        translate <-4.5, .3, -1.5>
    }

#declare Leg =
    box {
        <-.025, 0, -.025>, <.025, .775, .025>
        texture {
            pigment { DarkTurquoise }
            normal { bumps .05 scale .01 }
            finish { phong .5    phong_size 50 }
        }
    }

#declare TeacherDesk =
    union {
        box { <-1, .775, -.5>, <1, .8, .5> } // Surface
        union {
            box { <-.9, .3, -.5>, <-.5, .7, .5> } // Drawer
            box { <-.5, .35, -.4>, <.925, .7, -.35> } // Cover
            texture {
                pigment { Silver }
                normal { bumps .05    scale .01 }
                finish { phong .4    phong_size 60 }
            }
        }
        object { Leg translate <-.9, 0, -.4> }
        object { Leg translate <-.9, 0, .4> }
        object { Leg translate <.9, 0, -.4> }
        object { Leg translate <.9, 0, .4> }
        texture {
            pigment {
                P_WoodGrain15A
                color_map { M_Wood15A }
                scale .25
                rotate 90*y
                warp { repeat .15*z offset .03*y }
            }
            normal {
                bumps .1
                scale <.01, 1, .001>
            }
        } 
        texture {
            pigment {
                P_WoodGrain15B
                color_map { M_Wood15B }
                scale .25
                rotate 90*y
                warp { repeat .15*z offset .03*y }
            }
            normal {
                bumps .1
                scale <.01, 1, .001>
            }
        }
        rotate -95*y
        translate <-3.5, .3, -1.5>
    }

#declare Drawer =
    intersection {
        box { <-1.04, .55, -.5>, <1.04, .7, 0> }
        box { <-1, .56, -.49>, <1., .69, .01> inverse }
        texture {
            pigment { Silver }
            normal { bumps .05    scale .01 }
            finish { phong .4    phong_size 60 }
        }
    }

#declare Desk =
    union {
        box { <-1.05, .7, -.5>, <1.05, .75, .025> } // Surface base
        box { // Surface
            <-1.05, .75, -.5>, <1.05, .751, .025>
            texture {
                pigment { Aquamarine }
                finish { phong .2    phong_size 150 }
                normal { bumps .01 scale .001 }
            }
        }
        object { Drawer }
        box { <-1.05, 0, -.5>, <-1, .05, .5> } // Horizontal Support
        box { <1.05, 0, -.5>, <1, .05, .5> } // Horizontal Support
        box { <-1.05, 0, -.025>, <-1, .7, .025> } // Leg
        box { <1.05, 0, -.025>, <1, .7, .025> } // Leg
        union {
            box { <-1, .38, 0>, <1, .4, .5> } // Seat
            box { <-1, .35, .48>, <1, .76, .5> } // Back
            texture {
                pigment { MediumSeaGreen }
                finish { phong .2    phong_size 150 }
                normal { bumps .01 scale .001 }
            }
        }
        rotate 90*y
        texture {
            pigment { DarkTurquoise }
            normal { bumps .05 scale .01 }
            finish { phong .5    phong_size 50 }
        }
    }

#declare TwoDesks =
    union {
        object { Desk translate <0, 0, -1.5> }
        object { Desk translate <0, 0, 1.5> }
    }

#declare AllDesks =
    union {
        object { TwoDesks translate -1.5*x }
        object { TwoDesks translate -.5*x }
        object { TwoDesks translate .5*x }
        object { TwoDesks translate 1.5*x }
        object { TwoDesks translate 2.5*x }
        object { TwoDesks translate 3.5*x }
    }

#declare T_Wall =
    texture {
        pigment { White }
        normal {
            average
            normal_map {
                [ .5 granite .1 scale .01 ]
                [ .5 bumps .2 scale .01 ]
            }
        }
    }

#declare Walls =
    intersection {
        box { <-5.1, -.06, -3.1>, <5.1, 3.1, 3.1 > }
        box { <-5, -.05, -3>, <5, 3, 3> inverse }
        texture { T_Wall }
    }

#declare DoorHole =
    box {
        <-3, -.05, 2.99>, <-4, 2, 3.11>
        texture { pigment { Brown } }
    }

#declare Door =
    box {
        <0, 0, -.025>, <1, 2, .025>
        texture {
            pigment { MediumTurquoise }
            normal { bumps .01    scale .03 }
            finish { phong .3    phong_size 120 }
        }
        rotate 80*y
        translate <-4, 0, 3>
    }

#declare WindowsHole =
    union {
        box { <-1.25, .9, -2.99>, <1.25, 2.1, -3.11> translate -3.25*x }
        box { <-1.25, .9, -2.99>, <1.25, 2.1, -3.11> }
        box { <-1.25, .9, -2.99>, <1.25, 2.1, -3.11> translate 3.25*x }
        texture { pigment { Gray50 } }
    }

#declare Walls_Door_Windows =
    intersection {
        object { Walls }
        object { DoorHole inverse }
        object { WindowsHole inverse }
    }

#declare T_Floor =
    texture {
        pigment { checker White, Gray20 }
        finish {
            phong .5
            phong_size 20
            reflection .025
        }
        normal {
            bump_map {
                gif "tilebump.gif"
                bump_size 1
            }
            rotate 90*x
        }
        scale .3
    }

#declare Floor =
    box {
        <-5, -.5, -3>, <5, 0, 5>
        texture { T_Floor }
    }

#if (RoomLights = 2) // Fast but smooth
    light_source {
        <0, 2.9, 0> rgb <.8, .8, 1>*2
        area_light <9, 0, 0>, <0, 0, 5>, 9, 5
        adaptive 1
    }
#end

#declare Lamp =
    union {
      #if (RoomLights = 1)
        light_source {
            <0, -.01, 0> color rgb <.8, .8, 1>*.05
            area_light <.25, 0, 0>, <0, 0, .5>, 3, 5
            adaptive 0
        }
      #end
        box {
            -1, 1
            texture {
                pigment { rgb <.95, .95, 1> }
                finish { ambient .98 diffuse .02 }
            }
            hollow
            no_shadow
            scale <.25, .05, .5>
        }
        box {
            -1.05, 1.05
            texture {
                pigment { Clear }
                halo {
                    emitting
                    linear box_mapping
                    turbulence .05
                    samples 10
                    color_map {
                        [ 0 rgbt <.75, .9, 1, 1> ]
                        [ .5 rgbt <1, 1, 1, -.5> ]
                    }
                }
            }
            hollow
            no_shadow
            scale <.3, .1, .5>*1.4
        }
    }

#declare LampRow =
    union {
        object { Lamp translate <0, 0, -2> }
        object { Lamp }
        object { Lamp translate <0, 0, 2> }
    }

#declare CeilingLamps=
    union {
        object { LampRow translate <-4, 0, 0> }
        object { LampRow translate <-3, 0, 0> }
        object { LampRow translate <-2, 0, 0> }
        object { LampRow translate <-1, 0, 0> }
        object { LampRow }
        object { LampRow translate <1, 0, 0> }
        object { LampRow translate <2, 0, 0> }
        object { LampRow translate <3, 0, 0> }
        object { LampRow translate <4, 0, 0> }
        translate <0, 3, 0>
    }

#declare T_Plataform =
    texture {
        pigment {
            bozo
            pigment_map {
                [ 0 Gray50 ]
                [ 1 Gray55 ]
            }
        }
        normal { bumps .01 }
        scale .1
    }

#declare TeacherPlataform =
    box {
        <-5, 0, -3>, <-3, .3, 1>
        texture { T_Plataform }
    }

#declare BlackBoard =
    union{
        box {
            <-5, .8, -2>, <-4.98, 2, 2>
            texture {
                pigment {
                    bozo
                    color_map {
                        [ 0 Black ]
                        [ 1 Gray15 ]
                    }
                    scale <.1, .25, .1>
                }
                normal { bumps .05    scale .003 }
                finish { phong .5    phong_size 200 }
            }
        }
        // Frame
        box { <-5, 2, -2>, <-4.95, 2.1, 2> } // Top
        box { <-5, .7, -2>, <-4.95, .8, 2> } // Back
        box { <-5, .7, -2>, <-4.95, 2.1, -2.1> } // Left
        box { <-5, .7, 2>, <-4.95, 2.1, 2.1> } // Right
        texture {
            pigment { Gray50 }
            normal { dents .03    scale .01 }
            finish { specular 1    roughness .01 }
        }
    }

#declare Corridor =
    union {
        box { <-5.1, -.5, 3>, <-5, 3, 5> }
        box { <-5, -.5, 5>, <5, 3, 5.1> }
        box { <5.1, -.5, 3>, <5, 3, 5> }
        box { <-5, 3, 3>, <5, 3.1, 5> } // Ceiling
        texture { T_Wall }
    }

#declare EmptyRoom =
    union {
        object { Door }
        object { Walls_Door_Windows }
        object { Floor }
        object { CeilingLamps }
        object { TeacherPlataform }
        object { BlackBoard }
        object { Corridor }
    }

#declare Room =
    union {
        object { TeacherDesk }
        object { Chair }
        object { AllDesks }
        object { EmptyRoom }
    }


// (C) Guillermo Sanz Romero
// Todos los derechos reservados.
// Si deseas utilizar la totalidad o parte de este fichero puedes hacerlo
//  mientras no sea con fines lucrativos.
// En caso de usarlo para publicidad, recopilaciones de software, inclusin
//  en revistas o alguna otra actividad que suponga una transaccin
//  remunerada (con cualquier tipo de bien, por lo que los trueques y los
//  premios de los concursos tambin quedan incluidos), debes ponerte en
//  contacto utilizando las direcciones de la cabezera para poder acordar las
//  condiciones que te permitan hacer dicho uso de los datos contenidos en
//  este fichero o los generados a partir de l, tanto descripciones de
//  imagenes como las imagenes en si, en cualquier formato y/o medio de
//  almacenamiento.
//--
// All rights reserved.
// If you want to use this file in is enterity or only parts of it you can do
//  it while it is a non-profitable purpose.
// In case of using it for advertisment, software recopilations, bunddling it
//  with magazines or another profitable transaction (any sort of profit, so
//  exchange and prizes won in contests are included), you must get in touch
//  with me through the addresses given above to reach an agreement about the
//  conditions to use the data here contained (this file) or build from it,
//  both new image descriptions and images, whatever the format and/or the
//  storage way.

// No dudes en escribirme si tienes alguna pregunta, tanto sobre la clusula
//  arriba expuesta como sobre el fichero de datos que describe las imgenes
//  y las imgenes en si.
// P.D.: los precios son razonables y el dinero esta destinado bsicamente
//  a mejorar mi ordenador y poder seguir creando ms imagenes.
//--
// Do not doubt to write me if you has any question, about the clausule 
//  written above or the descriptions and the images.
// P.S.: prices are reasonable and money is basically to improve my computer
//  so I can keep making more pictures.

// NOTA IMPORTANTE
//  Este es un extracto de la licencia completa (LICENSE.GSR), lee dicho
//  fichero para conocer todas las condiciones y clusulas.
//--
// IMPORTANT NOTE
//  This is an extract of the complete license (LICENSE.GSR), read that file
//  to know all the conditions and clausules.
