#include "keg.inc"
#include "glass.inc"
#include "desk.inc"
#include "computer.inc"
#include "mouse.inc"
#include "picture.inc"
#include "books.inc"
#include "chair.inc"

camera {
  location <-9,8,-30>
  direction <0,0,2.5>
  up <0,1,0>
  right <1.33,0,0>
  look_at <2,0,0>
}

light_source { <-3.75,2,-44.99> color rgb<0.45,0.45,0.45> 
  area_light <4,0,0>, <0,6,0>, 12, 18
  adaptive 1 jitter
}

light_source { <0,11.99,-20> color rgb<0.6,0.56,0.5> 
  area_light <3,0,0>, <0,0,3>, 6, 6
  adaptive 1 jitter
}

box { <-35,-100,-45>, <35,12,5>
  pigment { rgb<1,1,1> }
  finish { reflection 0.05 } 
  hollow
}

plane { <0,1,0>, -8
  pigment {
    crackle color_map {
      [0 color rgb<0.6,0.6,0.6>]
      [1 color rgb<0.3,0.3,0.3>]
    }
    turbulence 1
    scale 0.025
  }
  normal {
    crackle 0.2
    turbulence 1
    scale 0.025
  }
}

object { Desk }

object { TappedKeg translate <0.56,0,0.38> scale 11 }

object { ComputerMonitor rotate -25*y translate 5*y scale 0.7 translate -3.5*x }

object { Keyboard rotate -108*y translate <-9,4.1,3> scale 0.6 }

object { Mouse rotate -36*y scale 0.16 translate <0.9,0,1.9> }
object { MousePad rotate -12*y scale 0.15 translate <1.2,0,1.1> }

object { Pint scale 2.6 rotate 28*y translate <1.2,0,-4.3> }

object { Picture rotate 6*z scale 2.8 translate <1.2,3.6,4.8> }

object { PhysicsBook translate 0.38*y rotate -8*y scale 0.8 translate <6.3,-2.7,-5> }
object { CompBook translate 0.5*y scale 0.8 translate <6.5,-2.092,-5> }

object { PsychBook translate 0.28*y rotate 6*y scale 0.8 translate <6.8,-4.7,-4.8> }

object { Chair translate 1.618*y rotate 16*y scale 3 translate <-4.25,-8,-9.5> }
