#include "kegbody.inc"
#include "kegtop.inc"
#include "tap.inc"

#declare Keg =
union {
  object { KegBody }
  object { KegTop }
  pigment { 
    bozo color_map {
      [0 0.8 color rgb<0.62,0.62,0.62> color rgb<0.76,0.76,0.76>]
      [1 color rgb<0.76,0.76,0.76>]
    } 
    turbulence 1.5
    scale <50,200,50>
    rotate 20*y
  }
  normal {
    crackle 0.125
    turbulence 0.6
    scale 180
  }
  finish { metallic reflection 0.08 specular 0.5 phong 0.3 }
  translate 98.05*z
  scale 1/250 
  rotate 30*z
}

#declare TappedKeg =
union {
  object { Keg }
  object { Tap }
  union {
    box { <-0.3,-0.3,0.16>, <0.3,-0.1,0.14> }
    box { <-0.3,-0.3,0.67>, <0.3,-0.1,0.65> }
    pigment { rgb<0.2,0.2,0.2> }
    finish { reflection 0.1 phong 0.3 }
  }
  scale <1,1,-1>
  translate 0.3*y
}
