#declare TailFinSpikes =
union {
  cone { <3,0.367000,0>, 0.05, <4.800000,0.380000,0>, 0.01 scale <1,1,1.5> }
  cone { <3,0.287000,0>, 0.05, <4.680000,0.230000,0>, 0.01 scale <1,1,1.5> }
  cone { <3,0.207000,0>, 0.05, <4.560000,0.080000,0>, 0.01 scale <1,1,1.5> }
  cone { <3,0.127000,0>, 0.05, <4.440000,-0.070000,0>, 0.01 scale <1,1,1.5> }
  cone { <3,0.047000,0>, 0.05, <4.484000,-0.220000,0>, 0.01 scale <1,1,1.5> }
  cone { <3,-0.033000,0>, 0.05, <4.528000,-0.370000,0>, 0.01 scale <1,1,1.5> }
  cone { <3,-0.113000,0>, 0.05, <4.572000,-0.520000,0>, 0.01 scale <1,1,1.5> }
  cone { <3,-0.193000,0>, 0.05, <4.616000,-0.670000,0>, 0.01 scale <1,1,1.5> }
  cone { <3,-0.273000,0>, 0.05, <4.660000,-0.820000,0>, 0.01 scale <1,1,1.5> }
}

#declare TailFinMembrane =
difference {
  prism { linear_sweep linear_spline 0.005, -0.005, 6
    <3,0.367>, <4.8,0.38>,
    <4.44,-0.07>, <4.66,-0.82>,
    <3,-0.273>, <3,0.367000>
    rotate -90*x
  }
  cylinder { <0,0.305000,-1>, <0,0.305000,1>, 0.07
    scale <1.75,1,1> translate 4.740000*x
  }
  cylinder { <0,0.155000,-1>, <0,0.155000,1>, 0.07
    scale <1.75,1,1> translate 4.620000*x
  }
  cylinder { <0,0.005000,-1>, <0,0.005000,1>, 0.07
    scale <1.75,1,1> translate 4.500000*x
  }
  cylinder { <0,-0.145000,-1>, <0,-0.145000,1>, 0.07
    scale <1.75,1,1> translate 4.462000*x
  }
  cylinder { <0,-0.295000,-1>, <0,-0.295000,1>, 0.07
    scale <1.75,1,1> translate 4.506000*x
  }
  cylinder { <0,-0.445000,-1>, <0,-0.445000,1>, 0.07
    scale <1.75,1,1> translate 4.550000*x
  }
  cylinder { <0,-0.595000,-1>, <0,-0.595000,1>, 0.07
    scale <1.75,1,1> translate 4.594000*x
  }
  cylinder { <0,-0.745000,-1>, <0,-0.745000,1>, 0.07
    scale <1.75,1,1> translate 4.638000*x
  }
}

#declare TailFin =
union {
  object { TailFinSpikes pigment { gradient y color_map { [0 color rgb<0.65,0.59,0.46>] [1 color rgb<0.3,0.18,0.12>] } scale 1.25 translate -0.7*y } }
  object { TailFinMembrane pigment { rgbf<1,1,0.8,0.4> } }
}

#declare _RearFin =
union {
  union {
    #declare Count = 0
    #while (Count < 8)
      cone { <Count*0.16, -0.32 + 0.04*Count, 0>, 0.05 - 0.00375*Count, <Count*0.16, 0.32 - 0.04*Count, 0>, 0.01 - 0.000375*Count }
      #declare Count = Count + 1
    #end
    pigment { rgb<0.3,0.26,0.2> }
  }
  prism { linear_sweep linear_spline 0.005, -0.005, 4
    <0,-0.32>, <0,0.32>, <1.28,0>, <0,-0.32>
    rotate -90*x
    pigment { rgbf<1,1,0.8,0.4> }
  }
  scale <1,1,1.2>
}

#declare RearDorsalFin =
object { _RearFin translate 0.32*y scale 1 rotate -28*z translate 0.9*x }

#declare RearBellyFin =
object { _RearFin scale <0.8,-1,1> translate -0.32*y rotate 42*z translate 1.1*x }

#declare RearFins =
union {
  object { RearDorsalFin translate 0.92*y }
  object { RearBellyFin translate -0.6*y }
}

#declare _LowerFin =
merge {
  union {
    cone { <0,0,0>, 0.06, <0.64,-0.08,0.1>, 0.015 }
    cone { <0,0,0>, 0.06, <0.58,-0.56,0.24>, 0.02 }
    pigment { rgbf<1,1,0.8,0.1> }
  }
  merge {
    #declare Count = 1
    #while (Count < 14)
      cylinder { <0,0,0>, <0.61 - 0.06*Count/14, -0.08 - 0.48*Count/14, 0.1 + 0.14*Count/14>, 0.026 }
      sphere { <0.61 - 0.06*Count/14, -0.08 - 0.48*Count/14, 0.1 + 0.14*Count/14>, 0.026 }
      #declare Count = Count + 1
    #end
    pigment { rgbt<1,1,0.8,0.25> }
  }
  translate <-1.3,-1.06,0.02>
}

#declare LowerFins =
union {
  object { _LowerFin }
  object { _LowerFin scale <1,1,-1> }
}

#declare FrontDorsalFinSpikes =
union {
  cone { <0.000000,0,0>, 0.03, <0.000000,0.080000,0>, 0.005 scale <1,1,1.2> }
  cone { <0.088800,0,0>, 0.03, <0.190154,0.336808,0>, 0.005 scale <1,1,1.2> }
  cone { <0.177600,0,0>, 0.03, <0.276978,0.457115,0>, 0.005 scale <1,1,1.2> }
  cone { <0.266400,0,0>, 0.03, <0.410000,0.546410,0>, 0.005 scale <1,1,1.2> }
  cone { <0.355200,0,0>, 0.03, <0.573176,0.593923,0>, 0.005 scale <1,1,1.2> }
  cone { <0.444000,0,0>, 0.03, <0.746824,0.593923,0>, 0.005 scale <1,1,1.2> }
  cone { <0.532800,0,0>, 0.03, <0.910000,0.546410,0>, 0.005 scale <1,1,1.2> }
  cone { <0.621600,0,0>, 0.03, <1.043022,0.457115,0>, 0.005 scale <1,1,1.2> }
  cone { <0.710400,0,0>, 0.03, <1.129846,0.336808,0>, 0.005 scale <1,1,1.2> }
  cone { <0.799200,0,0>, 0.03, <1.160000,0.200000,0>, 0.005 scale <1,1,1.2> }
}

#declare FrontDorsalFinMembrane =
union {
  prism { linear_sweep linear_spline 0.001, -0.001, 4
    <0.000000,0>, <0.190154,0.3>, <0.088800,0>, <0.000000,0>
    rotate -90*x
  }
  difference {
    prism { linear_sweep linear_spline 0.001, -0.001, 5
      <0.088800,0>, <0.190154,0.336808>, <0.276978,0.457115>, <0.177600,0>, <0.088800,0>
      rotate -90*x
    }
    cylinder { <0,0,1>, <0,0,-1>, 0.074183 scale <1.2,1,1> rotate 75.810986*z translate <0.233566,0.396962,0> }
  }
  difference {
    prism { linear_sweep linear_spline 0.001, -0.001, 5
      <0.177600,0>, <0.276978,0.457115>, <0.410000,0.546410>, <0.266400,0>, <0.177600,0>
      rotate -90*x
    }
    cylinder { <0,0,1>, <0,0,-1>, 0.080107 scale <1.2,1,1> rotate 76.389241*z translate <0.343489,0.501763,0> }
  }
  difference {
    prism { linear_sweep linear_spline 0.001, -0.001, 5
      <0.266400,0>, <0.410000,0.546410>, <0.573176,0.593923>, <0.355200,0>, <0.266400,0>
      rotate -90*x
    }
    cylinder { <0,0,1>, <0,0,-1>, 0.084976 scale <1.2,1,1> rotate 72.407264*z translate <0.491588,0.570167,0> }
  }
  difference {
    prism { linear_sweep linear_spline 0.001, -0.001, 5
      <0.355200,0>, <0.573176,0.593923>, <0.746824,0.593923>, <0.444000,0>, <0.355200,0>
      rotate -90*x
    }
    cylinder { <0,0,1>, <0,0,-1>, 0.086824 scale <1.2,1,1> rotate 66.325404*z translate <0.660000,0.593923,0> }
  }
  difference {
    prism { linear_sweep linear_spline 0.001, -0.001, 5
      <0.444000,0>, <0.746824,0.593923>, <0.910000,0.546410>, <0.532800,0>, <0.444000,0>
      rotate -90*x
    }
    cylinder { <0,0,1>, <0,0,-1>, 0.084976 scale <1.2,1,1> rotate 59.190769*z translate <0.828412,0.570167,0> }
  }
  difference {
    prism { linear_sweep linear_spline 0.001, -0.001, 5
      <0.532800,0>, <0.910000,0.546410>, <1.043022,0.457115>, <0.621600,0>, <0.532800,0>
      rotate -90*x
    }
    cylinder { <0,0,1>, <0,0,-1>, 0.080107 scale <1.2,1,1> rotate 51.486636*z translate <0.976511,0.501763,0> }
  }
  difference {
    prism { linear_sweep linear_spline 0.001, -0.001, 5
      <0.621600,0>, <1.043022,0.457115>, <1.129846,0.336808>, <0.710400,0>, <0.621600,0>
      rotate -90*x
    }
    cylinder { <0,0,1>, <0,0,-1>, 0.074183 scale <1.2,1,1> rotate 43.355120*z translate <1.086434,0.396962,0> }
  }
  difference {
    prism { linear_sweep linear_spline 0.001, -0.001, 5
      <0.710400,0>, <1.129846,0.336808>, <1.160000,0.200000>, <0.799200,0>, <0.710400,0>
      rotate -90*x
    }
    cylinder { <0,0,1>, <0,0,-1>, 0.070046 scale <1.2,1,1> rotate 34.527902*z translate <1.144923,0.268404,0> }
  }
  prism { linear_sweep linear_spline 0.001, -0.001, 4
    <0.799200,0>, <1.0800,0.1640000>, <1.1,0>, <0.799200,0>
    rotate -90*x
  }
}

#declare FrontDorsalFin =
union {
  object { FrontDorsalFinSpikes pigment { rgb<0.3,0.26,0.2> } }
  object { FrontDorsalFinMembrane pigment { rgbf<1,1,0.8,0.4> } }
  scale <1.2,1.2,1>
  translate <-1.6,0.9,0>
}

#declare _SideFin =
union {
  cone { <0,0,0>, 0.06, <0.8,0.2,1>, 0.02 pigment { rgb<0.65,0.63,0.5> } }
  merge {
    #declare Count = 1.5
    #while (Count < 25) 
      cylinder { <0,0,0>, <0.77 - 0.35*Count/25, 0.2 - 0.35*Count/25, 1 - 0.9*Count/25>, 0.03 }
      sphere { <0.77 - 0.35*Count/25, 0.2 - 0.35*Count/25, 1 - 0.9*Count/25>, 0.03 }
      #declare Count = Count + 1
    #end
    pigment { rgbf<0.825,0.815,0.75,0.5> }
  }
  translate <-2,-0.18,0.42>
}

#declare SideFins =
union {
  object { _SideFin }
  object { _SideFin scale <1,1,-1> }
}
