#declare Hook =
union {
  torus { 0.15, 0.1 rotate 90*x translate 0.4*y }
  cylinder { <0,0.2,0>, <0,-1.2,0>, 0.1 }
  intersection {
    torus { 0.5, 0.1 scale <1,1,1.3> rotate 90*x translate <-0.5,-1.2,0> }
    box { <-1.2,-1.2,-0.2>, <0.2,-2,0.2> }
  }
  cone { <-1,-1.2,0>, 0.1, <-1,-0.6,0>, 0.01 }
  intersection {
    cone { <0,-1.2,0>, 0.1, <0,-0.6,0>, 0 scale <3,1,1> }
    box { <0,-1.2,-0.2>, <0.5,-0.6,0.2> }
    translate -x
  }
  pigment { rgb<0.7,0.76,0.8> }
  finish { metallic brilliance 40 phong 1 }
}

#declare Line =
union {
  torus { 0.15, 0.05 rotate <90,90,0> translate 0.55*y }
  cylinder { <0,0.7,0>, <0,300,0>, 0.05 }
  pigment { rgbt<1,1,1,0.5> }
  finish { phong 0.8 }
}

#declare Worm =
union {
  #declare Count = 0
  #while (Count < 50)
    sphere { <0, cos(Count*1.7*3.14159/50 - 1.57079) - 1, 3.4*Count/50 - 1>, 0.26 } 
    #declare Count = Count + 1
  #end
  scale <1,1,-1>
  rotate <-42,20,6>
  translate <-0.5,-1.85,0>
  pigment { rgb<0.5,0.36,0.4> }
}

#declare Fisherman =
union {
  object { Hook }
  object { Line }
  object { Worm }
  scale 0.12
  rotate 28*y
  translate <1.3,0.9,-8>
}
