#include "fish.inc"
#include "apple.inc"
#include "fisher.inc"

camera { 
  location <1,1,-12>
  direction <0,0,2>
  up <0,1,0>
  right <1.33,0,0>
  look_at <-1,1.2,1>
}

fog { distance 150 color rgb<0,0.288,0.432> }

plane { <0,1,0>, 0 translate 20*y pigment { rgbt<1,1,1,1> } normal { ripples 0.5 scale 7500 frequency 3000 } finish { refraction 1 ior 1.3333 caustics 1 } hollow }

light_source { <2,8,-20> color rgb<0.5,0.5,0.5> }

light_source { <-5,30,-5> color rgb<0.6,0.6,0.6> }

height_field { tga "height.tga" translate <-0.5,0,-0.1> scale <250,20,250> translate -20*y pigment { rgb<0.8,0.7,0.5> } }

object { Fish2 translate 2*x scale <-1.2,1.5,1.5> rotate 20*y translate <-8,3.3,24> }

object { Fish rotate 50*y translate <1.5,3,-1> }
object { Fish scale <1.28,1,1> rotate 60*y translate <-1.3,-0.6,4> }
object { Fish scale <1,0.78,1.2> rotate 32*y translate <2,0.3,16> }
object { Fish scale <1.28,1,1> rotate 90*y translate <-5.25,-1,0> }
object { Fish scale <1.1,1,1.1> translate <5,3,26> }
object { Fish scale <1.5,1.1,1> rotate -24*y translate <0,2.6,32> }

#declare R = seed(69)

#declare Count = 0
#while (Count < 18)
  object { Fish scale <1.2,1,1> rotate (-75 + 45*rand(R))*y translate <-20 + 40*rand(R), -2 + 20*rand(R), 50 + 24*rand(R)> }
  #declare Count = Count + 1
#end


box { <-8,-5,-0.1>, <8,5,0.1>
  pigment { 
    image_map {
      gif "board.gif"
      interpolate 2
    }
    translate <-0.5,-0.5,0>
    scale <16,10,1>
  }
  rotate -30*y translate <-18,7,35>
}

difference {
  union {
    box { <-8.5,-5.8,-0.3>, <8.5,5.5,0.2> }
    box { <-8,-5.3,-0.6>, <8,-5,0.1> }
  }
  box { <-8,-5,-1>, <8,5,0.1> }
  pigment {
    wood color_map {
      [0 color rgb<0.8,0.6,0.3>]
      [1 color rgb<0.6,0.3,0.1>]
    }
    turbulence 0.06
    scale <0.2,0.05,0.2>
    rotate <60,0,15>
    translate <3,4,5>
  }
  finish { phong 0.5 }
  rotate -30*y translate <-18,7,35>
}

object { Apple scale <0.36,0.42,0.36> rotate <-30,10,20> translate <-13,1,19> }

object { Fisherman }
