#declare ScalePigment =
    pigment {
      crackle color_map {
        [0 color rgb<0.2,0.16,0.08>]
        [0.4 color rgb<1,1,0.8>]
      }
      turbulence 0.5
      scale 0.3
      scale <0.4,1,1>
    }

#declare ScaleNormal =
    normal {
      crackle 0.1
      turbulence 0.5
      scale 0.5
      scale <0.4,1,1>
    }

#declare Grad1 =
    pigment {
      gradient y color_map {
        [0 color rgbt<1,1,0.84,0>]
        [0.25 color rgbt<1,1,0.84,0.1>]
        [0.4 color rgbt<1,1,0.84,1>]
        [0.5 color rgbt<0.2,0.16,0.08,1>]
        [0.96 color rgbt<0.2,0.16,0.08,0>]
      }
      scale 2.28
      translate -1.14*y
      rotate 2*z
    }

#declare Grad2 =
    pigment {
      gradient y color_map {
        [0 color rgb<1,1,0.84>]
        [0.5 color rgb<1,1,0.84>]
        [0.7 color rgb<0.2,0.16,0.08>]
      }
      scale 2.21
      translate -1.105*y
      rotate 20*z
      translate -3*x
    }

#declare ScaleTexture =
  texture {
    pigment { ScalePigment }
  }
  texture {
    pigment {
      gradient x pigment_map {
        [0 Grad2 translate 3.75*x rotate -30*z scale 1/8]
        [0.15 Grad2 translate 3.75*x rotate -30*z scale 1/8]
        [0.25 Grad1 translate 3.75*x rotate -30*z scale 1/8]
      }
      scale 8
      rotate 30*z
      translate -3.75*x
    }
    normal { ScaleNormal }
    finish { phong 0.72 }
  }
