#include "metals.inc"
//P_Chrome2 - color for metalwork
//F_MetalE is pre-defined v shiny metallic finish

#declare My_Metal_Tex =
texture {
   pigment { P_Chrome2 }
   finish { F_MetalE }
}


#declare Glass_Tex =
texture {
   pigment {
      color rgbf <0.7, 0.9, 0.4, 0.9>
   }
   finish {
      ambient 0.1
      diffuse 0.1
      reflection 0.001 //May be 0 allow clear view through dome
      refraction 1 // May be 0 same reason as that for  low reflection
      ior 1.5	//1.5 is correct ior for glass
      phong 0.1
      phong_size 175
   }
}


#declare Outer_Sphere =
sphere {
   <0, 30, 0>, 160.25
   hollow
   texture {
      Glass_Tex
   }
}


#declare Inner_Sphere =
sphere {
   <0, 30, 0>, 159.75
hollow
   texture {
      Glass_Tex
   }
}


#declare Double_Sphere =
difference {
   object { Outer_Sphere }
   object { Inner_Sphere }
}


#declare Hemisphere =
difference {
   object { Double_Sphere }
   plane {
         <0, 1, 0>, 30
   hollow
      texture {
         pigment {
            color rgbt <1, 1, 1, 1>
         }
      }
   } //End of plane
} //End of difference statement


#declare Bottom_Ring =
difference {
   cylinder {
      <0, 29, 0> <0, 31, 0>, 162.5
   hollow
      texture {
         My_Metal_Tex
      }
   }

   cylinder {
      <0, 28.5, 0> <0, 31.5, 0>, 157.5
   hollow
      texture {
         My_Metal_Tex
      }
   }
}


#declare Strut_1 = //A foot
box {
   <-2.5, 0, 157.5> <2.5, 30, 162.5>
      texture {
         My_Metal_Tex
      }
}


#declare Strut_2 = //Another foot
box {
   <-2.5, 0, -157.5> <2.5, 30, -162.5>
      texture {
         My_Metal_Tex
      }
}


#declare Support_Ring_Circle =
difference {
   cylinder {
      <-2.5, 30, 0> <2.5, 30, 0>, 162.5
   hollow
      texture {
         My_Metal_Tex
      }
   }

cylinder {
      <-2.6, 30, 0> <2.6, 30, 0>, 157.5
hollow
      texture {
         My_Metal_Tex
      }
   }
}


#declare Support_Ring =
difference {
   object { Support_Ring_Circle }
   plane {
      <0, 1, 0>, 30
      texture {
         pigment {
            color rgbt <1, 1, 1, 1>
         }
      }
   } //End of plane
}  //End of difference statement


#declare A_Support =
union {
   object { Support_Ring scale <1, 0.5, 1> }
   object { Strut_1 }
   object { Strut_2 }
}


#declare The_Supports =
#declare Rotate_by = 0
union {
#while (Rotate_by < 3)
   object { A_Support rotate <0, (Rotate_by*60)+15, 0> }
   #declare Rotate_by = Rotate_by + 1
#end
} //End of union statement


#declare The_Dome =
union {
   object { Hemisphere scale <1, 0.5, 1> }
   object { The_Supports }
   object { Bottom_Ring }
}


    







      
      





