// Book number one -- Roxburghe Ballads, volume 1 (1873).  Constructed of
//  olive and maroon leather, with gold foil letters and black decorations
//  stamped into the spine.  There is some wear of the leather, most
//  notably on the ribs of the binding, and along the edges and corners
//  of the cover boards.  The olive leather is rather smooth, and the
//  maroon leather is kind of knobbly (except for the nameplate, which is
//  also smooth).

#ifdef (ShowProgress)
  #debug ">>> parsing book1.inc\n"
#end

//================================================ Includes and font definitions

#ifndef (T_Gold_3A)
  #include "golds.inc"
#end

#ifdef (Final)
  #declare FindFontParameter="courbd.ttf"
  #include "findfont.inc"
  #declare TitleFont=FindFontResult

  #declare FindFontParameter="timesbd.ttf"
  #include "findfont.inc"
  #declare VolumeFont=FindFontResult
#end

//========================================== pigment, texture and normal defines

#declare Olive1=     colour rgb < 94/255,  75/255,  8/255>*0.8
#declare Olive2=     colour rgb <107/255,  85/255,  8/255>*0.8
#declare Maroon1=    colour rgb < 92/255,   0/255,  9/255>
#declare Maroon2=    colour rgb < 92/255,   0/255,  9/255>*1.3
#declare DirtyMaroon=colour rgb < 108/255, 44/255, 33/255>
#declare Scuff1=     colour rgb <217/255, 165/255, 98/255>
#declare Clear=      colour rgbt <1,1,1,1>
#declare GoldTemp=   texture { T_Gold_3A }

#declare LeatherNormal = normal {
    bumps scale 0.005
}

#declare T_ScuffedLeather = texture {
  pigment{ Scuff1 }
  #ifdef (Final)
    normal { LeatherNormal }
  #end
}

#declare T_OliveLeather1 = texture {
  pigment {
    bozo
    colour_map {
      [ 0.00 pigment Olive1 ]
      [ 1.00 pigment Olive2 ]
    }
    scale 0.5
  }
#ifndef (Quick)
  #ifdef (Final)
    finish { phong 0.8 phong_size 20 }
    normal
    {
      crackle 0.01
      slope_map {
        [0 <0,.9>]
        [.025 <1,0>]
        [.975 <1,0>]
        [1  <0,-.9>]
      }
      turbulence 0.1
      scale <0.1,0.1,0.01>
    }
  #else
    finish { phong 0.9 phong_size 20}
  #end
#end
}

#declare T_OliveLeather2 = texture {
  pigment { Olive2 }
#ifndef (Quick)
  #ifdef (Final)
    finish { phong 0.8 phong_size 20 }
    normal
    {
      crackle 0.01
      slope_map {
        [0 <0,.9>]
        [.025 <1,0>]
        [.975 <1,0>]
        [1  <0,-.9>]
      }
      turbulence 0.1
      scale <0.1,0.1,0.01>
    }
  #else
    finish { phong 0.9 phong_size 20}
  #end
#end
}

#declare T_OliveLeather3 = texture {
  pigment { Olive1 }
#ifndef (Quick)
  #ifdef (Final)
    finish { phong 0.8 phong_size 20 }
    normal
    {
      crackle 0.01
      slope_map {
        [0 <0,.9>]
        [.025 <1,0>]
        [.975 <1,0>]
        [1  <0,-.9>]
      }
      turbulence 0.1
      scale <0.1,0.1,0.01>
    }
  #else
    finish { phong 0.9 phong_size 20}
  #end
#end
}

#declare T_MaroonLeather1 = texture {
  pigment {
  #ifdef (Quick)
    Maroon2
  #else
    gradient x
    colour_map {
      [ 0.00 pigment Maroon1 ]
      [ 0.60 pigment Maroon1 ]
      [ 0.70 pigment Maroon2 ]
      [ 1.00 pigment Maroon2 ]
    }
    rotate z*-45
    turbulence 1
    scale 0.1
  #end
  }
#ifndef (Quick)
  #ifdef (Final)
    finish { phong 0.9 phong_size 20 }
    normal
    {
      bumps 0.05
      turbulence 0.1
      scale 0.05
    }
  #else
    finish { phong 1.0 phong_size 40}
  #end
#end
}

#declare T_MaroonLeather2 = texture {
  pigment {
    bozo
    colour_map {
      [ 0.00 pigment Maroon1 ]
      [ 0.60 pigment Maroon1 ]
      [ 1.00 pigment DirtyMaroon ]
    }
    turbulence 0.5
  }
#ifndef (Quick)
  #ifdef (Final)
    normal
    {
      quilted 
      turbulence <1,1,0>
      scale 0.1
    }
  #end
  finish { phong 0.5 phong_size 100}
#end
}

#declare T_BlackLeather1 = texture {
  pigment { colour rgb <0,0,0> }
#ifndef (Quick)
//  finish { phong 0.2 phong_size 230 }
#end
}


#declare T_Scuff1 = texture {
  #ifdef (Quick)
    T_OliveLeather1
  #else
    bozo
    texture_map {
      [ 0.00 T_ScuffedLeather ]
      [ 0.40 T_ScuffedLeather ]
      [ 0.40 T_OliveLeather1 ]
      [ 1.00 T_OliveLeather1 ]
    }
    turbulence 0.5
    scale 0.1
  #end
}

#declare T_Scuff2 = texture {
  #ifdef (Quick)
    T_OliveLeather1
  #else
    bozo
    texture_map {
      [ 0.00 T_OliveLeather1 ]
      [ 0.20 T_OliveLeather1 ]
      [ 0.20 T_ScuffedLeather ]
      [ 1.00 T_ScuffedLeather ]
    }
    turbulence 0.5
    scale 0.1
  #end
}

#declare T_Scuff3 = texture {
  #ifdef (Quick)
    T_OliveLeather1
  #else
    bozo
    texture_map {
      [ 0.0000 T_ScuffedLeather ]
      [ 0.0001 T_ScuffedLeather ]
      [ 0.0001 T_OliveLeather1 ]
      [ 1.0000 T_OliveLeather1 ]
    }
    turbulence 1
    scale 0.4
  #end
}

#declare T_Scuff_Banded = texture {
  #ifdef (Quick)
    T_OliveLeather1
  #else
    gradient y
    texture_map {
      [0.00 T_Scuff3        translate y*-0.5 scale 1/8.6]
      [0.02 T_Scuff3        translate y*-0.5 scale 1/8.6]
      [0.02 T_Scuff1        translate y*-0.5 scale 1/17]
      [0.03 T_Scuff1        translate y*-0.5 scale 1/17]
      [0.03 T_Scuff3        translate y*-0.5 scale 1/8.6]
      [0.50 T_Scuff3        translate y*-0.5 scale 1/8.6]
      [0.50 T_OliveLeather1 translate y*-0.5 scale 1/8.6]
      [0.60 T_OliveLeather1 translate y*-0.5 scale 1/8.6]
      [0.60 T_Scuff3        translate y*-0.5 scale 1/8.6]
      [0.98 T_Scuff3        translate y*-0.5 scale 1/8.6]
      [0.98 T_Scuff2        translate y*-0.5 scale 1/8.6]
      [1.00 T_Scuff2        translate y*-0.5 scale 1/8.6]
    }
    translate y*0.5
    scale 8.6
  #end
}

#declare T_CornerScuff = texture {
  #ifdef (Quick)
    T_OliveLeather1
  #else
    gradient x
    texture_map {
      [0.00 T_ScuffedLeather scale 0.25]
      [0.50 T_ScuffedLeather scale 0.25]
      [0.50 T_OliveLeather2]
      [1.00 T_OliveLeather2]
    }
    scale 4
    translate x*-2
    rotate z*-45
    turbulence 0.1
    omega 1.10
    warp { black_hole <1,-1,0>, 10 falloff 6 strength 2 inverse }
    scale 0.25
  #end
}

#declare T_EdgeScuff = texture {
  #ifdef (Quick)
    T_OliveLeather1
  #else
    gradient x
    texture_map {
      [0.00 T_ScuffedLeather scale 0.25]
      [0.30 T_ScuffedLeather scale 0.25]
      [0.30 T_OliveLeather2]
      [1.00 T_OliveLeather2]
    }
    scale 4
    translate x*-2
    turbulence 0.1
    omega 0.75
    scale 0.5
  #end
}

#declare PageDimness = 0.8

#declare T_Red_Pages = texture {
  #ifdef (Quick)
    pigment { colour rgb < 1.0, 0.0, 0.0 > }
  #else
    pigment {
      gradient x
      colour_map {
        [0.00 colour rgb <1.0, 0.75, 0.75>*PageDimness]
        [0.25 colour rgb <1.0, 0.75, 0.75>*PageDimness]
        [0.50 colour rgb <1.0, 0.00, 0.00>*PageDimness]
        [0.75 colour rgb <1.0, 0.75, 0.75>*PageDimness]
        [1.00 colour rgb <1.0, 0.75, 0.75>*PageDimness]
      }
    }
    finish { phong 0.8 phong_size 200 }
    #ifdef (Final)
      normal {
        gradient x
        slope_map {
          [0.00 <0.5, 1>]
          [0.25 <1.0, 0>]
          [0.50 <1.0, 0>]
          [0.75 <1.0, 0>]
          [1.00 <1.5,-1>]
        }
      }
    #end
    scale 0.075
    translate x*-3
  #end
}

//============================================================ Shape definitions

// Leaf of the radially symmetrical "dingbats" on the spine
//
#declare DingbatLeaf = union {
  box { <0,-0.05,0>, <0.5,0.05,-1> }
   difference {
    box { <0,-0.5,0>, <2,0.5,-1> }
    cylinder { <0,0,0.1>, <0,0,-1.1> 0.5 translate y*-0.5 }
    cylinder { <0,0,0.1>, <0,0,-1.1> 0.5 translate y* 0.5 }
    cylinder { <0,0,0.1>, <0,0,-1.1> 0.5 scale <3,0.9,1> translate <2,-0.5,0> }
    cylinder { <0,0,0.1>, <0,0,-1.1> 0.5 scale <3,0.9,1> translate <2, 0.5,0> }
    translate x*0.1
  }
  cylinder { <0.25,0.25,0>, <0.25,0.25,-1> 0.12 }
}

#declare Dingbat = union {
  object { DingbatLeaf }
  object { DingbatLeaf rotate z* 90 }
  object { DingbatLeaf rotate z*180 }
  object { DingbatLeaf rotate z*270 }
  bounded_by { box { <-2.5,-2.5,0>, <2.5,2.5,1> }}
  scale 0.12
  texture { T_BlackLeather1 }
}

//================================================= Define the spine of the book

//  Main cylinder of the spine
//
#declare Book_1_main_spine_cyl=cylinder { <0,0,0>, <0,1,0>, .5 
  bounded_by { cylinder{ <0,0,0>, <0,1,0>, .5 }}
}

//  Nameplate.
//
#declare Book_1_nameplate = cylinder { <0,0,0>, <0,1.0625,0>, .5
  bounded_by { cylinder { <0,0,0>, <0,1.0625,0>, .5 }}
  scale <1.7501,1,0.3001>
  texture { T_MaroonLeather1 }
  translate y*1.575
}

// Gold foil for the stamped letters.  The way this is done is to
//  difference out the letters from the spine/nameplate assembly
//  (and boy, using a text object in a difference CSG is S-L-O-W!),
//  and then placing a slightly smaller cylinder inside the main spine.
//
#declare Book_1_golden_inside = cylinder { <0,0,0>, <0,1.0025,0>, .5
  bounded_by { cylinder { <0,0,0>, <0,1.0025,0>, .5 }}
  scale <1.7,1,0.25>
  translate y*0.03
  texture { GoldTemp }
}

// Actual assembly of the main spine.  To the main cylinder I add five tori
//  for the ribs, then difference out the dingbats and black horizontal
//  lines, and then finally the text.  I then add in the golden "insides",
//  then remove all but a thin slice with another cylinder so only a thin
//  curve remains.
//
#declare Book_1_main_spine = difference {
  union {
    difference {
      union {
        object { Book_1_main_spine_cyl 
          translate y*-.5
          scale <1,1,0.3>
          scale <1.75,8.6,1>
          texture { T_Scuff_Banded }
        }
        #ifndef (Quick)
         union {
            #declare foo=0
            #while (foo<5)
              #declare bar=2.7675-(foo*1.34375)
              torus { 1, 0.1 bounded_by { torus { 1,0.1 }} scale <0.8,1,0.2> translate y*bar }
              #declare foo=foo+1
            #end
            texture { T_Scuff1 }
          }
        #end
        object { Book_1_nameplate }
      }

      #ifndef (Quick)
        union {
          #declare foo=0
          #while (foo<6)
            #declare bar=(3.4)-(foo*1.34375)  // first one was 3.48125
            #if (foo != 1)
              #if (foo != 3)
                object { Dingbat translate <0,bar,-0.125> }
              #end
            #end
            #declare foo=foo+1
          #end

          #declare foo=-1
          #while (foo<6)
            #declare bar=2.75-(foo*1.34375)
            #declare baz=0.15
            #declare quux=0.25
            torus { 1,0.050 bounded_by { torus { 1,0.050 }} scale <0.875,1,0.15> translate y*(bar+baz)  }
            torus { 1,0.050 bounded_by { torus { 1,0.050 }} scale <0.875,1,0.15> translate y*(bar-baz)  }
            torus { 1,0.025 bounded_by { torus { 1,0.025 }} scale <0.900,1,0.15> translate y*(bar+quux) }
            torus { 1,0.025 bounded_by { torus { 1,0.025 }} scale <0.900,1,0.15> translate y*(bar-quux) }
            #declare foo=foo+1
          #end
          texture{ T_BlackLeather1 }

        }
        #ifdef (Final)

          text { ttf TitleFont "THE"
            1, 0.3*x
            scale <0.2,0.2,1>
            translate <-0.21,2.30,-0.3>
            bounded_by { box { <-0.25,2.29,-0.3>, <0.25,2.11, 0.7> }}
            texture { GoldTemp }
          }

          text { ttf TitleFont "ROXBURGHE"
            1, 0.2*x
            scale <0.2,0.2,1>
            translate <-0.69,2.05,-0.3>
            bounded_by { box { <-0.7,2.04,-0.3>, <0.7,1.86, 0.7> }}
            texture { GoldTemp }
          }

          text { ttf TitleFont "BALLADS"
            1, 0.3*x
            scale <0.2,0.2,1>
            translate <-0.58,1.80,-0.3>
            bounded_by { box { <-0.6,1.79,-0.3>, <0.6,1.51, 0.7> }}
            texture { GoldTemp }
          }

          text { ttf VolumeFont "VOL"
            1, 0.6*x
            scale <0.25,0.25,1>
            translate <-0.4,-.5,-0.3>
            bounded_by { box { <-0.41,-0.49,-0.3>, <0.41,-0.79, 0.7> }}
            texture { GoldTemp }
          }

          text { ttf VolumeFont "I"
            1, 0
            scale <0.25,0.25,1>
            translate <-0.01,-.85,-0.3>
            bounded_by { box { <-0.05,-0.84,-0.3>, <0.05,-0.114, 0.7> }}
            texture { GoldTemp }
          }
        #end
      #end

    }
    #ifdef (Final)
      object { Book_1_golden_inside translate y*1.575 }
      object { Book_1_golden_inside translate y*-1.05 }
    #end
  }
  cylinder { <0,0,0>, <0,1,0>, .5 
    bounded_by { cylinder{ <0,0,0>, <0,1,0>, .5 }}
    translate <0,-.5,0.2>
    scale <1,1,0.3>
    scale <1.75,8.7,1.05>
    texture { T_Scuff2 }
  }
}

// The cover is mostly maroon leather, but there's a narrow strip of olive
//  leather where it meets the spine, and triangular corner pieces.  The
//  maroon is rather sturdier than the olive, so it isn't worn (though it
//  is somewhat dirtier, as the knobbly surface traps dirt a heck of a lot
//  better than the smooth olive leather).
//
#declare Book_1_SideBinding = difference {
  union {
    box { <-0.5,-0.5,-0.125>, <0.5,0.5,0.125>
      texture { T_CornerScuff translate x*0.2}
      rotate y*180
      translate <-0.5, -0.5, 0.0>
      scale 0.5
      translate y*4.3
    }
    box { <-0.5,-0.5,-0.125>, <0.5,0.5,0.125>
      texture { T_CornerScuff translate x*0.2}
      rotate y*180
      translate <-0.5, -0.5, 0.0>
      scale 0.5
      translate y*4.3
      rotate x*180
    }
    box { <-0.5,7.6,-0.125>, <0.5,-7.6,0.125>
      texture { T_EdgeScuff rotate z*180 translate x*-0.1}
      translate <-0.5,0,0>
      scale 0.5
    }
    box { <-1.875,-0.5,-0.125>, <0,0.5,0.125>
      texture { T_EdgeScuff rotate z*-90 }
      translate <0,-0.5,0>
      scale 0.5
      translate <-0.5,4.3,0>
    }
    box { <-1.875,-0.5,-0.125>, <0,0.5,0.125>
      texture { T_EdgeScuff rotate z*-90 }
      translate <0,-0.5,0>
      scale 0.5
      translate <-0.5,4.3,0>
      rotate x*180
    }
    box { <-1.4375,-3.8,-0.0625>, <-0.5,3.8,0.0625>
      texture { T_OliveLeather2 }
    }
  }
  cylinder { <-1.375,-4.4,-0.0655>, <-1.375,4.4,-0.0655>, 0.025 texture { T_OliveLeather3 }}
  cylinder { <-1.325,-4.4,-0.0655>, <-1.325,4.4,-0.0655>, 0.025 texture { T_OliveLeather3 }}
  cylinder { <-1.375,-4.4, 0.0655>, <-1.375,4.4, 0.0655>, 0.025 texture { T_OliveLeather3 }}
  cylinder { <-1.325,-4.4, 0.0655>, <-1.325,4.4, 0.0655>, 0.025 texture { T_OliveLeather3 }}
  bounded_by { box { <-1.4375,-4.3,-0.125>, <0,4.3,0.125> }}
}

#declare Book_1_Corner=difference {
  difference {
    box { <-0.71875,-0.71875,-0.0625>, <0.71875,0.71875,0.0625> scale 1.001 }
    plane { -x, 0 rotate z*-45 }
    intersection {
      cylinder { <0,0,-1>, <0,0,1>, 0.2 inverse }
      box { <-1,1,-1>, <0,0,1> }
      translate <-0.51875,0.51875,0>
    }
    texture { T_CornerScuff scale 1.4375 translate <-0.15,0.15,0> }
  }
  union {
    cylinder { <0,-1,-0.0655>, <0,1,-0.0655>, 0.025 translate x*-0.05 rotate z*-45 }
    cylinder { <0,-1,-0.0655>, <0,1,-0.0655>, 0.025 translate x*-0.10 rotate z*-45 }
    cylinder { <0,-1, 0.0655>, <0,1, 0.0655>, 0.025 translate x*-0.05 rotate z*-45 }
    cylinder { <0,-1, 0.0655>, <0,1, 0.0655>, 0.025 translate x*-0.10 rotate z*-45 }
    texture { T_OliveLeather1 }
  }
  translate <-5.78125,3.58125>
}

#declare Book_1_Cover=union {
  difference {
    box { <-6.5,-4.3,-0.0625>, <-1.4375,4.3,0.0625> }
    intersection {
      box { <-0.71875,-0.71875,-0.0625>, <0.71875,0.71875,0.0625> scale 1.001 }
      plane { x, 0 rotate z*-45 }
      translate <-5.78125,3.58125>
    }
    intersection {
      box { <-0.71875,-0.71875,-0.0625>, <0.71875,0.71875,0.0625> scale 1.001 }
      plane { x, 0 rotate z*-45 }
      translate <-5.78125,3.58125>
      rotate x*180
    }
    texture { T_MaroonLeather2 }
  }
  object { Book_1_Corner }
  object { Book_1_Corner rotate x*180 }
}

// Draw the pages.  They follow the curve of the spine, so I'll use a cylinder
//  both to add to the binding edge, and difference out of the cut edge.  The
//  pages are "gilded" with a shiny red substance.
//
#declare Book_1_Page_Curve = cylinder { <0,0,0>, <0,1,0>, .5 
  bounded_by { cylinder{ <0,0,0>, <0,1,0>, .5 }}
  translate y*-.5
  scale <1,1,0.3>
  scale <1.375,8.350,1>
}

#declare Book_1_Pages = difference {
  union {
    box { <-0.6875, -4.175, 0.2>, <0.6875, 4.175, 6.275> }
    object { Book_1_Page_Curve translate z*0.2 }
  }
  object { Book_1_Page_Curve scale <1,1.001,1> translate z*6.275 }
  texture { T_Red_Pages }
}

// Now just put the whole thing together.
//
#declare Book_1 = union {
  object { Book_1_main_spine }
  object { Book_1_SideBinding rotate y*90 translate x*-0.8125 }
  object { Book_1_SideBinding rotate y*90 translate x* 0.8125 }
  object { Book_1_Cover       rotate y*90 translate x*-0.8125 }
  object { Book_1_Cover       rotate y*90 translate x* 0.8125 }
  object { Book_1_Pages }
  translate z*-3.25
}

#ifdef (ShowProgress)
  #debug "<<< exiting book1.inc\n"
#end