// Book number two -- Roxburghe Ballads, volume two (1874).
//  This file requires that book1.inc be included first, as that
//  file defines most of the textures and objects used in this one.
//
// As it is very similar to book1.inc, it is otherwise uncommented.
//  The only difference is in the patterns of wear and dirt on the
//  leather, and the substitution of "VOL II" for "VOL I".
//
#ifdef (ShowProgress)
  #debug ">>> parsing book2.inc\n"
#end

#declare T_MaroonLeather3 = texture {
  pigment {
    bozo
    colour_map {
      [ 0.00 pigment Maroon1 ]
      [ 0.60 pigment Maroon1 ]
      [ 1.00 pigment DirtyMaroon ]
    }
    turbulence 0.5
    translate z*0.5
  }
#ifndef (Quick)
  #ifdef (Final)
    normal
    {
      quilted 
      turbulence <1,1,0>
      scale 0.1
    }
  #end
  finish { phong 0.5 phong_size 100}
#end
}

#declare T_Scuff_Banded2 = texture {
  #ifdef (Quick)
    T_OliveLeather1
  #else
    gradient y
    texture_map {
      [0.00 T_Scuff3        translate z*-0.5 scale 1/8.6]
      [0.02 T_Scuff3        translate z*-0.5 scale 1/8.6]
      [0.02 T_Scuff1        translate z*-0.5 scale 1/17]
      [0.03 T_Scuff1        translate z*-0.5 scale 1/17]
      [0.03 T_Scuff3        translate z*-0.5 scale 1/8.6]
      [0.50 T_Scuff3        translate z*-0.5 scale 1/8.6]
      [0.50 T_OliveLeather1 translate z*-0.5 scale 1/8.6]
      [0.60 T_OliveLeather1 translate z*-0.5 scale 1/8.6]
      [0.60 T_Scuff3        translate z*-0.5 scale 1/8.6]
      [0.98 T_Scuff3        translate z*-0.5 scale 1/8.6]
      [0.98 T_Scuff2        translate z*-0.5 scale 1/8.6]
      [1.00 T_Scuff2        translate z*-0.5 scale 1/8.6]
    }
    translate y*0.5
    scale 8.6
  #end
}

#declare Book_2_main_spine = difference {
  union {
    difference {
      union {
        object { Book_1_main_spine_cyl 
          translate y*-.5
          scale <1,1,0.3>
          scale <1.75,8.6,1>
          texture { T_Scuff_Banded2 }
        }
        #ifndef (Quick)
         union {
            #declare foo=0
            #while (foo<5)
              #declare bar=2.7675-(foo*1.34375)
              torus { 1, 0.1 bounded_by { torus { 1,0.1 }} scale <0.8,1,0.2> translate y*bar }
              #declare foo=foo+1
            #end
            texture { T_Scuff1 translate z*0.5 }
          }
        #end
        object { Book_1_nameplate }
      }
      #ifndef (Quick)
        union {
          #declare foo=0
          #while (foo<6)
            #declare bar=(3.4)-(foo*1.34375)
            #if (foo != 1)
              #if (foo != 3)
                object { Dingbat translate <0,bar,-0.125> }
              #end
            #end
            #declare foo=foo+1
          #end
          #declare foo=-1
          #while (foo<6)
            #declare bar=2.75-(foo*1.34375)
            #declare baz=0.15
            #declare quux=0.25
            torus { 1,0.050 bounded_by { torus { 1,0.050 }} scale <0.875,1,0.15> translate y*(bar+baz)  }
            torus { 1,0.050 bounded_by { torus { 1,0.050 }} scale <0.875,1,0.15> translate y*(bar-baz)  }
            torus { 1,0.025 bounded_by { torus { 1,0.025 }} scale <0.900,1,0.15> translate y*(bar+quux) }
            torus { 1,0.025 bounded_by { torus { 1,0.025 }} scale <0.900,1,0.15> translate y*(bar-quux) }
            #declare foo=foo+1
          #end
          texture{ T_BlackLeather1 }
        }
        #ifdef (Final)
          text { ttf TitleFont "THE"
            1, 0.3*x
            scale <0.2,0.2,1>
            translate <-0.21,2.30,-0.3>
            bounded_by { box { <-0.25,2.29,-0.3>, <0.25,2.11, 0.7> }}
            texture { GoldTemp }
          }
          text { ttf TitleFont "ROXBURGHE"
            1, 0.2*x
            scale <0.2,0.2,1>
            translate <-0.69,2.05,-0.3>
            bounded_by { box { <-0.7,2.04,-0.3>, <0.7,1.86, 0.7> }}
            texture { GoldTemp }
          }
          text { ttf TitleFont "BALLADS"
            1, 0.3*x
            scale <0.2,0.2,1>
            translate <-0.58,1.80,-0.3>
            bounded_by { box { <-0.6,1.79,-0.3>, <0.6,1.51, 0.7> }}
            texture { GoldTemp }
          }
          text { ttf VolumeFont "VOL"
            1, 0.6*x
            scale <0.25,0.25,1>
            translate <-0.4,-.5,-0.3>
            bounded_by { box { <-0.41,-0.49,-0.3>, <0.41,-0.79, 0.7> }}
            texture { GoldTemp }
          }
          text { ttf VolumeFont "II"
            1, 0
            scale <0.25,0.25,1>
            translate <-0.075,-.85,-0.3>
            bounded_by { box { <-0.11,-0.84,-0.3>, <0.11,-0.114, 0.7> }}
            texture { GoldTemp }
          }
        #end
      #end
    }
    #ifdef (Final)
      object { Book_1_golden_inside translate y*1.575 }
      object { Book_1_golden_inside translate y*-1.05 }
    #end
  }
  cylinder { <0,0,0>, <0,1,0>, .5 
    bounded_by { cylinder{ <0,0,0>, <0,1,0>, .5 }}
    translate <0,-.5,0.2>
    scale <1,1,0.3>
    scale <1.75,8.7,1.05>
    texture { T_Scuff2 }
  }
}


#declare Book_2_Cover=union {
  difference {
    box { <-6.5,-4.3,-0.0625>, <-1.4375,4.3,0.0625> }
    intersection {
      box { <-0.71875,-0.71875,-0.0625>, <0.71875,0.71875,0.0625> scale 1.001 }
      plane { x, 0 rotate z*-45 }
      translate <-5.78125,3.58125>
    }
    intersection {
      box { <-0.71875,-0.71875,-0.0625>, <0.71875,0.71875,0.0625> scale 1.001 }
      plane { x, 0 rotate z*-45 }
      translate <-5.78125,3.58125>
      rotate x*180
    }
    texture { T_MaroonLeather3 }
  }
  object { Book_1_Corner }
  object { Book_1_Corner rotate x*180 }
}



#declare Book_2 = union {
  object { Book_2_main_spine }
  object { Book_1_SideBinding rotate y*90 translate x*-0.8125 }
  object { Book_1_SideBinding rotate y*90 translate x* 0.8125 }
  object { Book_2_Cover       rotate y*90 translate x*-0.8125 }
  object { Book_2_Cover       rotate y*90 translate x* 0.8125 }
  object { Book_1_Pages }
  translate z*-3.25
}


#ifdef (ShowProgress)
  #debug "<<< exiting book2.inc\n"
#end
