// book3.inc -- based on Greek Testament, 1809.  Heavily damaged spine, showing
//  the binding leather underneath.  Water damage and scratches on the cover
//  boards; worn along the edges.

#ifdef (ShowProgress)
  #debug ">>> parsing book3.inc\n"
#end

#ifdef (Final)
  #declare FindFontParameter="timesbd.ttf"
  #include "findfont.inc"
  #declare Book3Font=FindFontResult
#end

#ifndef (T_Gold_3A)
  #include "golds.inc"
#end

#declare Brown1=     colour rgb < 60/255,  35/255,   0/255>
#declare Brown2=     colour rgb < 80/255,  50/255,   0/255>
#declare Brown3=     colour rgb <100/255,  65/255,   0/255>*1.1
#declare Brown4=     colour rgb <121/255,  65/255,   0/255>
#declare Brown5=     colour rgb <155/255, 120/255,   0/255>

#declare Grey1  = colour rgb <115/255, 108/255, 109/255>*0.5
#declare Grey2  = colour rgb <133/255, 125/255, 132/255>*0.5
#declare Scuff1 = colour rgb <176/255, 108/255,  80/255>
#declare Scuff2 = colour rgb <231/255, 165/255, 135/255>

#declare N_Leather1 = normal { bumps 1.1 scale 0.05 }
#declare N_Leather2 = normal { wrinkles 1.1 scale 0.05 }
#declare N_Leather3 = normal { quilted turbulence <1,1,0> scale 0.1 }
#declare N_Leather4 = normal { quilted turbulence <0,1,1> scale 0.1 }


#declare N_WrinkledBinding = normal {
  average
  normal_map {
    [1 N_Leather1 ]
    [1 wrinkles 2.0 scale <0.75,4,1> turbulence 0.2]
  }
}

#declare N_SpineLeather = normal {
  average
  normal_map {
    [1 N_Leather3]
    [1 bumps 0.3 scale 0.4]
  }
}

#declare T_SpineLeather1 = texture {
  pigment {
    bozo
    colour_map {
      [ 0.00 Grey1 ]
      [ 1.00 Grey2 ]
    }
    scale 2.0
  }
  #ifndef (Quick)
    finish { phong 0.45 phong_size 100 }
    normal { N_SpineLeather }
  #end
}


#declare T_BindingLeather1 = texture {
  pigment { colour rgb <0.49, 0.37, 0.22>*1.3 }
  #ifndef (Quick)
    normal { N_Leather1 }
  #end
}

#declare T_BindingLeather2 = texture {
  #ifdef (Quick)
    pigment { colour rgb <0.49, 0.37, 0.22> }
  #else
    pigment {
      bozo
      colour_map { 
        [0.0 colour rgb <0.45, 0.34, 0.20>]
        [0.5 colour rgb <0.49, 0.37, 0.22>*1.2]
        [1.0 colour rgb <0.45, 0.34, 0.20>]
      }
      turbulence 0.1
      scale 2.0
    }
    normal { N_WrinkledBinding }
  #end
}

#ifdef (Quick)
  #declare T_Clear = texture { pigment { colour rgb <1,1,1> }}
#else
  #declare T_Clear = texture { pigment { colour rgbt <1,1,1,1> }}
#end

#declare T_BindingLeather = texture {
  #ifdef (Quick)
    T_BindingLeather1
  #else
    gradient y
    texture_map {
      [0.000 T_Clear]
      [0.005 T_Clear]
      [0.005 T_BindingLeather1 scale <0.174,0.044,0.357>]
      [0.030 T_BindingLeather1 scale <0.174,0.044,0.357>]
      [0.030 T_BindingLeather2 scale <0.174,0.044,0.357>]
      [0.970 T_BindingLeather2 scale <0.174,0.044,0.357>]
      [0.970 T_BindingLeather1 scale <0.174,0.044,0.357>]
      [0.995 T_BindingLeather1 scale <0.174,0.044,0.357>]
      [0.995 T_Clear]
      [1.000 T_Clear]
    }
    turbulence y*0.05
  #end
}

#declare T_ScuffedLeather1 = texture {
  pigment { Scuff1 }
  #ifdef (Final)
    normal { N_Leather1 }
  #end
}

#declare T_ScuffedLeather2 = texture {
  pigment { Scuff2 }
  #ifdef (Final)
    normal { N_Leather2 }
  #end
}

#declare T_LeatherCrack1 = texture {
  crackle
  texture_map {
    [0.000 T_ScuffedLeather1 scale 10]
    [0.100 T_ScuffedLeather1 scale 10]
    [0.100 T_SpineLeather1 scale 10]
    [1.000 T_SpineLeather1 scale 10]
  }
  turbulence 0.1
  scale 0.1
}

#declare T_Cracked_Leather = texture {
  gradient x
  texture_map {
    [0.000 T_LeatherCrack1]
    [0.300 T_LeatherCrack1]
    [0.450 T_SpineLeather1]
    [1.000 T_SpineLeather1]
  }
  scale <5.75,22.7,1.0>
}

// Damn, this turned out better than I had expected!
//
#declare T_Spine_Leather = texture {
  gradient y
  texture_map {
    [0.000 T_Clear]
    [0.154 T_Clear]
    [0.154 T_ScuffedLeather1 scale <0.174,0.044,0.357>]
    [0.169 T_ScuffedLeather1 scale <0.174,0.044,0.357>]
    [0.169 T_SpineLeather1   scale <0.174,0.044,0.357>]
    [0.169 T_Cracked_Leather scale <0.174,0.044,0.357>]
    [0.206 T_Cracked_Leather scale <0.174,0.044,0.357>]
    [0.206 T_SpineLeather1   scale <0.174,0.044,0.357>]
    [0.330 T_SpineLeather1   scale <0.174,0.044,0.357>]
    [0.330 T_Cracked_Leather scale <0.174,0.044,0.357>]
    [0.360 T_Cracked_Leather scale <0.174,0.044,0.357>]
    [0.360 T_SpineLeather1   scale <0.174,0.044,0.357>]
    [0.485 T_SpineLeather1   scale <0.174,0.044,0.357>]
    [0.485 T_Cracked_Leather scale <0.174,0.044,0.357>]
    [0.515 T_Cracked_Leather scale <0.174,0.044,0.357>]
    [0.515 T_SpineLeather1   scale <0.174,0.044,0.357>]
    [0.639 T_SpineLeather1   scale <0.174,0.044,0.357>]
    [0.639 T_Cracked_Leather scale <0.174,0.044,0.357>]
    [0.669 T_Cracked_Leather scale <0.174,0.044,0.357>]
    [0.669 T_SpineLeather1   scale <0.174,0.044,0.357>]
    [0.793 T_SpineLeather1   scale <0.174,0.044,0.357>]
    [0.793 T_Cracked_Leather scale <0.174,0.044,0.357>]
    [0.800 T_Cracked_Leather scale <0.174,0.044,0.357>]
    [0.800 T_ScuffedLeather1 scale <0.174,0.044,0.357>]
    [0.805 T_ScuffedLeather1 scale <0.174,0.044,0.357>]
    [0.805 T_ScuffedLeather2 scale <0.174,0.044,0.357>]
    [0.815 T_ScuffedLeather2 scale <0.174,0.044,0.357>]
    [0.815 T_Clear]
    [1.000 T_Clear]
  }
  turbulence y*0.05
}

#declare T_Binding_Strip = texture {
  gradient z
  texture_map {
    [0.00 T_ScuffedLeather1 scale <5,0.044,0.45>]
    [0.05 T_ScuffedLeather1 scale <5,0.044,0.45>]
    [0.05 T_SpineLeather1   scale <5,0.044,0.45>]
    [1.00 T_SpineLeather1   scale <5,0.044,0.45>]
  }
  turbulence 0.2
  scale <1,1,1.2>
}

#declare T_Cover1 = texture {
  pigment { 
    bozo
    pigment_map {
      [0.00 Brown2]
      [0.35 Brown2]
      [0.65 Brown4]
      [1.00 Brown4]
    }
    scale 0.1
  }
  #ifdef (Final)
    finish { phong 0.15 phong_size 20 }
    normal { N_Leather4 scale 0.1 }
  #else
    finish { phong 0.15 phong_size 20}
  #end
}

#declare T_Cover2 = texture {
  crackle
  texture_map {
    [0.00 T_ScuffedLeather2 scale 5]
    [0.05 T_ScuffedLeather2 scale 5]
    [0.10 T_Cover1 scale 50]
    [1.00 T_Cover1 scale 50]
  }
  scale 0.02
}

#declare T_Cover_Board1 = texture {
  bozo
  texture_map {
    [0.00 T_Cover2 scale 4]
    [0.25 T_Cover2 scale 4]
    [0.50 T_Cover1 scale 4]
    [1.00 T_Cover1 scale 4]
  }
  scale 0.25
}

#declare T_Cover_Board2 = texture {
  gradient z
  texture_map {
    [0.00 T_Cover_Board1]
    [0.98 T_Cover_Board1]
    [0.98 T_ScuffedLeather1 scale 0.1]
    [1.00 T_ScuffedLeather1 scale 0.1]
  }
  turbulence 0.02
}

#declare T_Cover_Board = texture {
  #ifdef (Quick)
    T_Cover1
  #else
    gradient y
    texture_map {
      [0.00 T_ScuffedLeather1 scale 0.1]
      [0.02 T_ScuffedLeather1 scale 0.1]
      [0.02 T_Cover_Board2]
      [0.98 T_Cover_Board2]
      [0.98 T_ScuffedLeather1 scale 0.1]
      [1.00 T_ScuffedLeather1 scale 0.1]
    }
    turbulence 0.03
  #end
}

#declare PageDimness = 1.0

#declare T_Yellow_Pages = texture {
  #ifdef (Quick)
    pigment { colour rgb < 1.0, 0.0, 0.0 > }
  #else
    pigment {
      gradient x
      colour_map {
        [0.00 colour rgb <0.75, 0.75, 0.00>*PageDimness]
        [0.25 colour rgb <0.75, 0.75, 0.00>*PageDimness]
        [0.50 colour rgb <0.50, 0.50, 0.00>*PageDimness]
        [0.75 colour rgb <0.75, 0.75, 0.00>*PageDimness]
        [1.00 colour rgb <0.75, 0.75, 0.00>*PageDimness]
      }
    }
    finish { phong 0.1 phong_size 20 }
    #ifdef (Final)
      normal {
        gradient x
        slope_map {
          [0.00 <0.5, 1>]
          [0.25 <1.0, 0>]
          [0.50 <1.0, 0>]
          [0.75 <1.0, 0>]
          [1.00 <1.5,-1>]
        }
      }
    #end
    scale 0.005

    translate x*-300
  #end
}


//=========================================================== Object Definitions

// The interior binding leather.  It's a little wrinkled from the quires
//  underneath it.
//
#declare Book_3_Binding_Leather = difference {
  cylinder { <0,0,0>, <0,1,0>, 0.5 }
  cylinder { <0,0,0.05>, <0,1,0.05>, 0.5 scale <1,1.002,1> translate y*-0.001}
  texture { T_BindingLeather }
  translate <0,-0.5,0>
  scale <5.5,22.7,2.8>
}

#declare Book_3_Spine_Cutout = torus { 0.5, 0.04 scale <1,1.65198237885,1> }

#declare Book_3_Spine_Cylinder = difference {
  cylinder { <0,0,0>, <0,-1,0>, 0.5 }
  object { Book_3_Spine_Cutout translate y*-0.099118942733 }
  object { Book_3_Spine_Cutout translate y*-0.253303964759 }
  object { Book_3_Spine_Cutout translate y*-0.407488986785 }
  object { Book_3_Spine_Cutout translate y*-0.561674008811 }
  object { Book_3_Spine_Cutout translate y*-0.715859030837 }
  object { Book_3_Spine_Cutout translate y*-0.870044052863 }
}

#declare Book_3_Spine = intersection {
  difference {
    object { Book_3_Spine_Cylinder }
    object { Book_3_Spine_Cylinder scale <1,1.002,1> translate <0,-0.001,0.05> }
  }
  cylinder { <0,-0.1321,0>, <0,-0.829,0>, 0.501 }
  texture { T_Spine_Leather }
  translate <0,0.5,-0.15>
  scale <5.75,22.7,2.8>
}

#declare Book_3_Binding_Strip = box { <0,0,0>, <1,-1,1>
  texture { T_Binding_Strip }
  translate <-0.5,0.5,0>
  scale <0.2,22.7,2.2>
}

#declare Book_3_Cover_Board = box { <0,0,0>, <1,-1,1>
  texture { T_Cover_Board }
  translate <-0.5,0.5,0>
  scale <0.2,22.7,11.1>
}

#declare Book_3_Cover = union {
  object { Book_3_Binding_Strip }
  object { Book_3_Cover_Board translate z*2.2 }
}

#declare FontScale = < 1/10,1/40,1 >

#ifdef (Final)
  #declare Book_3_Titles = intersection {
    object { Book_3_Spine_Cylinder translate <0,0.5,-0.152> }
    union {
      text { ttf Book3Font "A",         2, 0      bounded_by { box { <0,0,0>, <0.7,0.7,2> }} translate x*-0.35 scale FontScale translate <0, 0.2750,-1> }
      text { ttf Book3Font "SCHOLLERS", 2, x*0.1  bounded_by { box { <0,0,0>, <6.9,0.8,2> }} translate x*-3.45 scale FontScale translate <0, 0.2400,-1> }
      text { ttf Book3Font "TOOLS",     2, x*0.1  bounded_by { box { <0,0,0>, <3.8,0.8,2> }} translate x*-1.90 scale FontScale translate <0, 0.2050,-1> }
      text { ttf Book3Font "IEFF LEE",  2, x*0.1  bounded_by { box { <0,0,0>, <5.3,0.8,2> }} translate x*-2.65 scale FontScale translate <0,-0.2050,-1> }
      text { ttf Book3Font "MCMXCVII",  2, x*0.01 bounded_by { box { <0,0,0>, <5.6,0.8,2> }} translate x*-2.80 scale FontScale translate <0,-0.2500,-1> }
//
//  By the way, that's not a typo -- circa 1600, the letters "I" and "J" were
//   typographically interchangeable, so "JEFF LEE" and "IEFF LEE" are
//   equivalent -- and equally valid -- period spellings of my name.
//
    }
    scale <5.75,22.7,2.8>
    texture { T_Gold_3A }
  }
#end


#declare Book_3_Page_Curve = cylinder { <0,-0.5,0>, <0,0.5,0>, 0.5
  scale <5.35,21.7,2.8>
}

#declare Book_3_Pages = difference {
  union {
    box { <-2.675,-10.85,0>, <2.675,10.85,13> }
    object { Book_3_Page_Curve }
  }
  object { Book_3_Page_Curve scale <1,1.001,1> translate z*13 }
  texture { T_Yellow_Pages scale 0.1 }
}

#declare Book_3 = union {
  #ifndef (Quick)
    object { Book_3_Spine }
  #end
  object { Book_3_Binding_Leather }
  object { Book_3_Cover translate x*-2.775 }
  object { Book_3_Cover rotate z*180 translate x* 2.775 }
  object { Book_3_Pages translate z* 0.010 }
  #ifdef (Final)
    object { Book_3_Titles }
  #end
}

#ifdef (ShowProgress)
  #debug "<<< exiting book3.inc\n"
#end
