// Book number four -- Biblia Hebraica, 1872.  Extremely worn spine, so much
//  that most of the leather finish is worn away, and two shades of leather
//  underneath are visible (a kind of orangey-pink intermediate layer, and a
//  darker red bottom layer).  The title is all but invisible, so I haven't
//  even bothered putting it on.  What leather remains on the spine is dark
//  brown with a kind of greenish cast.  The leather on the covers is fairly
//  intact, though quite worn where they meet the spine.

#ifdef (ShowProgress)
  #debug ">>> parsing book4.inc\n"
#end

//====================================== Pigment, normal and texture definitions

#declare Book4Dimness=0.75

#declare Brown1=     colour rgb < 60/255,  35/255,   0/255>
#declare Brown2=     colour rgb < 80/255,  50/255,   0/255>
#declare Brown3=     colour rgb <100/255,  65/255,   0/255>
#declare Brown5=     colour rgb <121/255,  65/255,   0/255>
#declare Brown4=     colour rgb <155/255, 120/255,   0/255>
#declare Scuff2=     colour rgb <192/255,  64/255,   0/255>*Book4Dimness
#declare Scuff3=     colour rgb <223/255, 120/255,   0/255>*Book4Dimness
#declare Yellow1=    colour rgb <230/255, 218/255, 110/255>
#declare Yellow2=    colour rgb <205/255, 194/255,  97/255>
#declare Clear=      colour rgbt <1,1,1,1>

#declare LeatherNormal1 = normal { bumps 1.01 scale 0.075 }   // was wrinkles 0.85
#declare LeatherNormal2 = normal { wrinkles 1.01 scale 0.05 }  // was 0.75
#declare LeatherNormal3 = normal { quilted turbulence <1,1,0> scale 0.1 }

#declare T_Clear = texture { pigment { Clear }}

#declare T_ScuffedLeather2 = texture {
  pigment{ Scuff2 }
  #ifdef (Final)
    normal { LeatherNormal2 }
  #end
}

#declare T_ScuffedLeather3 = texture {
  pigment{ Scuff3 }
  #ifdef (Final)
    normal { LeatherNormal1 }
  #end
}

#declare T_DullBrownLeather = texture {
  pigment { Brown1 }
}

#declare T_BrownLeather1 = texture {
  pigment {
    bozo
    colour_map {
      [ 0.00 Brown1 ]
      [ 1.00 Brown2 ]
    }
    scale 0.5
  }
  #ifdef (Final)
    finish { phong 0.8 phong_size 20 }
    normal { LeatherNormal3 }
    normal { bumps 0.4 }
  #end
}

#declare T_BrownLeather2 = texture {
  pigment {
    bozo
    colour_map {
      [ 0.00 Brown1 ]
      [ 1.00 Brown2 ]
    }
    scale 0.5
  }
  #ifdef (Final)
    finish { phong 0.8 phong_size 20 }
    normal { LeatherNormal3 scale 0.1 }
  #end
}


#declare T_DamagedLeather = texture {
  bozo
  texture_map {
    [0.00 T_BrownLeather1 ]
    [0.40 T_BrownLeather1 ]
    [0.40 T_ScuffedLeather3 ]
    [0.60 T_ScuffedLeather3 ]
    [0.60 T_ScuffedLeather2 ]
    [1.00 T_ScuffedLeather2 ]
  }
  turbulence 0.9
  scale <0.05,0.25,1.0>*0.75
}

#declare T_BindingStrings = texture {
  gradient x
  texture_map {
    [0.00 T_ScuffedLeather2]
    [0.50 T_ScuffedLeather3]
    [1.00 T_ScuffedLeather2]
  }
  turbulence 0.5
}


#declare T_CoverLeather1 = texture {
  #ifdef (Quick)
    T_BrownLeather1
  #else
    gradient x
    texture_map {
      [0.00 T_ScuffedLeather3 ]
      [0.03 T_ScuffedLeather3 ]
      [0.03 T_BrownLeather2]
      [1.00 T_BrownLeather2]
    }
    scale 2
    turbulence 0.05
    omega 0.75
    scale 0.5
  #end
}

#declare T_CoverLeather2 = texture {
  #ifdef (Quick)
    T_BrownLeather1
  #else
    gradient y
    texture_map {
      [0.00 T_ScuffedLeather3 ]
      [0.02 T_ScuffedLeather3 ]
      [0.02 T_BrownLeather2]
      [1.00 T_BrownLeather2]
    }
    scale 2
    turbulence 0.045
    omega 0.75
    scale 0.5
  #end
}


#declare T_SpineLeather = texture {
  gradient y
  texture_map {
    [0.00 T_DamagedLeather ]
    [0.17 T_DamagedLeather ]
    [0.18 T_BindingStrings ]
    [0.20 T_BindingStrings ]
    [0.21 T_DamagedLeather ]
    [0.36 T_DamagedLeather ]
    [0.37 T_BindingStrings ]
    [0.39 T_BindingStrings ]
    [0.40 T_DamagedLeather ]
    [0.55 T_DamagedLeather ]
    [0.56 T_BindingStrings ]
    [0.58 T_BindingStrings ]
    [0.59 T_DamagedLeather ]
    [0.74 T_DamagedLeather ]
    [0.75 T_BindingStrings ]
    [0.77 T_BindingStrings ]
    [0.78 T_DamagedLeather ]
    [1.00 T_DamagedLeather ]
  }
}

#declare PageDimness=0.75

#declare T_White_Pages = texture {
  #ifdef (Quick)
    pigment { colour rgb < 1.0, 0.95, 0.85 > }
  #else
    pigment {
      gradient x
      colour_map {
        [0.00 colour rgb <1.0, 0.95, 0.85>*PageDimness]
        [0.25 colour rgb <1.0, 0.95, 0.85>*PageDimness]
        [0.50 colour rgb <0.6, 0.40, 0.10>*PageDimness]
        [0.75 colour rgb <1.0, 0.95, 0.85>*PageDimness]
        [1.00 colour rgb <1.0, 0.95, 0.85>*PageDimness]
      }
    }
    finish { phong 0.25 phong_size 200 }
    #ifdef (Final)
      normal {
        gradient x
        slope_map {
          [0.00 <0.5, 1>]
          [0.25 <1.0, 0>]
          [0.50 <1.0, 0>]
          [0.75 <1.0, 0>]
          [1.00 <1.5,-1>]
        }
        turbulence 0.0001
      }
    #end
    scale 0.006
    translate x*-3
  #end
}

//========================================================== Object declarations

// The spine is much simpler than in the other books.  The surface is mostly
//  flat, except where the binding strings are.
//
#declare Book_4_Spine = union {
  difference {
    cylinder { <0,0,0>, <0,-1,0>, 1 }
    cylinder { <0,-0.001,0.1>, <0,-1.001,0.1>, 1 }
  }
  #ifndef (Quick)
    intersection {
      union {
        torus { 1, 0.04  bounded_by { cylinder {<0,-0.04,0>,<0,0.04,0>,1}} scale <1,0.25,1> translate y*-0.19 }
        torus { 1, 0.04  bounded_by { cylinder {<0,-0.04,0>,<0,0.04,0>,1}} scale <1,0.25,1> translate y*-0.38 }
        torus { 1, 0.04  bounded_by { cylinder {<0,-0.04,0>,<0,0.04,0>,1}} scale <1,0.25,1> translate y*-0.57 }
        torus { 1, 0.04  bounded_by { cylinder {<0,-0.04,0>,<0,0.04,0>,1}} scale <1,0.25,1> translate y*-0.76 }
      }
      plane { z, 0 }
    }
  #end
  scale <0.17,1,0.08>
  texture { T_SpineLeather }
  translate y*0.5
}

// Since the cover is all made of the same kind of leather, there's no binding
//  edge or corner pieces.
//
#declare Book_4_Cover = box { <0,0,-0.005>, <0.64,-1,0.005>
  texture { T_CoverLeather2 }
  translate y*0.5
}

// Define the pages.  As with the other books, the pages follow the curve of
// the spine, so the "page_curve" object is used both in a union (on the spine
// end) and a difference (on the cut end).
//
#declare Book_4_Page_Curve = cylinder { <0,0.005,0>, <0,-0.995,0>, 1
  scale <0.165,1,0.08>
  translate y*0.5
}

#declare Book_4_Pages = difference {
  union {
    box { <-0.165, -0.495, 0.005>, <0.165, 0.495, 0.63> }
    object { Book_4_Page_Curve translate z*0.005 }
  }
  object { Book_4_Page_Curve scale <1,1.001,1> translate z*0.64 }
  texture { T_White_Pages }
  translate z*0.005
}

// And put it all together.
//
#declare Book_4 = union {
  object { Book_4_Spine }
  object { Book_4_Pages scale <1,0.95,1> }
  object { Book_4_Cover rotate y*-90 translate x*-0.165 }
  object { Book_4_Cover rotate y*-90 rotate z*180 translate x*0.165 }
  translate z*-0.32
  scale 1/0.35
}

#ifdef (ShowProgress)
  #debug "<<< exiting book4.inc\n"
#end