// bread.inc -- a hunk of bread.  Used to erase the lead ruling lines from
//  the paper.  No, really.  Stop laughing.  From "Rules by F.B. for Children
//  to write by":
//
//      Scholler to learne, it may do you pleasure,
//      To rule him two lines iust of a measure:
//      Those two lines betweene to write very iust,
//      Not aboue or below write that he must:
//      The same to be done is best with blacke lead,
//      which written betweene is cleansed with bread.
//
// "White" bread back then was about as white as our wheat bread today.

#ifdef (ShowProgress)
  #debug ">>> parsing bread.inc\n"
#end

#declare HoleSeed=seed(301)

#declare NumHoles1=50   // holes around the edge of the crust
#declare NumHoles2=300  // holes in the "white" bit
#declare NumHoles3=100  // holes around the edge of the "white" bit

//========================================================== Texture definitions

#declare T_BreadCrust = texture {
  pigment {
    gradient y
    colour_map {
      [0.00 colour rgb <0.9,0.8,0.0> ]
      [1.00 colour rgb <0.6,0.4,0.0> ]
    }
    scale 3
    translate y*-1.5
  }
  #ifndef (Quick)
    normal { wrinkles 0.5 scale 0.15 }
    finish { phong 0.4 phong_size 30 }
  #end
}

#declare T_BreadInside = texture {
  pigment {
    bozo
    colour_map {
      [0.00 colour rgb <150/255, 145/255, 120/255> ]
      [0.02 colour rgb <150/255, 145/255, 120/255> ]
      [0.02 colour rgb <238/255, 226/255, 205/255> ]
      [1.00 colour rgb <238/255, 226/255, 205/255> ]
    }
  }
  scale 0.05
  normal { bumps scale 0.05 }
}

//=========================================================== Object definitions

#declare BreadCrust = difference {
  sphere { <0,0,0>, 1 }
  plane { z, 0 }
  sphere { <0,0,0>, 0.975 }
  #ifndef (Quick)
    union {
      #declare foo=0
      #while (foo < NumHoles1)
        #declare baz=rand(HoleSeed)*360
        #declare quux = (rand(HoleSeed)+0.01)*0.2
        sphere { <sin( radians( baz )), cos( radians( baz )), 0>, quux scale <1,1,0.2>}
        #declare foo=foo+1
      #end
      bounded_by { cylinder { <0,0,-0.041>, <0,0,0.041>, 1.211 }}
    }
  #end
  texture { T_BreadCrust }
}

#declare BreadInside = difference {
  intersection {
    sphere { <0,0,0>, 0.975 }
    plane {-z,0 }
  }
  #ifndef (Quick)
    union {
      #declare foo=0
      #while (foo < NumHoles2)
        #declare bar=rand(HoleSeed)
        #declare baz=rand(HoleSeed)*360
        #declare quux = (rand(HoleSeed)+0.01)*0.15
        sphere { <bar*sin( radians( baz )), bar*cos( radians( baz )), 0>, quux scale <1,1,0.1>}
        #declare foo=foo+1
      #end
      #declare foo=0
      #while (foo < NumHoles3)
        #declare baz=rand(HoleSeed)*360
        #declare quux = (rand(HoleSeed)+0.01)*0.01
        sphere { <sin( radians( baz )), cos( radians( baz )), 0>, quux scale <1,1,0.2>}
        #declare foo=foo+1
      #end
      bounded_by { cylinder { <0,0,-0.041>, <0,0,0.141>, 1.211 }}
    }
  #end
  texture { T_BreadInside }
}

// Put 'em both together
//
#declare Bread = union {
  object { BreadCrust }
  object { BreadInside }
  rotate <3,0.6,0>
  translate y*0.5
  scale <1,0.75,1.5>
}

#ifdef (ShowProgress)
  #debug "<<< exiting bread.inc\n"
#end
