// candle.inc -- slightly yellowish tallow candle.  


#debug ">>> parsing candle.inc\n"

#declare T_Candle = texture {
  pigment {
#ifdef (Quick)
    colour rgb <1.0, 1.0, 0.8>
#else
    gradient y
    colour_map {
      [0.00 colour rgb <2.5,2.5,2.0> ]
      [0.45 colour rgb <1.0,1.0,0.8> ]
      [1.00 colour rgb <1.0,1.0,0.8> ]
    }
#end
  }
  finish {
    ambient 0.4 diffuse 0.4 
#ifndef (Quick)
    phong 0.5
  }
  normal {
    bumps 0.03 scale 0.05
#end
  }
}

#declare CandleBody = union {
  difference {
    cylinder { <0,0,0>, <0,-10,0> 1.0 }
    sphere { <0,.4,0>, 1 }
  }
#declare flarp=0
#declare RS1=seed(1997)
#declare RS2=seed(1701)
#declare RS3=seed(7465)
#while (flarp < 6)
  #declare baz=(72*rand(RS2))*5
  blob {
    threshold 0.1
  #declare quux=-2-(8*rand(RS3))
  #declare foo=0.1
  #while (foo > quux)
    #declare bar=(rand(RS1)/5)
      sphere { <0,foo,-1>, (bar+0.15), bar+0.20 }
    #declare foo=foo-0.2
  #end
  rotate y*baz
  }
  #declare flarp=flarp+1
#end
  texture { T_Candle scale 10 }
}

#declare CandlePuddle = sphere { <0,0,0>, 1
   scale < 1.5, 0.2, 0.8 >
   translate <0,-10,-0.4>
   rotate y*-20
  texture { T_Candle scale 10 }
}

#declare CandleFlame = intersection {
  sphere { 0, 1 }
  box { <-1,-0.2, -1>, <1,1,1> }
#ifdef (Quick)
  pigment { colour rgb <1.0,0.8,0.6> }
  no_shadow
#else
    pigment { colour rgbt <1, 1, 1, 1> }
    halo {
      emitting
      spherical_mapping
      linear
      turbulence 0.375 // 0.5
      colour_map {
        [ 0.0 color rgbt <1.0, 0.6, 0.0,  1> ]
        [ 0.5 color rgbt <1.0, 1.0, 0.8, -1> ]
        [ 1.0 color rgbt <1.0, 0.7, 0.0,  1> ]
      }
      frequency 1
      samples 20
      scale 0.5
    }
    hollow
#end
    scale <1.5,6,1.5>
    translate y*1.25
  }

#declare CandleWick = intersection {
  torus { 1.0, 0.1 }
  box { <-1.2,-0.2,0>, <0, 0.2, 1.2> }
  rotate x*-90
  rotate z*90
  pigment {
    gradient y
    colour_map {
      [ 0.00 colour rgb <2,1.5,0> ]
      [ 0.25 colour rgb <1,0,0> ]
      [ 0.30 colour rgb <0,0,0> ]
      [ 1.00 colour rgb <0,0,0> ]
    }
    scale 2.0
  }
  finish { ambient 0.5 diffuse 0.25 }
  rotate z*-60
  translate <1,-0.25,0>
}  

#declare Candle=union {
  object { CandleBody rotate y*25 }
  object { CandleWick }
  object { CandlePuddle }
  object { CandleFlame }
  translate y*10
}


#debug "<<< exiting candle.inc\n"
