#ifdef (ShowProgress)
  #debug ">>> parsing house.inc\n"
#end

#declare DimHouse=0.75

#declare T_DarkBeams = texture {
  pigment { colour rgb <0.4,0.3,0.0>*DimHouse }
}

#declare T_HouseStucco = texture {
  pigment { colour rgb <1,1,1>*DimHouse }
  #ifndef (Quick)
    normal { wrinkles 0.1 }
    scale 0.05
  #end
}

#declare BeamDepth = 0.25

#declare VBeam = box { <-0.5,0,-(BeamDepth/2)>, <0.5,-1,(BeamDepth/2)> }
#declare HBeam = box { <0,-0.5,-(BeamDepth/2)>, <1,0.5,(BeamDepth/2)> }

#declare CenterBeams = union {
  object { VBeam scale <1,30,1> translate y*98 }
  object { VBeam scale <2,29,1> translate y*66 }
  object { VBeam scale <1,15,1> translate y*12 }
  texture { T_DarkBeams }
}

#declare SideBeams = union {
  object { HBeam scale <110,6,1> translate x*-2  rotate z*-50 translate y*98 }
  object { VBeam scale < 4,55,1> translate y*0.5 rotate z* 45 translate <27,34,0> }
  object { VBeam scale < 4,55,1> translate y*0.5 rotate z*-45 translate <65,34,0> }
  object { VBeam scale < 1,21,1> translate < 9.5, 89.0,0> }
  object { VBeam scale < 1,10,1> translate < 7.5, 66.0,0> }
  object { VBeam scale < 2,29,1> translate <15.0, 66.0,0> }
  object { VBeam scale < 2,29,1> translate <26.0, 66.0,0> }
  object { VBeam scale < 2, 2,1> translate <24.0, 66.0,0> }
  object { VBeam scale < 2,36,1> translate <24.0, 33.0,0> }
  object { VBeam scale < 1,15,1> translate <11.5, 12.0,0> }
  object { VBeam scale < 4,68,1> translate <65.0, 23.0,0> }
  object { VBeam scale < 2,21,1> translate <32.0, -6.0,0> }
  object { VBeam scale < 1,21,1> translate < 0.5, -6.0,0> }
  object { HBeam scale <33, 2,1> translate < 0.0, 67.0,0> }
  object { HBeam scale < 9, 2,1> translate <16.0, 63.0,0> }
  object { HBeam scale <13, 1,1> translate < 1.0, 55.5,0> }
  object { HBeam scale < 9, 2,1> translate <16.0, 50.0,0> }
  object { HBeam scale <56, 4,1> translate < 0.0, 35.0,0> }
  object { HBeam scale <23, 1,1> translate < 0.0, 12.5,0> }
  object { HBeam scale <63, 3,1> translate < 0.0, -4.5,0> }
  object { HBeam scale <63,18,1> translate < 0.0,-36.0,0> }
  texture { T_DarkBeams }
}

#declare WindowCutouts = union {
  box { < 1,66,-BeamDepth>, <14, 56,BeamDepth> }
  box { < 0,33,-BeamDepth>, <23, 13,BeamDepth> }
  box { < 1,-6,-BeamDepth>, <31,-27,BeamDepth> }
  box { <33,-6,-BeamDepth>, <63,-27,BeamDepth> }
}

#declare StuccoWall = difference {
  box { <-63,100,-0.001>, <63,-36,0.001> }
  object { WindowCutouts }
  object { WindowCutouts rotate y*180 }
  texture { T_HouseStucco }
}

#declare BottomWindow = union {
  object { VBeam scale < 1,21,0.75> translate < 0.5,  0.0,0> }
  object { VBeam scale < 1,21,0.75> translate <14.5,  0.0,0> }
  object { VBeam scale < 1,19,0.50> translate < 7.5, -1.0,0> }
  object { HBeam scale <13, 1,0.75> translate < 1.0, -0.5,0> }
  object { HBeam scale <13, 1,0.50> translate < 1.0, -7.0,0> }
  object { HBeam scale <13, 1,0.50> translate < 1.0,-14.0,0> }
  object { HBeam scale <13, 1,0.75> translate < 1.0,-20.5,0> }
  box { <0.5,0.5,-0.0001>, <14.5,-20.5,0.0001> pigment { colour rgb <0,0,0> }}
  pigment { colour rgb <1,1,1>*DimHouse }
}

#declare BottomWindowSet = union {
  object { BottomWindow translate < 1,-6,0> }
  object { BottomWindow translate <16,-6,0> }
  object { BottomWindow translate <33,-6,0> }
  object { BottomWindow translate <48,-6,0> }
}

#declare MiddleWindow = union {
  difference {
    union {
      box { <-0.25,0.5,-(BeamDepth/4)>, <0.25,0.225,(BeamDepth/4)> }
      cylinder { <0,0.25,-(BeamDepth/4)>, <0,0.25,(BeamDepth/4)>, 0.2 }
      box { <-0.025,-0.5,-(BeamDepth/4)>, <0.025,0.25,(BeamDepth/4)> }
    }
    box { <-0.225,0.51,-(BeamDepth/2)>, <0.225,0.275,(BeamDepth/2)> }
    cylinder { <0,0.25,-(BeamDepth/2)>, <0,0.25,(BeamDepth/2)>, 0.15 }
    texture { T_DarkBeams }
  }
  box { <-0.25,0.5,-0.0001>, <0.25,0.5,0.0001> pigment { colour rgb <0,0,0> }}
  scale <23,20,1>
}

#declare MiddleWindowSet = intersection {
  union {
    object { MiddleWindow translate <  0.0,23,0> }
    object { MiddleWindow translate < 11.5,23,0> }
    object { MiddleWindow translate < 23.0,23,0> }
    object { MiddleWindow translate <-11.5,23,0> }
    object { MiddleWindow translate <-23.0,23,0> }
  }
  box { <-23.01,14.9,-(BeamDepth/2)>, <23.01,35.1,(BeamDepth/2)> }
}

#declare WindowLatticeBar = object { VBeam scale <0.125,15,(BeamDepth/4)> rotate z*30 }
#declare TopWindowLattice = union {
  #declare foo=-22
  #while (foo < 13)
    object { WindowLatticeBar translate <foo,67,0> }
    object { WindowLatticeBar rotate x*180 translate <foo,55,0> }
    #declare foo=foo+2
  #end
}

#declare TopWindow = union {
  intersection {
    object { TopWindowLattice }
    box { <-13,66,-BeamDepth>, <13,56,BeamDepth> }
    pigment { colour rgb <0.8,0.8,0.8>*DimHouse }
  }
  box { <-13,66,-0.0001>, <13,56,0.0001> pigment { colour rgb <0,0,0> }}
}

#declare FacadeSpotlight = light_source { <-80,200,-10> colour rgb <1,1,1>*0.25
  spotlight
  point_at <0,0,0>
  radius 40
  falloff 60
}

#declare Facade = union {
  intersection {
    union {
      object { StuccoWall }
      object { CenterBeams }
      object { SideBeams }
      object { SideBeams rotate y*180 }
    }
    intersection {
      box { <-67,100,-(BeamDepth*2)>, <67, -45,(BeamDepth*2)> }
      plane { y, 0 rotate z*-50 translate y*99.5 }
      plane { y, 0 rotate z*50  translate y*99.5 }
      texture { T_DarkBeams }
    }
  }
  #ifdef (Quick)
    finish { ambient 0.75 diffuse 0.0 }
  #else
    object { TopWindow }
    object { MiddleWindowSet }
    object { BottomWindowSet }
    object { BottomWindowSet rotate y*180 }
    object { FacadeSpotlight }
    finish { ambient 0.5 diffuse 0.1 }
  #end
  translate y*45
  scale 0.0069
}

#ifdef (ShowProgress)
  #debug "<<< exiting house.inc\n"
#end