#ifdef (ShowProgress)
  #debug ">>> parsing inkwell.inc\n"
#end

#declare T_Cork = texture { // Modified "Cork" from textures.v2 (darker spots)
  #ifdef (Quick)
    pigment { color rgb <0.93, 0.71, 0.532> }
  #else
    pigment {
      granite
      color_map {
        [0.00, 0.60 color rgb <0.93, 0.71, 0.532>
                    color rgb <0.98, 0.81, 0.60>]
        [0.60, 0.65 color rgb <0.31, 0.18, 0.12>
                    color rgb <0.31, 0.18, 0.12>]
        [0.65, 1.00 color rgb <0.61, 0.41, 0.35>
                    color rgb <0.65, 0.58, 0.27>]
      }
    }
    finish { specular 0.1 roughness 0.5 }
    scale 0.25
  #end
}

#declare T_Ink_Cork = texture {         // cork covered in ink
  #ifdef (Quick)
    pigment { color rgb <0.28, 0.19, 0.03> }
  #else
    pigment {
      granite
     color_map {
        [0.00, 0.60 color rgb <0.28, 0.19, 0.03>
                    color rgb <0.30, 0.23, 0.08>]
        [0.60, 0.65 color rgb <0.15, 0.05, 0.12>
                    color rgb <0.15, 0.05, 0.12>]
        [0.65, 1.00 color rgb <0.18, 0.09, 0.03>
                    color rgb <0.19, 0.16, 0.01>]
      }
    }
    finish { specular 0.9 roughness 0.005 }
    scale 0.25
  #end
}

#declare T_Inkwell_Glass = texture {
  #ifdef (Quick)
    pigment { colour rgb <0.95, 1.0, 1.0> }
  #else
    pigment { colour rgbf <0.95, 1.0, 1.0, 0.95> }
    finish {
      specular 1
      roughness 0.001
      refraction 1   
      reflection 0.1
      ior 1.5
    }
  #end
}

#declare T_Ink = texture {
    pigment { colour rgb <66/255,23/255,0> }
  #ifndef (Quick)
    finish { phong 1.0 phong_size 150 }
  #end
}

#declare T_No_Ink = texture { pigment { colour rgbt <1,1,1,1> }}

#declare T_Inky_Cork = texture {
  gradient y
  texture_map {
    [0.00 T_Cork     scale 1.05]
    [0.60 T_Cork     scale 1.05]
    [0.60 T_Ink_Cork scale 1.05]
    [1.00 T_Ink_Cork scale 1.05]
  }
  translate y*-0.35
  scale 0.25
  turbulence 0.15
  omega 0.75
}

#declare Inkwell_Glass=difference {
  merge {
    torus { 0.07, 0.01 sturm translate y*0.30 }
    torus { 0.15, 0.01 sturm translate y*0.01 }
    cylinder { <0.00, 0.31, 0.00>, <0.00, 0.29, 0.00>, 0.07 }
    cylinder { <0.00, 0.30, 0.00>, <0.00, 0.27, 0.00>, 0.08 }
    cylinder { <0.00, 0.28, 0.00>, <0.00, 0.18, 0.00>, 0.06 }
    cylinder { <0.00, 0.16, 0.00>, <0.00, 0.01, 0.00>, 0.16 }
    cylinder { <0.00, 0.02, 0.00>, <0.00, 0.00, 0.00>, 0.15 }
    sphere { <0.00, 0.00, 0.00>, 0.01 scale <16,6,16> translate y*0.16 }
  }
  cylinder { <0.00, 0.32, 0.00>, <0.00, 0.14, 0.00>, 0.05 }
  cylinder { <0.00, 0.15, 0.00>, <0.00, 0.01, 0.00>, 0.15 }
  sphere { <0.00, 0.00, 0.00>, 0.01 scale <15,6,15> translate y*0.15 }
  texture { T_Inkwell_Glass }
}  

#declare Inkwell_InkDrip = cylinder { <0,0.30,0>, <0,0.23,0>, 0.0499
  hollow
  texture {
    bozo
    texture_map {
      [0.00 T_Ink]
      [0.50 T_Ink]
      [0.50 T_No_Ink]
      [1.00 T_No_Ink]
    }
    turbulence 0.2
    scale 0.05
  }
}  

#declare Inkwell_Ink=cylinder { 
  <0.00, 0.14, 0.00>, <0.00, 0.01001, 0.00>, 0.14999
  texture { T_Ink }
}

#declare Inkwell=union {
  object { Inkwell_Glass }
  object { Inkwell_Ink }
  object { Inkwell_InkDrip }
}

#declare Inked_Cork = cone { <0,0,0>, 0.045, <0,0.1,0>, 0.037
  texture { T_Inky_Cork }
}

#ifdef (ShowProgress)
  #debug "<<< exiting inkwell.inc\n"
#end