/******************************************************************************
 *                               A Scholler's Tools                           *
 *                                                                            *
 *   POV-Ray 3.0 source file for the March-April 1997 IRTC ("School")         *
 *                                                                            *
 *         Author: Jeff Lee <shipbrk@gate.net>                                *
 *                                                                            *
 ******************************************************************************/

//#declare Quick=1         // Uncomment for quick position-check test renders
#declare Final=1         // Uncomment for final render
#declare ShowProgress=1  // Makes .inc files speak up when called

#ifndef (Final)
  #debug "\n"
  #debug "*********************************************************************\n"
  #debug "*** Because 'Final' has not been defined, there will be some CSGs ***\n"
  #debug "*** with only one object in them.  Warnings will be generated; it ***\n"
  #debug "*** is safe to ignore them.                                       ***\n"
  #debug "*********************************************************************\n"
#end

#include "colors.inc"
#include "golds.inc"

#include "table.inc"
#include "candle.inc"
#include "stick.inc"
#include "paper.inc"
#include "quillpen.inc"
#include "book1.inc"
#include "book2.inc"
#include "inkwell.inc"
#include "sealwax.inc"
#include "knife.inc"
#include "bread.inc"
#include "scribble.inc"
#include "book4.inc"
#include "book3.inc"
#include "room.inc"

#declare LitCandle = union {
  object { CandleStick }
  object { Candle translate y*15.6 }
}

#declare FinalCamera=camera { location <0,10,-40> look_at <0,10,0> }
#declare TopCamera = camera { location <0,60,15> look_at <0,0,15> orthographic }
#declare FrontCamera=camera { location <0,0,-60> look_at <0,0,0> orthographic }

#declare LightMultiplier=1

#ifdef (Quick)
  #declare LightMultiplier=1.5
#end

#declare CandleLight = light_source { <23, 26, 15>
  colour rgb LightMultiplier*1.0*<1,0.9,0.7>
  fade_distance 40
  fade_power 2
}

#declare FillLight1 = light_source { <-3,10,-10> 
  colour rgb LightMultiplier*0.9*<1.0,0.9,0.8>
  shadowless
  fade_distance 30
  #ifdef (Quick)
    fade_power 1
  #else
    fade_power 2
  #end
}

camera { FinalCamera }
object { CandleLight }
object { FillLight1 }

// The scaling on these objects is rather strange; some objects I modelled in
//  metric measurements; others were done in inches, and some were done using
//  purely arbitrary measurement (such as the width of a superellipsoid).
// 
object { Table        translate y*-7.29 }
object { LitCandle    translate <23,-3,15>}
object { CalligPaper  scale 12 rotate y*-45 translate <-8,-7.28,4> }
object { QuillPen     scale 20 rotate z*-10 rotate y*91 translate <3,-6.53,-3>}
object { ScratchPaper scale 24 rotate <90,-35,0> translate <27,-7.28,12> }
object { Inkwell      scale 15 translate <16,-7.28,8> }
object { Inked_Cork   translate y*-0.05 scale 15 rotate z*-94.55 rotate y*-12.5 translate <27,-6.6775,4> }
object { SealingWax   rotate y*135 scale 1.5 translate <26,-7.28,9> }
object { PenKnife     rotate y*40 translate <6,-7.28,12> }
object { Bread        scale 5 rotate y*65 translate <2,-7.29,22> }
object { Book_1       scale 3.5 rotate z*90 rotate y*45 translate <30,-4.15,31> }
object { Book_2       scale 3.5 rotate z*90 rotate y*-65 translate <-36,5.85,28> }
object { Book_4       rotate z*-90 translate y*0.5 scale 10 rotate y*-67.5 translate <-38,-7.28,29> }
object { Book_3       rotate z*-90 translate <0,2.875,-2.25> scale 1.4 translate <0,-7.28,33> rotate z*12.5 translate <-3.0,3.14,0> }
object { Room         translate <0,2.5,15> scale 50 }
