#ifdef (ShowProgress)
  #debug ">>> parsing knife.inc\n"
#end

#ifndef (Quick)
  #ifndef (T_Chrome_3C)
    #ifndef (Clear)
      #include "colors.inc"
    #end
    #include "metals.inc"
  #end
  #ifndef (T_Gold_3A)
    #include "golds.inc"
  #end
#end

#declare T_BladeMetal = texture {
  #ifdef (Quick)
    pigment { colour rgb <1,1,1> }
  #else
    T_Chrome_3C
    normal { wrinkles 0.2 scale 0.9 }
  #end
}

#declare T_RivetMetal = texture {
  #ifdef (Quick)
    pigment { colour rgb <1,1,0> }
  #else
    T_Gold_3A
    normal { wrinkles 0.6 scale 0.4 }
  #end
}

#declare T_HandleWood = texture {
  #ifdef (Quick)
    pigment { colour rgb <0.5,0.4,0.0> }
  #else
    pigment {
      wood
      colour_map {
        [0.0 colour rgb <0.5,0.4,0>]
        [0.5 colour rgb <0.4,0.3,0>]
        [1.0 colour rgb <0.5,0.4,0>]
      }
      turbulence 0.05
    }
    scale 0.5
    translate <10,10,0>
    translate y*10
    rotate <0,90,0.5>
    normal { wrinkles 0.5 }
  #end
}

#declare Blade = intersection {
  plane { y, 0.05 }
  union {
    cone { <0,0,0>, 1, <0,0,-0.05>, 0.95 scale <3,1,1> }
    cone { <0,0,0>, 1, <0,0, 0.05>, 0.95 scale <3,1,1> }
  }
  translate <-1,0.475,0>
  texture { T_BladeMetal }
}

#declare HandleCap = intersection {
  superellipsoid { <1,0.25> rotate x*90 }
  box { <-1.1,0,-1.1>, <0,1.1,1.1> }
}

#declare HandleMiddle = intersection {
  superellipsoid { <0.25,0.25> }
  box { <-0.5,0,-1.1>, <0.5,1.1,1.1> }
}

#declare HandleSide = union {
  object { HandleMiddle scale <20,1,1> }
  object { HandleCap translate x*-10 }
  object { HandleCap rotate y*180 translate x*10 }
  scale <1,0.75,1>
  texture { T_HandleWood }
}

#declare PenInside = union {
  cylinder { <-6,-0.05,0>, <-6,0.05,0>, 0.6 }
  cylinder { < 6,-0.05,0>, < 6,0.05,0>, 0.6 }
  box { <-6,-0.05,-0.6>, <6,0.05,0.6> }
  texture { T_BladeMetal }
}

#declare PenKnife = union {
  object { HandleSide scale 0.6 translate y*0.05 }
  object { HandleSide scale 0.6 translate y*0.05 rotate x*180}
  object { Blade translate x*-7 rotate x*90 }
  object { PenInside }
  cylinder { <-5.5,-0.525,0>, <-5.5,0.525,0>, 0.2 texture { T_RivetMetal }}
  cylinder { < 5.5,-0.525,0>, < 5.5,0.525,0>, 0.2 texture { T_RivetMetal }}
  translate y*0.6
}

#ifdef (ShowProgress)
  #debug "<<< exiting knife.inc\n"
#end