#ifdef (ShowProgress)
  #debug ">>> parsing openbook.inc\n"
#end

#declare T_OldPaper1 = texture {
  pigment {
    bozo
    colour_map {
      [1.0 colour rgb <1.0,239/255,206/255>]
      [0.5 colour rgb <1.0,247/255,206/255>]
      [0.0 colour rgb <1.0,239/255,198/255>]
    }
  }
}

#declare T_BookPage1 = texture {
  #ifdef (Quick)
    pigment { colour rgb <1,1,1> }
  #else
    pigment {
      image_map {
        gif "batarde.gif"
        transmit 1, 1.0
        map_type 0
        once
      }
      scale 2.5
      translate <0.25,0.25,0>
    }
  #end
}

#declare OpenBookLeaf = bicubic_patch {
  type 1
  flatness 0
  u_steps 4
  v_steps 4
  <0,0,0>, <0.001,0,-1>, <1.5,0,0.2>, <3,0,-0.2>
  <0,1,0>, <0.001,1,-1>, <1.5,1,0.2>, <3,1,-0.2>
  <0,2,0>, <0.001,2,-1>, <1.5,2,0.2>, <3,2,-0.2>
  <0,3,0>, <0.001,3,-1>, <1.5,3,0.2>, <3,3,-0.2>
  texture { T_OldPaper1 }
  texture { T_BookPage1 }
  translate <0,-1.5,-0.2>
  scale <4.4/3, 5.1/3, 2>
  rotate x*90
}

#declare OpenBookPages = difference {
  union {
    cylinder { <0,0,-0.5>, <0,0,0.5>, 0.5 scale <2,1,1> translate <1,0.5,0> }
    box { <0,0,-0.5>, <5,0.5,0.5> }
    box { <1,0.5,-0.5>, <3.3,0.8,0.5> }
  }
  intersection {
    cylinder { <0,0,-0.51>, <0,0,0.51>, 0.5 scale <4,1,1> translate <0.5,-0.3,0> }
    plane { -x, -0.5 }
  }
  cylinder { <0,0,-0.51>, <0,0,0.51>, 0.5 translate <0.5,-0.3,0> }
  cylinder { <0,0,-0.51>, <0,0,0.51>, 0.5 scale <3.05,1,1> translate <3.2,1,0> }
  plane { -x, 0 rotate z*45 translate x*5 }
  scale <1,1,5>
  texture { T_OldPaper1 }
}

#declare OpenBookCover= union {
  box { <0,0,-2.625>, <5.125,-0.125,2.625> rotate z*-1 translate <0.2,0.125,0> }
  box { <0,0,-2.625>, <5.125,-0.125,2.625> rotate z*-1 translate <0.2,0.125,0> rotate y*180 }
  box { <-0.4,0,-2.625>, <0.4,-0.125,2.625> }
  pigment { colour rgb <0,0,0> }
}

#declare OpenBook = union {
  #ifndef (Quick)
    object { OpenBookLeaf }
    object { OpenBookLeaf rotate y*180 }
  #end
  object { OpenBookPages }
  object { OpenBookPages rotate y*180 }
  object { OpenBookCover }
  translate y*0.125
}

#ifdef (ShowProgress)
  #debug "<<< exiting openbook.inc\n"
#end