// Paper with calligraphy on it.  The text of the calligraphy, from the foreword
// of _A Treatise on the abuse of Dauncing_ (anonymous, printed 1581), is as
// follows:
//
//      I Doubt not, but that some, into whose handes this
//      little treatise shall come, wil thinke me to be at
//      greate leasure, that have enterprised largely to
//      levie out and handle this argument: which to their
//      seeming is not otherwise of great importaunce.  For
//      be it that daunces were allowed or condemned, or else that
//      they were putt in the rowe of thinges indifferent men
//      might easily iudge according to their opinion, that that
//      should not bring great profit or hurt to our christian
//      common wealth, seeing that ther are divers points
//      of greater weight and consequence, which trouble the
//      spirits of many learned men, & make afraide the
//
// Typical for the period, it condemns not only dancing, but actors as well.
// It was probably written by a Calvinist minister, who (as was their wont)
// denounced anything even remotely fun, but especially those things which
// drew men and women into close physical proximity.
//
// I chose this particular work for the calligraphy only because it was
// the first thing that came to hand when I started looking for a period
// text to use.

#ifdef (ShowProgress)
  #debug ">>> parsing paper.inc\n"
#end

#declare T_OldPaper1 = texture {
  pigment {
    bozo
    colour_map {
      [0.0 colour rgb <1.0,239/255,198/255>]
      [0.5 colour rgb <1.0,247/255,206/255>]
      [1.0 colour rgb <1.0,239/255,206/255>]
    }
  }
  #ifndef (Quick)
    normal { wrinkles scale 0.5 }
  #end
}

#ifndef (Quick)
#declare T_Calligraphy_1 = texture {
  pigment {
    image_map {
      gif "callig.gif"
      transmit 224, 1.0
      map_type 0
      once
    }
    scale 0.86
    translate <0.07,0.07,0>
  }
}
#end

#ifdef (Quick)
  #declare bcp_Paper1 = mesh {
    triangle { <0,0,0>, <0,1,0>, <1,0,0> }
    triangle { <1,1,0>, <0,1,0>, <1,0,0> }
  }
#else
  #declare bcp_Paper1 = bicubic_patch {
    type 1
    flatness 0
    u_steps 4
    v_steps 4
    <0,0,0>, <1,0,0>, <2,0,0>, <3,0,0>
    <0,1,0>, <1,1,0>, <2,1,0>, <3,1,0>
    <0,2,0>, <0.25,0.25,0>, <2,2,-0.1>, <3,2,0>
    <0,3,-0.25>, <1,3,0>, <2,3,0>, <3,3,0>
    scale 1/3
  }
#end

#declare CalligPaper = object { bcp_Paper1
  texture { T_OldPaper1 }
#ifndef (Quick)
  texture { T_Calligraphy_1 }
#end
  scale <0.68862912,1,1>
  rotate x*90
  scale 3
  translate <-1.03294368, 0, -1.5>
}


#ifdef (ShowProgress)
  #debug "<<< exiting paper.inc\n"
#end