#ifdef (ShowProgress)
  #debug ">>> parsing quillpen.inc\n"
#end

// Feather is centred at the point of the nib; it extends back in the Z
// direction, and is one unit long.  The cardioid "vein" is pointing up.

#ifndef (Final)
  #declare segments_in_circle=30  // Mesh of 600 triangles
  #declare segments_in_shaft=10
#else
  #declare segments_in_circle=180  // Mesh of 16,200 triangles.
  #declare segments_in_shaft=45
#end
#declare feather_length=75
#declare start_radius=2.0
#declare end_radius=1.0
#declare slope=(start_radius-end_radius)/feather_length
#declare huge_circle_radius=300
#declare end_huge_angle=15
#declare end_huge_angle2=5

// The equation of a cardioid is r = a(1-cosA)

#declare Calamus = mesh {
  #declare zpos = 0;
  #while (zpos < feather_length)
    #declare foo=0
    #while (foo<360)
      #declare zpos2 = zpos + (feather_length/segments_in_shaft)
      #declare xofs1 = -(huge_circle_radius-(huge_circle_radius*cos( radians( end_huge_angle / feather_length * zpos))))
      #declare xofs2 = -(huge_circle_radius-(huge_circle_radius*cos( radians( end_huge_angle / feather_length * zpos2))))
      #declare yofs1 = huge_circle_radius-(huge_circle_radius*cos( radians( end_huge_angle2 / feather_length * zpos)))
      #declare yofs2 = huge_circle_radius-(huge_circle_radius*cos( radians( end_huge_angle2 / feather_length * zpos2)))
      #declare bar = foo + (360/segments_in_circle)
      #declare r1 = (start_radius-(slope*zpos)) * foo * (1-cos( radians( foo ))) / 270
      #declare pt1x = r1 * sin( radians( foo )) + xofs1
      #declare pt1y = r1 * cos( radians( foo )) + yofs1
      #declare r2 = (start_radius-(slope*zpos)) * bar * (1-cos( radians( bar ))) / 270
      #declare pt2x = r2 * sin( radians( bar )) + xofs1
      #declare pt2y = r2 * cos( radians( bar )) + yofs1
      #declare r3 = (start_radius-(slope*zpos)) * foo * (1-cos( radians( foo ))) / 270
      #declare pt3x = r3 * sin( radians( foo )) + xofs2
      #declare pt3y = r3 * cos( radians( foo )) + yofs2
      #declare r4 = (start_radius-(slope*zpos)) * bar * (1-cos( radians( bar ))) / 270
      #declare pt4x = r4 * sin( radians( bar )) + xofs2
      #declare pt4y = r4 * cos( radians( bar )) + yofs2
      triangle { <pt1x, pt1y, zpos>, <pt2x, pt2y, zpos>, <pt3x, pt3y, zpos2> }
      triangle { <pt2x, pt2y, zpos>, <pt3x, pt3y, zpos2>, <pt4x, pt4y, zpos2> }
      #declare foo=foo+(360/segments_in_circle)
    #end
    #declare zpos = zpos + (feather_length/segments_in_shaft);
  #end
  pigment { colour rgb <1,1,0.95> }
  finish { phong 1 phong_size 200 }
}


#declare T_Nib1=texture {
  pigment { 
    gradient x
    colour_map {
      [0.00 colour rgb <1,1,0.95> ]
      [0.50 colour rgb <1,1,0.95> ]
      [0.50 colour rgbt <1,1,0.95,0.45> ]
      [1.00 colour rgbt <1,1,0.95,0.45> ]
    }
    scale 3
    turbulence x*0.2
    translate x*3.1
    rotate y*90
  } 
}

#declare T_Nib2=texture {
  pigment {
    bozo
    colour_map {
      [0.00 colour rgbt <1,1,0.95,0.65>]
      [0.30 colour rgbt <1,1,1,1>]
      [1.00 colour rgbt <1,1,1,1>]
    }
  }
}

#declare T_Nib3=texture {
  pigment { 
    gradient x
    colour_map {
      [0.000 colour rgbt <1,1,1,1> ]
      [0.275 colour rgbt <1,1,1,1> ]
      [0.275 colour rgb <66/255,23/255,0> ]
      [1.000 colour rgb <66/255,23/255,0> ]
    }
    scale <42,3,3>
    frequency 0.5
    turbulence 0.1
    translate x*-13//12
    rotate y*90
  } 
}

#declare NibBody = merge {
  sphere { <0,0,0> 1 }
  cylinder { <0,0,0>, <0,0,-2> 1 }
}

#declare Nib = difference {
  object { NibBody
    texture { T_Nib1 }
    scale 2
    scale <0.89,0.88,7.0>
    texture { T_Nib2 }
    texture { T_Nib3 }
    finish { phong 1 phong_size 200 }
  }
  object { NibBody scale 1.95 scale <0.89,0.88,7.0> pigment { colour rgbt <1,1,1,1> }}

  union {
    box { <-2,-2,-21>,<2,2,-10> pigment { colour rgb <0,0,0> }}
    sphere { <0,5.1,-10> 6  pigment { colour rgb <0,0,0> }}
    sphere { <0,0,0> 1.5 scale <1,1,1.5> translate < 1.25, -0.25, -9.75> pigment { colour rgb <0,0,0> }}
    sphere { <0,0,0> 1.5 scale <1,1,1.5> translate <-1.25, -0.25, -9.75> pigment { colour rgb <0,0,0> }}
    box { <-0.01,-3,-11>,<0.01,-2,-6> pigment { colour rgb <1,1,1> }}
    translate z*-8
  }
  rotate z*-25
  translate <-0.55,-1.05,0>
}



#declare QuillPen = union {
  object { Calamus }
  object { Nib }
  translate z*18
  rotate z*25
  rotate x*0.5
  scale 1/93
}


#ifdef (ShowProgress)
  #debug "<<< exiting quillpen.inc\n"
#end