// room.inc -- an Elizabethan drawing room (modelled roughly on that of "Edmund
//   Blackadder" from the British television show).  Because the scene for
//   which this was written will be dimly lit, I am not going to get anal about
//   the level of detail.  As a matter of fact, it will contain very little
//   actual detail (just enough so that we don't have a boring black background
//   for the foreground objects in the scene).
//
// Because the objects are not very detailed, I haven't bothered to split them
//   up into separate files.  The candle sconces are quite nice, though.
//
// Uses a couple of standard wood and metal textures.
//

#ifdef (ShowProgress)
  #debug ">>> parsing room.inc\n"
#end

#declare RotSeed = seed(42)

//====================================================== Include necessary files

#include "openbook.inc"
#include "house.inc"

#ifndef (Clear)
  #include "colors.inc"
#end

#ifndef (T_Wood8)
  #include "woods.inc"
#end

#ifndef (T_Silver_5E)
  #include "metals.inc"
#end

#ifndef (Candle)
  #include "candle.inc"
#end

//================================================= Declare colours and textures

#declare T_WindowGlass = texture {
  #ifdef (Quick)
    pigment { colour rgb <0.75, 1.0, 1.0> }
  #else
    pigment { colour rgbf <0.975, 1.0, 1.0, 0.9> }
    finish  {
      ambient 0.1
      diffuse 0.1
      reflection 0.15
      refraction 1
      ior 1.45
      specular 0.8
      roughness 0.003
      phong 1
      phong_size 400
    }
  #end
}

#declare T_Room_Walls = texture {
  pigment { colour rgb <1,1,1> }
  #ifndef (Quick)
    normal { wrinkles }
  #end
  scale 0.1
}

#declare T_WoodBeam = texture {
  #ifdef (Quick)
    pigment { colour rgb <0.40,0.03,0.00> }
  #else
    T_Wood8 scale 0.1
  #end
}

#declare T_Mirror = texture {
  #ifdef (Quick)
    pigment { colour rgb <0.9,0.9,1.0> }
  #else
    T_Silver_5E
  #end
}

#declare T_FloorPlanks = texture {
  pigment { colour rgb <0.80,0.80,0.00> }
}

#declare T_Beaten_Iron = texture {
  pigment { colour rgb <0.00,0.00,0.05> }
  finish { phong 0.8 phong_size 50 }
  normal { dents 2 scale 0.05 }
}

#declare T_BlondWood = texture {
#ifdef (Quick)
  pigment { colour rgb <0.6,0.6,0.0> }
#else
  pigment {
    wood
    colour_map {
      [ 0.000 colour rgb <0.4000,0.2000,0.0000>*1.3 ]
      [ 0.050 colour rgb <0.4250,0.3500,0.0000>*1.3 ]
      [ 0.845 colour rgb <0.7225,0.5950,0.0000>*1.3 ]
      [ 0.850 colour rgb <0.3000,0.2000,0.0000>*1.5 ]
      [ 0.855 colour rgb <0.7225,0.5950,0.0000>*1.3 ]
      [ 1.000 colour rgb <0.8500,0.7000,0.0000>*1.3 ]
    }
    turbulence <0.03, 0.03, 0.1>
    octaves 5
    lambda 3.25
    omega 0.75
    rotate <0,90,4>
    scale 1
    translate <10,0,0>
  }
  #ifdef (Final)
    finish { phong 1.0 reflection 0.1 }
  #end
#end
  translate y*6
}


//================================= Declare structures for the walls and ceiling

#declare Room_CeilingBeam = box { <-1,-1,-1>, <1,1,0>
  scale <0.25,0.1,30>
  rotate x*11.25
  translate z*10
  translate y*4.9
  texture { T_WoodBeam }
}

#declare Room_WindowBeam = box { <-1,-1,-1>, <1,1,0>
  scale <0.25,0.1,30>
  rotate x*-90
  translate z*10
  translate y*-5
  texture { T_WoodBeam }
}

#declare Room_WindowDivider = box { <-1,-1,-1>, <1,1,0>
  scale <0.25,0.1,7>
  rotate x*-90
  translate z*10
  translate y*2
  texture { T_WoodBeam }
}

#declare Room_WallBeam = box { <-1,-1,-1>, <1,1,1>
  scale <0.2,0.5,20>
  texture { T_WoodBeam }
}

#declare Room_DiagonalBeam = box { <-1,0,-1>, <1,-1,1>
  scale <0.2,30,0.25>
  rotate x*27.5
  translate <0,4,9.5>
  texture { T_WoodBeam }
}

#declare RoomWindowCutout = box { <-7,2,9>, <7,-4.5,11> }

#declare RoomSolid = difference {
  box { <-10.1,-10.1,10.1>, <10.1,10.1,-20.1> }
  intersection {
    box { <-10,-10,10>, <10,10,-20> }
    plane { y, 5 rotate x*11.25 translate z*10 }
  }
  object { RoomWindowCutout }
  texture { T_Room_Walls }
}

#declare RoomWindowFrame = difference {
  box { <-7.5,2.5,9.9>, <7.5,-5,10.1> }
  object { RoomWindowCutout scale 0.9999 }
  texture { T_WoodBeam }
}

#declare RoomFloor = box { <-10,-10,-10>, <10,-9.999,10>
  texture { T_FloorPlanks }
}

//============================================================= Octagonal mirror

#declare MirrorFrame = difference {
  intersection {
    box { <-1,-1,0>, <1,1,-0.2> }
    box { <-1,-1,0>, <1,1,-0.2> rotate z*45 }
  }
  intersection {
    box { <-1,-1,0.1>, <1,1,-0.5> }
    box { <-1,-1,0.1>, <1,1,-0.5> rotate z*45 }
    scale 0.9
  }
  texture { T_WoodBeam rotate x*89 }
}

#declare MirrorGlass = intersection {
  box { <-1,-1,0>, <1,1,-0.1> }
  box { <-1,-1,0>, <1,1,-0.11> rotate z*45 }
  scale 0.9
  texture { T_Mirror }
}

#declare Mirror = union {
  object { MirrorFrame }
  object { MirrorGlass }
}

//============================ Three portraits of people in Elizabethan clothing

#declare PortraitFrame = torus { 0.95, 0.1 rotate x*90
  scale <1,1.4,1>
  texture { T_WoodBeam rotate x*91 }
  #ifndef (Quick)
    finish { phong 0.9 phong_size 100 }
  #end
}

#declare Portrait1 = union {                          // Myself
  object { PortraitFrame }
  cylinder { <0,0,0>, <0,0,-0.1>, 0.9
    #ifdef (Quick)
      pigment { colour rgb <1,1,1> }
    #else
      pigment { image_map { gif "godfrey.gif" } scale 2 translate <-0.8,0.9,0> }
      scale <1,1.4,1>
    #end
  }
}

#declare Portrait2 = union {                          // Ange
  object { PortraitFrame }
  cylinder { <0,0,0>, <0,0,-0.1>, 0.9
    #ifdef (Quick)
      pigment { colour rgb <1,1,1> }
    #else
      pigment { image_map { gif "eibhlin.gif" } scale 2 translate <-0.925,0.9,0> }
      scale <1,1.5,1>*0.925
    #end
  }
}

#declare Portrait3 = union {                          // Michelle
  object { PortraitFrame }
  cylinder { <0,0,0>, <0,0,-0.1>, 0.9
    #ifdef (Quick)
      pigment { colour rgb <1,1,1> }
    #else
      pigment { image_map { gif "elysia.gif" } scale 2 translate <-0.975,0.95,0> }
      scale <1,1.5,1>*0.925
    #end
  }
}

//========================================================== A high-backed chair

#declare ChairLeg = box { <-0.125,0,-0.125>, <0.125,3,0.125> texture { T_WoodBeam rotate x*90 }}
#declare ChairStrut = box { <-0.125,-0.125,-1.25>, <0.125,0.125,1.25> texture { T_WoodBeam rotate y*90 }}

#declare Chair = union {
  box { <-1.25,3,1.0>, <1.25,6.5,1.25> texture { T_WoodBeam rotate x*90 }}
  box { <-1.25,2.875,-1.25>, <1.25,3.125,1.25> texture { T_WoodBeam rotate y*90 }}
  cylinder { <0,6.5,1.0>, <0,6.5,1.25>, 1.25 texture { T_WoodBeam rotate x*90 }}
  object { ChairLeg translate <-1.125,0,-1.125> }
  object { ChairLeg translate <-1.125,0, 1.125> }
  object { ChairLeg translate < 1.125,0,-1.125> }
  object { ChairLeg translate < 1.125,0, 1.125> }
  object { ChairStrut translate <-1.125,0.5,0> }
  object { ChairStrut translate <-1.125,0.5,0> rotate y* 90 }
  object { ChairStrut translate <-1.125,0.5,0> rotate y*180 }
  object { ChairStrut translate <-1.125,0.5,0> rotate y*270 }
  translate y*-10
}

//============================================================ Funky windowpanes

#declare bar=sqrt( 0.01 )  // 0.02
#declare wthick=0.05

#declare Window_Diamond = difference {
  box { <-bar,-bar,-wthick>, <bar,bar,wthick> }
  #declare baz=0
  #while (baz < 360)
    plane {  z, 0 rotate y* 45 translate x*-bar rotate y*baz }
    plane { -z, 0 rotate y*-45 translate x*-bar rotate y*baz }
    #declare baz = baz + 90
  #end
  rotate z*45
}

#declare Window_Rect = difference {
//  box { <-0.2,-0.3,-wthick>, <0.2,0.3,wthick> }
  box { <-0.1,-0.4,-wthick>, <0.1,0.4,wthick> }
  plane {  z, 0 rotate y* 45 translate x*-0.1 }  // 0.2 (and following)
  plane {  z, 0 rotate y*-45 translate x* 0.1 }
  plane { -z, 0 rotate y* 45 translate x* 0.1 }
  plane { -z, 0 rotate y*-45 translate x*-0.1 }
}

#declare Window_Polygon = merge {
  object { Window_Rect }
  object { Window_Diamond translate y* 0.4 }  // 0.3
  object { Window_Diamond translate y*-0.4 }  // 0.3
}

#declare Window_Square = difference {
//  box { <-0.3,-0.3,-wthick>, <0.3,0.3,wthick> }
  box { <-0.4,-0.4,-wthick>, <0.4,0.4,wthick> }
  #declare baz=0
  #while (baz < 360)
    plane {  z, 0 rotate y* 45 translate x*-0.4 rotate y*baz }  // 0.3
    plane { -z, 0 rotate y*-45 translate x*-0.4 rotate y*baz }
    #declare baz = baz + 90
  #end
}

#declare WindowPane = union {
  object { Window_Polygon rotate z*90 translate x*0.5 }
  object { Window_Polygon translate y*0.5 }
  object { Window_Square translate <0.5,0.5> }
}

#ifndef (Quick)
  #declare WindowGlass = union {
    #declare bar =  -5
    #while (bar <= 2)
      #declare foo = -7
      #while (foo <= 7)
        object { WindowPane translate <foo,bar,10.0001+wthick> }
        #declare foo = foo + 1
      #end
      #declare bar = bar + 1
    #end
    texture { T_WindowGlass }
  }
#end

//============================================================= Simple fireplace

#declare GothicCarving = difference {
  union {
    box { <-0.025,-0.5,-0.025>, <0.025,0.5,0.025> }
    box { <-0.025,-0.5,-0.025>, <0.025,0.5,0.025> translate x*-0.225 }
    box { <-0.025,-0.5,-0.025>, <0.025,0.5,0.025> translate x* 0.225 }
    box { <-0.25,-0.025,-0.025>, <0.25,0.025,0.025> translate y*-0.475 }
    box { <-0.25,-0.025,-0.025>, <0.25,0.025,0.025> translate y* 0.475 }
    box { <-0.25,-0.025,-0.025>, <0.25,0.025,0.025> translate y* 0.250 }
    cylinder { <0,0.250,-0.025>, <0,0.250,0.025>, 0.15 }
  }
  box { <-0.2,0.45,-0.026>, <0.2,0.275,0.026> }
  cylinder { <0,0.250,-0.026>, <0,0.250,0.026>, 0.10 }
}

#declare Fireplace = union {
  difference {
    box { <9,2,5>, <10,-10,-5> }
    box { <8.9,-4.5,3>, <10,-10,-3> }
    cylinder{ <8.9,-4.5,0>, <10,-4.5,0>, 3 }
    box { <8.9,-1.25,4>, <9.1,0.75,-4> }
  }
  #declare foo=-3.5
  #while (foo < 4.5)
    object { GothicCarving scale 2 rotate y*90 translate <9.05,-0.25,foo> }
    #declare foo = foo + 1
  #end
  box { <9.5,10,3>, <10,2,-3> }
  box { <8.9,1.6,5.1>, <10,1.4,-5.1> }
  prism { conic_sweep linear_spline 1, 0, 5, <-1,-5>, <1,-5>, <1,5>, <-1,5>, <-1,-5> rotate x*180 scale <1,4,1> translate <10,6,0> }
  union {
    box { <9.8,-4.5,3>, <10,-10,-3> }
    cylinder{ <9.8,-4.5,0>, <10,-4.5,0>, 3 }
    pigment { colour rgb <0,0,0> }
  }
  pigment { colour rgb <1,1,0.8> }
  finish { phong 0.3 phong_size 100 }
  #ifndef (Quick)
    normal { crackle 5 scale 0.5}
  #end
  translate z*-8
}

//===================================================== Wall sconce with candles

#declare WallCandleLight = light_source { <0,14,0>
  colour rgb <1,0.9,0.7>
  fade_distance 20
  fade_power 1
}

#declare SconceVertArm = union {
  difference {
    cylinder { <-0.5,0,0>, <0.5,0,0>, 0.50 }
    cylinder { <-1,0,0>, <1,0,0>, 0.49 }
    box { <-1,0,0>, <1,-1,1> }
    box { <-1,0,1>, <1,-1,0> rotate x*45 }
  }
  box { <-0.5,0,0.49>, <0.5,-2,0.50> }
  translate y*2
}

#declare SconceHorzArm = union {
  difference {
    cylinder { <0,-0.5,0>, <0,0.5,0>, 0.50 }
    cylinder { <0,-1,0>, <0,1,0>, 0.49 }
    box { <-1,-1,-1>, <0,1,1> }
    box { <0,-1,1>, <-1,1,-1> rotate y*-135}
  }
  box { <-1,-0.5,0.49>, <0,0.5,0.5> }
  box { <0.49,-0.5,0>, <0.5,0.5,-4.15> rotate y*-45 }
  translate x*1
}

#declare SconceHolder = union {
  difference {
    sphere { <0,0,0>, 1.00 }
    sphere { <0,0,0>, 0.95 }
    plane { -y, 0 }
    scale <1,0.2,1>
  }
  cone { <0,0,0>, 0.2, <0,-3,0>, 0.1 }
  sphere { <0,-3,0>, 0.2 }
  translate y*1
}

#declare SconceBody = union {
  object { SconceVertArm }
  object { SconceVertArm rotate z*180 }
  object { SconceHorzArm }
  object { SconceHorzArm rotate z*180 }
  object { SconceHolder translate < 0.5,0.5,-4.15> rotate y*-45 translate x* 1 }
  object { SconceHolder translate <-0.5,0.5,-4.15> rotate y* 45 translate x*-1 }
  texture { T_Beaten_Iron }
}

#declare Sconce = union {
  object { SconceBody }
  object { Candle scale 0.4 rotate y*360*rand(RotSeed) translate < 0.5,1.5,-4.15> rotate y*-45 translate x* 1 }
  object { Candle scale 0.4 rotate y*360*rand(RotSeed) translate <-0.5,1.5,-4.15> rotate y* 45 translate x*-1 }
  #ifndef (Quick)
    object { WallCandleLight scale 0.4 translate < 0.5,1.5,-4.15> rotate y*-45 translate x* 1 }
    object { WallCandleLight scale 0.4 translate <-0.5,1.5,-4.15> rotate y* 45 translate x*-1 }
  #end
  translate z*-0.5
}

//==================================================== A lectern or reading desk

#declare Lectern = union {
  difference {
    intersection {
      box { <-1.25,3,-1.25>, < 1.25,-6, 1.25> }
      plane { y, 0 rotate x*-15 translate z*-1.25 }
    }
    box { <-1.125,-1.5,-1.26>, < 1.125,-6.1, 1.125> }
    box { <-1.125,-0.8125,-1.26>, < 1.125,-1.375, 1.125> }
    box { <-1.125,-0.125,-1.26>, < 1.125,-0.6875, 1.125> }
  }
  cylinder { <-1.25,0,0>, <1.25,0,0>, 0.0625 translate z*-1.1875 }
  translate y*-4
  texture { T_BlondWood scale 0.05 rotate z*90 translate z*50 }
}

#declare LecternWithBook = union {
  object { Lectern }
  object { OpenBook scale <0.2,0.25,0.425> translate z*0.125 rotate x*-15 translate y*-3.65 }
}


//========================================================== Put it all together

#declare Room = union {
  object { RoomSolid }
  object { RoomFloor }
  object { Room_WallBeam translate <-10, 4,0> }
  object { Room_WallBeam translate < 10, 4,0> }
  object { Room_WallBeam translate <-10,-4,0> }
  object { Room_WallBeam translate < 10,-4,0> }
  object { Room_WallBeam translate <-10,-9.5,0> }
  object { Room_WallBeam translate < 10,-9.5,0> }
  object { Room_WallBeam rotate y*90 translate <  0,-9.5,10> }
  object { Room_WallBeam rotate x*90 translate <-10,0,10> }
  object { Room_WallBeam rotate x*90 translate < 10,0,10> }
  object { Room_DiagonalBeam translate <-10,0,0> }
  object { Room_DiagonalBeam translate < 10,0,0> }
  object { Room_WindowDivider translate x*-(7/5) no_shadow }
  object { Room_WindowDivider translate x* (7/5) no_shadow }
  object { Room_WindowDivider translate x*-(7/5)*3 no_shadow }
  object { Room_WindowDivider translate x* (7/5)*3 no_shadow }
  #declare foo = -10
  #while (foo < 10)
    object { Room_CeilingBeam translate x*foo }
    #if (foo > -10)
      #if (foo < 9)
        object { Room_WindowBeam  translate x*foo }
      #end
    #end
    #declare foo = foo+3.96
  #end
  #declare foo = 6
  #while (foo > -20)
    object { Room_WallBeam rotate x*90 translate <-10,-16,foo> }
    object { Room_WallBeam rotate x*90 translate < 10,-16,foo> }
    #declare foo = foo-4
  #end
  object { RoomWindowFrame }
  object { Fireplace }
  object { Sconce scale 0.2 rotate y* 90 translate < 10,1,4> }
  object { Sconce scale 0.2 rotate y*-90 translate <-10,1,4> }
  object { Chair rotate y*-90 translate <-8.5,0,4> } 
  object { Chair translate <8.5,0,8.5> } 
  object { Mirror scale <0.9,2.8,0.9> rotate y*-90 translate <-10,0,0> }
  object { Portrait1 scale 0.8 translate <0,3.75,10> }
  object { Portrait2 scale 0.8 translate < 8.625,0,10> }
  object { Portrait3 scale 0.8 translate <-8.625,0,10> }
  object { LecternWithBook rotate y*90 translate <8.5,0,0> }
  object { Facade scale 500 translate <150,-200,1250> }
  #ifdef (Final)
    object { WindowGlass }
  #end
}

#ifdef (ShowProgress)
  #debug "<<< exiting room.inc\n"
#end