#ifdef (ShowProgress)
  #debug ">>> parsing scribble.inc\n"
#end

#declare T_BrownPaper = texture {
  pigment {
    bozo
    colour_map {
      [0.0 colour rgb <0.9, 0.65, 0.02>]
      [0.5 colour rgb <0.8, 0.55, 0.01>]
      [1.0 colour rgb <0.9, 0.65, 0.02>]
    }
  }
  #ifndef (Quick)
    normal { wrinkles scale 0.1 }
  #end
}

#ifndef (Quick)
#declare T_Scribbles = texture {
  pigment {
    image_map {
      gif "scribble.gif"
      transmit 246, 1.0
      map_type 0
      once
    }
    translate <-0.5,-0.5,0>
    rotate z*-45
  }
}
#end



#declare T_Clear = texture {
  pigment { colour rgbt <1,1,1,1> }
}

#declare T_RaggedBrownPaper = texture {
  gradient x+y
  texture_map {
    [0.00 T_BrownPaper]
    [0.74 T_BrownPaper]
    [0.75 T_Clear]
    [1.00 T_Clear ]
  }
  rotate z*45
  turbulence <0.1,0.1,0.0>
  omega 0.75
}


#ifdef (Quick)
  #declare bcp_Paper2 = mesh {
    triangle { <0,0,0>, <0,1,0>, <1,0,0> }
    triangle { <1,1,0>, <0,1,0>, <1,0,0> }
    translate <-0.5,-0.5,0>
  }
#else
  #declare bcp_Paper2 = bicubic_patch {
    type 1
    flatness 0
    u_steps 4
    v_steps 4
    <0,0,0>, <1,0,0>, <2,0,0>, <3,0,0>
    <0,1,0>, <1,1,0>, <2,1,0>, <3,1,0>
    <0,2,0>, <0.25,0.25,0>, <2,2,-0.1>, <3,2,0>
    <0,3,-0.25>, <1,3,0>, <2,3,0>, <3,3,0>
    scale 1/3
    translate <-0.5,-0.5,0>
  }
#end


#declare ScratchPaperBase = object { bcp_Paper2 rotate z*180
  texture { T_RaggedBrownPaper rotate z*180 scale 0.9 }//translate <-0.5,-0.5,0> }
}

#ifndef (Quick)
  #declare ScratchPaperWriting = object { bcp_Paper2 rotate z*180
    texture { T_Scribbles scale 0.5 translate <-0.25,-0.15,0> }
    translate z*-0.0001
  }
#end

#declare ScratchPaper = union {
  object { ScratchPaperBase }
  #ifndef (Quick)
    object { ScratchPaperWriting }
  #end
}

#ifdef (ShowProgress)
  #debug "<<< exiting scribble.inc\n"
#end