#ifdef (ShowProgress)
  #debug ">>> parsing sealwax.inc\n"
#end

#declare SealingWax = intersection {
  superellipsoid { <0.1,0.1>
    translate x*1
    scale 0.5 * <10,0.5,1>
  }
  union {
    box { <0,0,-0.5>, <5.8,0.5,0.5> }
    intersection {
      box { <4.6,0,-0.51>, <8.7, 0.5, 0.51> }
      blob {
        threshold 0.5
        sphere { <5.8,  0.00,  0.00>, 1.0, 2 }
        sphere { <6.7, -0.10, -0.20>, 0.8, 2 }
        sphere { <7.3, -0.10,  0.10>, 0.7, 2 }
        sphere { <8.0, -0.15, -0.15>, 0.5, 2 }
        sphere { <8.4, -0.10, -0.05>, 0.3, 2 }
      }
    }
    translate y*-0.25
  }
  translate y*0.25
  scale <1,1.5,1>
  pigment { colour rgb <0,0,0.25> }
  #ifndef (Quick)
    finish { phong 1.0 phong_size 150 reflection 0.2 }
    normal { bumps scale 0.3 }
  #end
}

#ifdef (ShowProgress)
  #debug "<<< exiting sealwax.inc\n"
#end