#ifdef (ShowProgress)
  #debug ">>> parsing stick.inc\n"
#end

// Candle goes at +15.6y
//

#ifndef(T_Gold_3C)
  #include "golds.inc"
#end

#declare CandleStickBase = mesh {
  triangle { <0,0,0>, <-0.5,0, 0.866025>, < 0.5,0, 0.866025> }
  triangle { <0,0,0>, < 0.5,0, 0.866025>, < 1.0,0, 0.000000> }
  triangle { <0,0,0>, < 1.0,0, 0.000000>, < 0.5,0,-0.866025> }
  triangle { <0,0,0>, < 0.5,0,-0.866025>, <-0.5,0,-0.866025> }
  triangle { <0,0,0>, <-0.5,0,-0.866025>, <-1.0,0, 0.000000> }
  triangle { <0,0,0>, <-1.0,0, 0.000000>, <-0.5,0, 0.866025> }

  triangle { <-0.50, 0.0, 0.866025>, < 0.50,0.0, 0.866025>, <-0.55,-0.2, 0.952628> }
  triangle { < 0.55,-0.2, 0.952628>, < 0.50,0.0, 0.866025>, <-0.55,-0.2, 0.952628> }
  triangle { < 0.50, 0.0, 0.866025>, < 1.00,0.0, 0.000000>, < 0.55,-0.2, 0.952628> }
  triangle { < 1.10,-0.2, 0.000000>, < 1.00,0.0, 0.000000>, < 0.55,-0.2, 0.952628> }
  triangle { < 1.00, 0.0, 0.000000>, < 0.50,0.0,-0.866025>, < 1.10,-0.2, 0.000000> }
  triangle { < 0.55,-0.2,-0.952628>, < 0.50,0.0,-0.866025>, < 1.10,-0.2, 0.000000> }
  triangle { < 0.50, 0.0,-0.866025>, <-0.50,0.0,-0.866025>, < 0.55,-0.2,-0.952628> } 
  triangle { <-0.55,-0.2,-0.952628>, <-0.50,0.0,-0.866025>, < 0.55,-0.2,-0.952628> } 
  triangle { <-0.50, 0.0,-0.866025>, <-1.00,0.0, 0.000000>, <-0.55,-0.2,-0.952628> }
  triangle { <-1.10,-0.2, 0.000000>, <-1.00,0.0, 0.000000>, <-0.55,-0.2,-0.952628> }
  triangle { <-1.00, 0.0, 0.000000>, <-0.50,0.0, 0.866025>, <-1.10,-0.2, 0.000000> }
  triangle { <-0.55,-0.2, 0.952628>, <-0.50,0.0, 0.866025>, <-1.10,-0.2, 0.000000> }
}

#declare CandleStickFacets = mesh {
  triangle{ <0,0,0>, <-1,10,-1.732051>, < 0.00,11,-1.9052561> }
  triangle{ <0,0,0>, < 1,10,-1.732051>, < 0.00,11,-1.9052561> }
  triangle{ <0,0,0>, <-1,10,-1.732051>, <-1.65,11,-0.9526280> }
  triangle{ <0,0,0>, <-2,10, 0.000000>, <-1.65,11,-0.9526280> }
  triangle{ <0,0,0>, < 1,10,-1.732051>, < 1.65,11,-0.9526280> }
  triangle{ <0,0,0>, < 2,10, 0.000000>, < 1.65,11,-0.9526280> }
  triangle{ <0,0,0>, <-1,10, 1.732051>, < 0.00,11, 1.9052561> }
  triangle{ <0,0,0>, < 1,10, 1.732051>, < 0.00,11, 1.9052561> }
  triangle{ <0,0,0>, <-1,10, 1.732051>, <-1.65,11, 0.9526280> }
  triangle{ <0,0,0>, <-2,10, 0.000000>, <-1.65,11, 0.9526280> }
  triangle{ <0,0,0>, < 1,10, 1.732051>, < 1.65,11, 0.9526280> }
  triangle{ <0,0,0>, < 2,10, 0.000000>, < 1.65,11, 0.9526280> }

  triangle{ <0,13,0>, <-1,10.57183628,-1.732051>, < 0.00,11,-1.9052561> }
  triangle{ <0,13,0>, < 1,10.57183628,-1.732051>, < 0.00,11,-1.9052561> }
  triangle{ <0,13,0>, <-1,10.57183628,-1.732051>, <-1.65,11,-0.9526280> }
  triangle{ <0,13,0>, <-2,10.57183628, 0.000000>, <-1.65,11,-0.9526280> }
  triangle{ <0,13,0>, < 1,10.57183628,-1.732051>, < 1.65,11,-0.9526280> }
  triangle{ <0,13,0>, < 2,10.57183628, 0.000000>, < 1.65,11,-0.9526280> }
  triangle{ <0,13,0>, <-1,10.57183628, 1.732051>, < 0.00,11, 1.9052561> }
  triangle{ <0,13,0>, < 1,10.57183628, 1.732051>, < 0.00,11, 1.9052561> }
  triangle{ <0,13,0>, <-1,10.57183628, 1.732051>, <-1.65,11, 0.9526280> }
  triangle{ <0,13,0>, <-2,10.57183628, 0.000000>, <-1.65,11, 0.9526280> }
  triangle{ <0,13,0>, < 1,10.57183628, 1.732051>, < 1.65,11, 0.9526280> }
  triangle{ <0,13,0>, < 2,10.57183628, 0.000000>, < 1.65,11, 0.9526280> }

  triangle{ <-1,10,-1.732051>, < 0.00,11,-1.9052561>, <-1,10.57183628,-1.732051> }
  triangle{ < 1,10,-1.732051>, < 0.00,11,-1.9052561>, < 1,10.57183628,-1.732051> }
  triangle{ <-1,10,-1.732051>, <-1.65,11,-0.9526280>, <-1,10.57183628,-1.732051> }
  triangle{ <-2,10, 0.000000>, <-1.65,11,-0.9526280>, <-2,10.57183628, 0.000000> }
  triangle{ < 1,10,-1.732051>, < 1.65,11,-0.9526280>, < 1,10.57183628,-1.732051> }
  triangle{ < 2,10, 0.000000>, < 1.65,11,-0.9526280>, < 2,10.57183628, 0.000000> }
  triangle{ <-1,10, 1.732051>, < 0.00,11, 1.9052561>, <-1,10.57183628, 1.732051> }
  triangle{ < 1,10, 1.732051>, < 0.00,11, 1.9052561>, < 1,10.57183628, 1.732051> }
  triangle{ <-1,10, 1.732051>, <-1.65,11, 0.9526280>, <-1,10.57183628, 1.732051> }
  triangle{ <-2,10, 0.000000>, <-1.65,11, 0.9526280>, <-2,10.57183628, 0.000000> }
  triangle{ < 1,10, 1.732051>, < 1.65,11, 0.9526280>, < 1,10.57183628, 1.732051> }
  triangle{ < 2,10, 0.000000>, < 1.65,11, 0.9526280>, < 2,10.57183628, 0.000000> }

  translate y*-5
}

#declare CandleStickBaseLathe = lathe {
  quadratic_spline
  50,
  <0.00,0.00>, <0.00, 0.00>, <0.60, 0.00>, <0.60, 0.00>, <0.59, 0.11>,
  <0.58, 0.12>, <0.56,0.135>, <0.54, 0.14>, <0.54, 0.14>, <0.52, 0.14>,
  <0.52, 0.14>, <0.52, 0.15>, <0.52, 0.15>, <0.50, 0.16>, <0.49, 0.17>,
  <0.48, 0.18>, <0.47, 0.20>, <0.47, 0.20>, <0.45, 0.20>, <0.45, 0.20>,
  <0.45, 0.21>, <0.45, 0.21>, <0.43, 0.22>, <0.42, 0.23>, <0.41, 0.24>,
  <0.40, 0.26>, <0.40, 0.26>, <0.37, 0.26>, <0.37, 0.26>, <0.37, 0.27>,
  <0.37, 0.27>, <0.34, 0.28>, <0.31, 0.30>, <0.28, 0.34>, <0.25, 0.40>,
  <0.23, 0.48>, <0.23, 0.48>, <0.21, 0.48>, <0.21, 0.48>, <0.23, 0.50>,
  <0.24, 0.53>, <0.24, 0.56>, <0.23, 0.59>, <0.21, 0.61>, <0.19, 0.64>,
  <0.19, 0.65>, <0.19, 0.80>, <0.19, 0.80>, <0.00, 0.80>, <0.00, 0.80>
  sturm
}

#declare CandleStickTopLathe = lathe {
  quadratic_spline
  54,
  <0.00, 0.00>, <0.00, 0.00>, <0.07, 0.00>, <0.13, 0.00>, <0.18, 0.00>,
  <0.19, 0.00>, <0.21, 0.01>, <0.22, 0.02>, <0.23, 0.04>, <0.24, 0.07>,
  <0.24, 0.10>, <0.23, 0.13>, <0.22, 0.15>, <0.21, 0.16>, <0.19, 0.17>,
  <0.17, 0.21>, <0.16, 0.22>, <0.15, 0.24>, <0.14, 0.27>, <0.14, 0.32>,
  <0.14, 0.36>, <0.15, 0.39>, <0.16, 0.41>, <0.17, 0.42>, <0.19, 0.42>,
  <0.21, 0.43>, <0.22, 0.44>, <0.23, 0.46>, <0.24, 0.50>, <0.25, 0.56>,
  <0.26, 0.60>, <0.28, 0.62>, <0.31, 0.64>, <0.36, 0.65>, <0.41, 0.66>,
  <0.42, 0.66>, <0.42, 0.66>, <0.42, 0.66>, <0.41, 0.68>, <0.41, 0.68>,
  <0.41, 0.68>, <0.39, 0.68>, <0.34, 0.67>, <0.30, 0.66>, <0.28, 0.65>,
  <0.25, 0.63>, <0.23, 0.60>, <0.21, 0.58>, <0.17, 0.57>, <0.09, 0.56>,
  <0.05, 0.56>, <0.02, 0.56>, <0.00, 0.56>, <0.00, 0.56>
  sturm
}

#declare CandleStickCollar = difference {
  cylinder { <0,-1,0>, <0,1,0>, 2 }
  torus { 3, 2 }
}

#declare CandleStick = union {
  object { CandleStickFacets    scale <1,1.5,1> }
  object { CandleStickBaseLathe scale 5 translate y*-3.5 }
  object { CandleStickBase      scale 4 translate y*-3.49 }
  object { CandleStickTopLathe  scale 7 translate y*11.60 }
  object { CandleStickCollar    scale 1 translate y*10.65 }
#ifdef (Quick)
  pigment { colour rgb <1,1,0> }
#else
  texture { T_Gold_3C }
#end
}

#ifdef (ShowProgress)
  #debug "<<< exiting stick.inc\n"
#end