//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 2 lights, 23 textures and 59 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  MORAY.EXE V2.5a.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 03/26/1997    (26.03.1997)
//

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray V2.0 exports for POV-Ray.
//





/*global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

//background { color <0.950,0.950,0.950> }

camera {  //  Camera StdCam
  location  <0.000, -22.798, 0.000>
  direction <0.0,     0.0,  1.9067>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  //look_at   <0.000, 0.000, 0.000>
  look_at   <0.740, -0.026, -0.786>

}

// *******  L I G H T S *******
light_source {   // Spotlight SpotL002
  <0.192, 0.048, 0.960>
  color  rgb <0.505, 0.505, 0.505>
  spotlight
    point_at  <0.192, 0.048, -0.893>
    falloff   50.5  // outer radius (in deg)
      radius    40.3  // inner radius
}

light_source {   // Spotlight SpotL001
  <7.415, 1.755, -0.614>
  color  rgb <-1.000, -1.000, -1.000>
  spotlight
    point_at  <7.415, 1.755, -1.614>
    falloff   43.4  // outer radius (in deg)
      radius    39.4  // inner radius
  atmosphere off
}

light_source {   // Spotlight POVSphereSpotLt
  <-5.013, 6.548, 1.939>
  color  rgb <0.435, 0.435, 0.435>
  spotlight
    point_at  <-4.641, 5.867, 0.350>
    falloff   37.9  // outer radius (in deg)
      radius    37.0  // inner radius
  fade_distance  20.0
  fade_power 20.0
  atmosphere off
}

light_source {   // Light001
  <3.574, 2.634, 21.509>
  color rgb <0.702, 0.702, 0.702>
  shadowless
  atmosphere off
}

light_source {   // Light2
  <-3.901, 4.488, -1.795>
  color rgb <0.907, 0.907, 0.907>
  shadowless
  fade_distance  0.1
  fade_power 0.1
  atmosphere off
}*/


// ********  TEXTURES  *******
//

//#include "learn2.inc"
#include "colors.inc"


// ********  REFERENCED OBJECTS  *******
#declare sky_vect = <0,0,1>// default sky vector = <0,0,1> using moray
#declare lookat = <0,0,0> //<1.150, 11.950, 7.600>
//#declare time = clock
#declare cam_loc = <0.000, -22.798, 0.000> //camera_start + (camera_end - camera_start)*time



// ********  OBJECTS  *******

/*cylinder { // EyeLocatorCyl
  <0,0,1>, <0,0,0>, 1
  texture {
 POVRed // POVred EyeLocatTexture
  }
  scale <1.0, 1.0, 400.0>
  translate  <12.0, 185.0, -127.103116>
}*/


sphere { // EyeLocatorSphere
  <0,0,0>,1
  texture {
    EyeLocatTexture
  }
  scale 0.2
  translate  <12.0, 185.0, 31.0>
}

#declare planet_loc = <750.0, 5000.0, 600.0>//<500.0, 5000.0, 1000.0>// <12.0, 185.0, 31.0>//<-2700, 185,-7000>//
#declare planet_rad = 3//1
sphere { // Planet
  <0,0,0>, 1
  texture {EyeLocatTexture }
  scale planet_rad
  translate planet_loc
}

#declare light_loc = <750.0, 5000.0, 600.0>//<500.0, 5000.0, 1000.0>// <12.0, 185.0, 31.0>//<-2700, 185, -7000>//<0,0,0>//<0.011785, 0.0, 1.249212><9, 185, 31>//
#declare light_rad = 500//55//10 //1000/
#declare flare_type = "warpflare" //"Sparkle1"//"Sunset2"//"windshield" //"Sunset2"//"35mm"//"Sparkle1""warpflare"
#declare show_flare_source = no
//#declare flare_shrink = true
#declare source_color = <1,1,1>
#declare flare_scale_factor = 1 //1.2 //2 //1.5// 5.0//1000
#include "lnsflare.inc"






#declare CSG2 = union {
  sphere { // EyeWhite
    <0,0,0>,1
    texture {
      EyeBallTexture
    }
  }
  sphere { // EyeIris
    <0,0,0>,1
    texture {
      EyeIrisTexture
    }
    scale 0.698208
    translate  <0.012164, -0.352761, 0.0>
  }
  sphere { // EyePupil
    <0,0,0>,1
    texture {
     EyePupilTexture
    }
    scale 0.253791
    translate  -0.823908*y
  }
  torus { // Torus2
    1.85, 0.15  rotate -x*90
    scale <0.534522, 0.527822, 0.527852>
    rotate 28.0*x
    translate  <0.0, -0.140351, 0.084211>
  }
  torus { // Torus3
    1.85, 0.15  rotate -x*90
    scale <0.534522, 0.527822, 0.925516>
    rotate -24.0*x
    translate  <0.0, -0.02807, -0.042105>
  }
}
#declare Eye = difference {
  object { CSG2 }
  cylinder { // Cylndr3
    <0,0,1>, <0,0,0>, 1
    scale <1.452298, 1.029911, 3.0>
    rotate 0.833004*z
    translate  <0.046331, 0.369144, -1.353264>
  }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <0.936317, 1.320134, 0.432299>
    rotate -24.0*x
    translate  <0.0, 0.208942, 0.442787>
  }
  box { // Cube2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.174914, 1.435638, 0.332343>
    rotate 28.0*x
    translate  <0.0, 0.229694, -0.18808>
  }
  texture {
    EyeLidTexture
  }
}
union { // MindsEye
  object { Eye }
  no_shadow
  hollow
  scale 6 //4.5//4.0
  rotate <0, 0, -10>
  translate <30.56622, 185.0, 24.50>//<30.56622, 185.0, 25.0> //<20.50, 185.0, 40.0>
}

 // declare rainbow's colours

 /* #declare r_violet1 = colour rgbf<1.0, 0.5, 1.0, 0.10>
  #declare r_violet2 = colour rgbf<1.0, 0.5, 1.0, 0.1>
  #declare r_indigo  = colour rgbf<0.5, 0.5, 1.0, 0.1>
  #declare r_blue    = colour rgbf<0.2, 0.2, 1.0, 0.1>
  #declare r_cyan    = colour rgbf<0.2, 1.0, 1.0, 0.1>
  #declare r_green   = colour rgbf<0.2, 1.0, 0.2, 0.1>
  #declare r_yellow  = colour rgbf<1.0, 1.0, 0.2, 0.8>
  #declare r_orange  = colour rgbf<1.0, 0.5, 0.2, 0.8>
  #declare r_red1    = colour rgbf<1.0, 0.2, 0.2, 0.8>
  #declare r_red2    = colour rgbf<1.0, 0.2, 0.2, 1.0>*/

 
  // create the rainbow

  rainbow {
    angle 3//42.5
    width .5
    distance 190 //1.0e7
    direction <.0145,.10,0.012>
    jitter 0.01

    colour_map {
    /* [0.000  colour r_violet1 transmit 0.98]
     [0.100  colour r_violet2 transmit 0.96]
     //[0.214  colour r_indigo  transmit 0.94]
    // [0.328  colour r_blue    transmit 0.92]
     //[0.442  colour r_cyan    transmit 0.90]
      [0.556  colour r_green   transmit 0.92]
      [0.670  colour r_yellow  transmit 0.94]
      [0.784  colour r_orange  transmit 0.96]
      [0.900  colour r_red1    transmit 0.98]*/


       [ 0.000  color rgbf<1.000, 1.000, 0.657, 0.986> transmit 0.92 ]
       [ 0.096  color rgbf<1.000, 0.875, 0.575, 0.944> transmit 0.94]
       [ 0.192  color rgbf<1.000, 0.750, 0.493, 0.972> transmit 0.94]
       [ 0.289  color rgbf<1.000, 0.625, 0.411, 0.847> transmit 0.94 ]
       [ 0.385  color rgbf<1.000, 0.500, 0.329, 0.808> transmit 0.94 ]
       [ 0.576  color rgbf<1.000, 0.375, 0.246, 0.958> transmit 0.94]
       [ 0.766  color rgbf<1.000, 0.250, 0.164, 0.930> transmit 0.95 ]
       [ 0.875  color rgbf<1.000, 0.125, 0.082, 0.902> transmit 0.94]
       [ 1.000  color rgbf<1.000, 0.000, 0.000, 0.916> transmit 0.98 ]
    

   }

  }
