// Persistence of Vision Ray Tracer Scene Description File
// File: lunch.pov
// Vers: 3.01 Watcom Win32
// Desc: Nasty-looking School Lunch
// Date: April 29, 1997
// Auth: Sonya Roberts
// Note:

// ==== Standard Includes ====
#include "colors.inc"
#include "textures.inc"
#include "metals.inc"
#include "shapes.inc"
#include "stones.inc"
#include "stones2.inc"
#include "woodmaps.inc"
#include "woods.inc"
#include "glass.inc"

// ==== Some Important Declares and Includes ====
#include "lunch.inc"
#declare True=1
#declare False=0
#declare SD=seed(3)

// ==== Set up the basic scene ====
camera {
	location	<0,.75,-1.35>
	up		<0,1,0>
	right		<1.33,0,0>
	look_at		<0,.2,0>
}


light_source {
	<20,20,-20>,
	color White
	area_light
	<5,0,0>,<0,5,0>,5,5
	adaptive 2
	jitter
}

light_source {
	<-20,10,-2>,
	color Gray30
}

object {
	plane {<0,1,0>,0}
	texture {T_Wood7	rotate <rand(SD)*90,rand(SD)*90,rand(SD)*90>	translate <rand(SD)*5,rand(SD)*5,rand(SD)*5>}
}

object {
	plane {<0,0,1>,2}
	pigment {
		brick
		pigment {color White}
		pigment {color Gray75}
		mortar .025
		brick_size <.75,.25,.75>
	}
	normal {
		brick -.1
		mortar .025
		brick_size <.75,.25,.75>
	}
}

// ==== Turn Scene Elements on and off ====
#declare Tray=True
#declare Plate=True
#declare MilkGlass=True
#declare PuddingBowl=True
#declare Sandwich=True
#declare Menu=True
#declare Brocolli=True

// ==== Create the scene ====
#if (Tray=True)
	object {
		intersection {
			difference {
				superellipsoid {<.25,.25>	translate <0,1,0>	scale <1,1,.75>}
				superellipsoid {<.25,.25>	translate <0,1,0>	scale <1,1,.75>	scale <.95,.91,.95>}
			}
			box {<-1.1,0,-1>,<1.1,.125,1>}
		}
		pigment {color Cyan}
		translate <0,.025,0>
	}
#end

#if (Plate=True)
	object {
		lathe {
			cubic_spline
			9,
			<-.1,0>
			<0,0>
			<.5,0>
			<.5,.015>
			<.75,.1>
			<.725,.1>
			<.5,.025>
			<0,.025>
			<-.1,.025>
		}
		scale <.75,.75,.75>
		pigment {
			image_map {
				gif "plate.gif"
			}
			rotate x*90
			translate <-.5,0,-.5>
			scale <1.1,1.1,1.1>
		}
		finish {
			ambient .15
			reflection .2
			phong .3
			phong_size 70
		}
		scale <.75,.75,.75>
		translate <.05,.02,-.15>
	}
#end

#if (MilkGlass=True)
	object {
		union {
			intersection {
				difference {
					superellipsoid {<.95,.3>	rotate x*90	translate <0,1,0>	scale <.115,.25,.115>}
					superellipsoid {<.95,.3>	rotate x*90	translate <0,1.075,0>	scale <.095,.25,.095>}
				}
				box {<-.3,0,-.3>,<.3,.4,.3>}
				texture {T_Glass4}
			}
			intersection {
				superellipsoid {<.95,.3>	rotate x*90	translate <0,1.075,0>	scale <.0949,.249,.0949>}
				box {<-.3,0,-.3>,<.3,.3,.3>}
				texture {CurdledMilk	scale <.1,.1,.1>}
			}
			height_field {
				gif "spillmilk.gif"
				smooth
				translate <-.35,0,-.85>
				scale <.25,.025,.5>
				rotate y*-13
				texture {CurdledMilk	scale <.1,.1,.1>}
			}
		}
		translate <.6,.02,.35>
	}
#end

#if (PuddingBowl=True)
	object {
		union {
			union {
				difference {
					cone {<0,0,0>,.15,<0,.1,0>,.2}
					cone {<0,.05,0>,.125,<0,.15,0>,.2}
				}
				torus {.2,.025	translate <0,.1,0>}
				pigment {color White}
				finish {
					ambient .15
					reflection .2
					phong .3
					phong_size 70
				}
			}
			intersection {
				union {
					cone {<0,.05,0>,.125,<0,.15,0>,.2}
					cylinder {<0,.149,0>,<0,.25,0>,.2}
				}
				union {
					#declare Cnt=1
					#while (Cnt<=300)
						sphere {<(rand(SD)*.35)-.175,rand(SD)*.125,(rand(SD)*.35)-.175>,.01+(rand(SD)*.025)}
						#declare Cnt=Cnt+1
					#end
				}
				texture {SlimyPudding	scale <.1,.1,.1>}
			}
		}
		translate <-.5,.02,.3>
	}
#end

#if (Sandwich=True)
	#declare Olive=
	object {
		union {
			union {
				difference {
					sphere {<0,0,0>,.03	scale <1,1,1.5>}
					cylinder {<0,0,-.05>,<0,0,.02>,.015}
					pigment {color Khaki}
					finish {
						phong .2
						phong_size 120
					}
				}
				torus {
					.01,.01
					scale <.75,1.25,1.25>
					translate <0,0,-.03>
					pigment {color Red}
					finish {
						phong .2
						phong_size 120
					}
				}
				translate <0,.025,0>
			}
			union {
				cylinder {<0,-.1,0>,<0,.05,0>,.01}
				cone {<0,.05,0>,.01,<0,.1,0>,.0025}
				scale <.5,1,.5>
				texture {T_Wood3 scale <.1,.1,.1>}
			}
		}
	}

	#declare BunShape=
	object {
		blob {
			threshold .75
			cylinder {<-.25,.1,0>,<.25,.1,0>,.12,1}
			sphere {<0,.1,0>,1,.5		scale <.25,.1,.12>}
			sphere {<-.25,.1,0>,.16,1	scale <1,1,1.2>}
			sphere {<-.125,.11,0>,.167,1	scale <1,1.1,1.3>}
			sphere {<0,.12,0>,.175,1	scale <1,1.2,1.4>}
			sphere {<.125,.11,0>,.167,1	scale <1,1.1,1.3>}
			sphere {<.25,.1,0>,.16,1	scale <1,1,1.2>}
		}
		scale <.75,.85,1.25>
	}

	#declare Bun=
	object {
		difference {
			union {
				difference {
					object {BunShape	scale <1.02,1.02,1.02>}
					object {BunShape}
					texture {Crust	scale <.1,.1,.1>}
				}
				object {BunShape	texture {Bread	scale <.1,.1,.1>}}
			}
			box {
				<-.5,.075,-.5>,<.5,.09,.5>
				pigment {color Clear}
			}
		}
	}

	#declare LunchMeat=
	object {
		cylinder {<0,0,0>,<0,.005,0>.15	scale <1,1,.75>}
		texture {Meat	scale <.1,.1,.1>	rotate <rand(SD)*90,rand(SD)*90,rand(SD)*90>}
	}

	#declare HamSlice=
	object {
		cylinder {<0,0,0>,<0,.005,0>.15	scale <1.75,1,1.25>}
		texture {Ham	scale <.1,.1,.1>	rotate <rand(SD)*90,rand(SD)*90,rand(SD)*90>}
	}

	#declare Tomatoe=
	object {
		cylinder {<0,0,0>,<0,.01,0>,.1}
		pigment {
			image_map {
				gif "tomatoe.gif"
			}
			rotate x*90
			translate <-.5,0,-.5>
			scale <.2,.2,.2>
		}
		normal {
			bump_map {
				gif "tomatoe2.gif"
			}
			rotate x*90
			translate <-.5,0,-.5>
			scale <.2,.2,.2>
		}
		finish {
			ambient .2
			phong .3
			phong_size 80
		}
		scale <1,1,1.25>
	}

	#declare MustardDrip=
	object {
		height_field {
			gif "mustard.gif"
			smooth
			translate <-.5,0,-.5>
			scale <.25,.025,.25>
			texture {Mustard	scale <.1,.1,.1>}
		}
	}

	object {
		union {
			object {Bun}
			object {Olive	rotate z*10	rotate y*5	translate <-.1,.175,-.05>}
			object {Olive	rotate z*-10	rotate y*-5	translate <.1,.175,-.05>}
			object {LunchMeat	rotate y*-20	translate <-.2,.075,0>}
			object {LunchMeat	rotate y*160	translate <.15,.075,0>}
			object {HamSlice	rotate y*5	translate <-.05,.08,.025>}
			object {Tomatoe		rotate x*-3	translate <0,.08,-.115>}
			object {MustardDrip	translate <-.2,.079,0>}
		}
		rotate y*-10
		translate <.05,0,-.1>
	}
#end

#if (Menu=True)
	object {
		union {
			union {
				box {<-.175,0,-.1>,<.175,.02,.1>}
				box {<-.174,.01,-.005>,<.174,.5,.005>}
				texture {T_Glass2}
			}
			box {
				<-.175,.01,-.001>,<.175,.495,.001>
				pigment {
					image_map {
						gif "menu.gif"
					}
					translate <-.5,0,0>
					scale <.35,.5,1>
					translate <0,.01,0>
				}
			}
		}
		rotate y*-21
		translate <-.7,0,1.25>
	}
#end

#if (Brocolli=True)
	#declare Broc=
	object {
		#declare SD1=seed(5)
		#declare BarkTexture=1
		#declare Bark=texture {pigment {color DarkOliveGreen}}
		#declare LeafShape=1
		#declare Leave=object {sphere {<0,0,.2>,.22	scale <1,1,1.25>}
		#declare LeafTexture=1
		#declare Leaves=texture {pigment {color DarkOliveGreen*1.5}}
		#declare BaseLen=.02
		#declare MinXDeg=5
		#declare MaxXDeg=20
		#declare PlusMinus=10
		#declare LengthInc=1.05
		#include "trees.inc"
	}

	object {
		Broc
		rotate x*70
		rotate y*-80
		translate <.125,0,-.375>
	}

	object {
		Broc
		scale <.95,.95,.95>
		rotate y*(rand(SD)*360)
		rotate x*70
		rotate y*-120
		translate <.175,.0,-.325>
	}
#end
