// Source file by Tim Attwood April 4, 1997
//
// The Nisqually Valley School: A Virtual Restoration
//

#version 3

#include "colors.inc"
#include "skies.inc"
#include "metals.inc"

global_settings
{
  assumed_gamma 1.0
}

camera
{
  location  <0.0, 0, -14.0>
  look_at   <0.0, 2.0,  10.0>
  angle 40
}

sky_sphere { S_Cloud3 }
light_source
{ <-50,100,-50> rgb <1,1,0.8> }
light_source
{ <0,50,-50> rgb <1,1,0.8> }
light_source
{ <-10,10,-10> rgb <1,1,0.8> }
plane { y, -1
 texture {
  pigment { DarkGreen }
  normal {dents scale 0.5}
  finish {phong 0.7}
 }
}
// ----------------------------------------
#declare Siding = texture {
 pigment {
  bozo
  color_map {
   [0 White]
   [0.5 White]
   [1 Goldenrod]
  }
  scale 0.2
 }
 finish {
  reflection 0.1
  phong 0.9
  phong_size 255
  diffuse 0.5
  ambient 0.2
 }
}
#declare WhtTrm = texture {
 pigment {DarkGreen}
 finish {
  reflection 0.2
  phong 0.9
  diffuse 0.5
  ambient 0.1
 }
}
//#declare Side = box { <0,0,-1>,<10,8,-0.01> pigment {White}}
#declare Side = union {
 #declare SideCount = 9
 #while (SideCount >= 0)
  box {<0,0,-1>,<10,0.5,0> rotate <10,0,0> translate <0,SideCount,0>}
  #declare SideCount = SideCount -0.5
 #end
 texture {Siding}
}
#declare RoofTx = texture {
 pigment {
  brick DarkGreen,DarkSlateGray
  scale 0.2
 }
}
#declare BellTower = union {
 difference {
  box {<6,6.75,0>,<10,10,4>}
  box {<0,0,-0.1>,<5,-5,5> rotate <0,0,-45> translate <8,8.75,0>}
  texture {Siding}
 }
 difference {
  box {<5.5,9.8,-0.5>,<10.5,10.1,4.5> texture {Siding finish{ambient 0.6}} }
  box {<5.9,9.5,-0.1>,<10.2,10.5,4.1> inverse texture {WhtTrm}}
 }

  box {<6,10,0>,<6.5,13,0.5> texture {Siding}}
  box {<6,10,3.5>,<6.5,13,4> texture {Siding}}
  box {<9.5,10,0>,<10,13,0.5> texture {Siding}}
  box {<9.5,10,3.5>,<10,13,4> texture {Siding}}
  difference {
   box {<5.5,12.8,-0.5>,<10.5,13.1,4.5> texture {Siding finish{ambient 0.6}}}
   box {<5.9,12.5,-0.1>,<10.2,13.5,4.1> inverse texture {WhtTrm}}
  }
  difference {
   box {<0,0,0>,<4,2,4>}
   box {<-0.1,0,-0.1>,<4.1,3,4.1> rotate <0,0,45> }
   box {<-0.1,0,-0.1>,<4.1,3,4.1> rotate <-45,0,0> }
   box {<-0.1,0,-0.1>,<-4.1,3,4.1> rotate <0,0,-45> translate <4,0,0>}
   box {<-0.1,0,-0.1>,<-4.1,3,-4.1> rotate <45,0,0> translate <4,0,4>}
   scale <1.1,1,1.1>
   translate <6,13.09,0>
   texture {RoofTx}
  }
  difference {
   box {<0,0,0>,<1,4,1>}
   box {<-0.1,0,0>,<10,10,10> rotate <0,0,84> }
   box {<-0.1,0,0>,<10,10,10> rotate <-84,0,0> }
   box {<-0.1,0,0>,<-10,10,10> rotate <0,0,-84> translate <1,0,0>}
   box {<-0.1,0,0>,<-10,10,-10> rotate <84,0,0> translate <1,0,1>}
   translate <7.5,14.5,1.5>
   texture {Siding}
  }
  translate <-6,-6.75,0>
  scale <0.5,0.5,0.5>
  translate <7,7.75,0>
}

#declare Chimney = union {
 box {<0.2,2,0.2>,<0.8,2.3,0.8> pigment {Gray80}}
 difference {
  box {<0,0,0>,<1,2,1>}
  box {<0,0,0>,<2,-2,2> rotate <-45,0,0>}
  texture {
   pigment {
    brick Firebrick, Brown
    scale 0.1
   }
  }
 }
}

#declare Roof = union {
 difference {
  box {<0,4.75,-0.25>,<16.26,8.7501,11> texture {Siding}}
  box {<0,-10,-1>,<10,0,12> rotate <0,0,-45> translate <8,8.25,0> texture {Siding}}
  difference {
   box {<0,0,0>,<15.25,-10,10> rotate <45,0,0> translate <0.5,8.2499,5.75> }
   box {<0,0,-1>,<10,10,12> rotate <0,0,45> translate <0.5,4.75,0>}
   box {<-10,10,-1>,<0,0,12> rotate <0,0,-45> translate <15.75,4.75,0>}
   texture {pigment {White}}
  }
  box {<0,0,-1>,<10,10,12> rotate <0,0,45> translate <0,4.75,0> texture {RoofTx}}
  box {<-10,10,-1>,<0,0,12> rotate <0,0,-45> translate <16.25,4.75,0> texture {RoofTx}}
  difference {
   box {<-1,4.749,-0.5>,<17,8.751,12>}
   box {<0,-10,-1.1>,<10,0,12.1> rotate <0,0,-45> translate <8,8.75,0> }
   box {<0,0,0>,<19,-10,10> rotate <45,0,0> translate <-1.1,8.75,5.75> }
   texture {RoofTx}
  }
 }
 object {
  Chimney
  translate <4.5,7,3.8>
 }
 object {
  Chimney
  translate <10.75,7,3.8>
 }
 object {
  BellTower
 }
}
#declare Walls = difference {
 union {
  box {<0.25,0,1.5>,<16,9,10>}
  box {<4,0,0>,<12,9,10.75>}
  texture {Siding}
 }
 union {
  box {<0.5,0.7503,1.75>,<15.75,10,9.75> pigment {White}}
  box {<4.25,0.7502,0.25>,<11.75,10,10.5> pigment {White}}
  box {<0,4.75,0.2499>,<17,10,10.4999> pigment {White}}
  box {<0.5001,0.7501,1.7501>,<15.7499,10,9.7499> pigment {Brown}} // floor
  box {<4.2501,0.75,0.2501>,<11.7499,10,10.4999> pigment {Brown}}
  box {<0,0,-5>,<10,10,15> rotate <0,0,45> translate <4,4.75,0> pigment {White}}
  box {<0,0,-5>,<-10,10,15> rotate <0,0,-45> translate <12,4.75,0> pigment {White}}
  box {<6.5,0.7501,-1>,<9.5,3.75,2> pigment {White}} //door
  box {<4.5,1.25,-1>,<5.5,3.25,2> pigment {White}} // door windows
  box {<10.5,1.25,-1>,<11.5,3.25,2> pigment {White}}
  box {<-1,1.25,2.5>,<2,2.75,3.5> pigment {White}} // side windows
  box {<-1,1.25,4>,<2,2.75,5> pigment {White}}
  box {<-1,1.25,5.5>,<2,2.75,6.5> pigment {White}}
  difference { // round window
   cylinder {<8,5.5,-1>,<8,5.5,2>,1}
   box {<6,3,-2>,<10,5.4999,3>}
   pigment {White}
  }
  object { Side translate <3,0,0>} // siding
  object { Side translate <12.0001,0,1.5>}
  object { Side translate <-5.9999,0,1.5>}
  object { Side rotate <0,90,0> translate <0.25,0,10.5>}
  object { Side rotate <0,90,0> translate <4,0,1.5>}
  object { Side rotate <0,90,0> translate <4,0,20.001>}
  object { Side rotate <0,-90,0> translate <16,0,0.5>}
  object { Side rotate <0,-90,0> translate <12,0,-8.5>}
  object { Side rotate <0,-90,0> translate <12,0,10.0001>}
  object { Side rotate <0,-180,0> translate <3,0,10.75>}
 }
}

#declare Trim = union {
 box {<6.8,5.3,-0.05>,<9.2,5.5,0.3>} // round window trim
 difference {
  cylinder {<8,5.5,-0.05>,<8,5.5,0.3>,1.2}
  cylinder {<8,5.5,-1>,<8,5.5,2>,0.9999}
  box {<6,3,-2>,<10,5.4999,3>}
 }
 difference {
  cylinder {<8,5.5,0.05>,<8,5.5,0.2>,0.55}
  cylinder {<8,5.5,-1>,<8,5.5,2>,0.45}
  box {<6,3,-2>,<10,5.4999,3>}
 }
 box {<-1.1,-0.05,0.05>,<0,0.05,0.2> rotate <0,0,-36> translate <8,5.4,0>}
 box {<-1.1,-0.05,0.05>,<0,0.05,0.2> rotate <0,0,-72> translate <8,5.4,0>}
 box {<-1.1,-0.05,0.05>,<0,0.05,0.2> rotate <0,0,-108> translate <8,5.4,0>}
 box {<-1.1,-0.05,0.05>,<0,0.05,0.2> rotate <0,0,-144> translate <8,5.4,0>}

 difference { // door window trim
  box {<4.4,1.15,-0.05>,<5.6,3.35,0.05>}
  box {<4.6,1.35,-0.1>,<5.4,3.15,0.1>}
 }
 box {<4.5,2.15,0.05>,<5.5,2.35,0.2>}
 difference {
  box {<10.4,1.15,-0.05>,<11.6,3.35,0.05>}
  box {<10.6,1.35,-0.1>,<11.4,3.15,0.1>}
 }
 box {<10.5,2.15,0.05>,<11.5,2.35,0.2>}

 box {<6.4,0,-0.05>,<6.6,3.9,0.3>} // door trim
 box {<9.4,0,-0.05>,<9.6,3.9,0.3>}
 box {<6.3999,3.7,-0.05>,<9.5999,3.8999,0.3>}

 difference { // side window trim
  box {<0.2,1.15,2.4>,<0.55,2.85,3.6> }
  box {<-1,1.35,2.6>,<2,2.65,3.4> }
 }
 box {<0.3,1.9,2.5>,<0.45,2.1,3.5>}
 difference {
  box {<0.2,1.15,3.9>,<0.55,2.85,5.1> }
  box {<-1,1.35,4.1>,<2,2.65,4.9> }
 }
 box {<0.3,1.9,4>,<0.45,2.1,5>}
 difference {
  box {<0.2,1.15,5.4>,<0.55,2.85,6.6> }
  box {<-1,1.35,5.6>,<2,2.65,6.4> }
 }
 box {<0.3,1.9,5.5>,<0.45,2.1,6.5>}

 box {<0.2,0,1.45>,<0.4,4.75,1.65>} // corner trim
 box {<15.85,0,1.45>,<16.05,4.75,1.65>}
 box {<0.2,0,9.85>,<0.4,4.75,10.05>}
 box {<15.85,0,9.85>,<16.05,4.75,10.05>}

 texture {WhtTrm}
}

#declare WinGlass = union { // glass
 box {<4.4,1.1,0.1>,<5.6,3.3,0.15>}
 box {<10.4,1.1,0.1>,<11.6,3.3,0.15>}
 box {<6.5,5.4,0.1>,<9.5,6.7,0.15>}
 box {<0.35,1,2.4>,<0.4,3,6.6>}
 texture {
  pigment { rgb <0.8,1,1> filter 0.99 }
  finish {
   diffuse 0.05
   reflection 0.1
   refraction 1
   ior 1.5
   fade_distance 1
   fade_power 2
  }
 }
}
#declare DoorPrim1 = union {
 box {<7.35,1,0>,<7.75,1.5,0.1>}
 box {<7.35,1.75,0>,<7.75,3,0.1>}
 box {<7.35,3.25,0>,<7.75,3.5,0.1>}
 box {<6.75,1,0>,<7.125,1.5,0.1>}
 box {<6.75,1.75,0>,<7.125,3,0.1>}
 box {<6.75,3.25,0>,<7.125,3.5,0.1>}
}
#declare DoorPrim2 = difference {
 box {<6.5,0.7501,0.05>,<9.5,3.75,0.2>}
 box {<7.95,0.7401,0>,<8.05,3.85,0.3>}
 object {DoorPrim1}
 object {DoorPrim1 translate <1.5,0,0>}
 texture {Siding}
}
#declare Door = union {
 object {DoorPrim2}
 sphere {<7.875,2.15,0>,0.1 texture {pigment {Brass} finish {F_MetalA}}}
 sphere {<8.125,2.15,0>,0.1 texture {pigment {Brass} finish {F_MetalA}}}
}
#declare School = union {
 object {
  WinGlass
 }
 object {
  Walls
 }
 object {
  Trim
 }
 object {
  Roof
 }
 object {
  Door
 }
 difference { // steps
  box{<6.3,0,-1>,<9.7,0.75,0>}
  box{<6,0.375,-2>,<10,1,-0.5>}
  texture {
   pigment {
    Gray70
   }
   normal {
    bumps
    scale 0.1
   }
  }
 }
}

//-----------------------------------------
#declare YelDaf = texture {
  pigment {color rgb <1,1,0.3>}
  finish {
   ambient 0.4
   diffuse 0.3
   reflection 0.2
   phong 0.7
   phong_size 90
  }
 }
#declare WhtDaf = texture {
  pigment {color rgb <1,1,1>}
  finish {
   ambient 0.4
   diffuse 0.3
   reflection 0.2
   phong 0.7
   phong_size 90
  }
 }
#declare GrnDaf = texture {
  pigment {rgb <0,0.4,0.1>}
  finish {
   ambient 0.4
   diffuse 0.3
   reflection 0.2
   phong 0.7
   phong_size 90
  }
 }
// ---- daffodils ------
#declare R1 = seed(2)
#declare Loop = 10
#while (Loop > 0)
 #declare Rsd = 1000*rand(R1)
 #include "daffodil.inc"
 object {
  Daffodil
  scale 0.5
  translate <2.5-5*rand(R1),-1,-7-5*rand(R1)>
 }
 #declare Loop = Loop - 1
#end
// ------- Grass ------------
#declare Loop = 500
#while (Loop > 0)
polygon {
 5,
 <0,0>,<0,0.15>,<100,0.15>,<100,0>,<0,0>
 texture {
  pigment {
   gradient x
   color_map {
    [ 0 DarkGreen]
    [ 0.05 DarkGreen]
    [ 0.05 Clear]
    [ 0.3 Clear]
    [ 0.3 ForestGreen]
    [ 0.35 DarkGreen]
    [ 0.35 Clear]
    [ 0.5 Clear]
    [ 0.5 DarkGreen]
    [ 0.55 DarkGreen]
    [ 0.55 Clear]
    [ 0.7 Clear]
    [ 0.7 ForestGreen]
    [ 0.75 ForestGreen]
    [ 0.75 Clear]
   }
  }
  scale <0.5,1,1>
 }
  translate <-49.5+rand(R1),-1,-5+75*(rand(R1)*rand(R1))>
 }
 #declare Loop = Loop - 1
#end

// ------The two room school house ----------
object {
 School
 scale 1
 rotate <0,-30,0>
 translate <-7,-1,15>
}
// ------------ Sonya Roberts Trees :)
#declare R2 = seed (3)
#declare TLoop = 10
#while (TLoop >0)
 #declare SDN = int(10000*rand(R2))
 #include "tree.pov"
 object {
  Tree
  scale <0.6,0.8,0.6>
  translate <31 -TLoop*3 -2*rand(R2),-1,30+10*rand(R2)>
 }
 #declare TLoop = TLoop -1
#end

