// Persistence of Vision Ray Tracer Scene Description File
// File: beepcar.inc
// Vers: 3
// Desc: support file for nschool - "The beep beep car"
// Date: 970326
// Auth: Dick Balaska

///////////////////////////////////////////////////////////////////////////////////////
// If 'True' is not defined, then this file is running by itself (not from nschool.pov)
#ifndef	(True)
#include "colors.inc"
#include "textures.inc"
#include "skies.inc"
#include "golds.inc"
#include "stones.inc"
#include "glass.inc"
#include "metals.inc"
#include "woods.inc"
#include "orngwood.map"

#declare True=1
#declare False=0

#declare bcTest=1		// run from this file?  need a beepcar
#declare ClayColor	= rgb <0.7305, 0.3672, 0>
#declare ClayColor2	= rgb <0.4870, 0.2448, 0>
#declare ClayColor3	= rgb <0.3653, 0.1836, 0>

global_settings {
	ambient_light rgb<1,1,1>
}

//  "real" position
//camera { location < 0, 11, 0>
//		 look_at  < 9, 2, 32> }

//	camera { location < 13, 9, 21>
//			 look_at  < 9, 4, 32> }

//	camera { location < -4, 2, 26>
//	look_at < 0, 2, 40> }

	camera { location < 0, 6, -17>
//	camera { location < 0, 25, 0>
//	camera { location < 18, 12, 0>

//	camera { location < 4, 5, 18>
//	camera { location < 28, 1, 4>
//	camera { location < -32, 9, 0>
	look_at < 0, 6, 0> }

#if (1)
	light_source { < -100, 70, -100 > color rgb 2 }
	light_source { <  100, 70,  100 > color rgb 2 }
	light_source { <    0, 10, 00 > color White shadowless }
#else
	light_source { < -5, 30, 0 > color rgb 0.5 }
	light_source { < 24, 30, 0 > color rgb 0.5 }
	light_source { < -5, 30, 29 > color rgb 0.5 }
	light_source { < 24, 30, 29 > color rgb 0.5 }
#end
//        background { Black }
        background { White }
        //sky_sphere { S_Cloud1 rotate y * 180 }

        plane { y, 0
                pigment { color rgb < 0.6, 0.6, 0.6 > }
                // normal { crackle 0.2 scale 3 }
				}
//#include "markerballs.inc"
#end
///////////////////////////////////////////////////////////////////////////////////////

#declare bcWheel=
object {
	union {
		superellipsoid {
			<1, 0.25>
			scale <.5, .5, 0.2>
			pigment {Black}
		}
		intersection {
			sphere {
				<0,0,.7> .8
				//pigment {White}
				texture { T_Chrome_5E }
			}

			// An infinite planar surface
			// plane {<A, B, C>, D } where: A*x + B*y + C*z = D
			plane {
				z, // <X Y Z> unit surface normal, vector points "away from surface"
				0 // distance from the origin in the direction of the surface normal
				pigment {White}
			}
			translate <0,0,-.2>
		}
		sphere {
			<0,0,-.25> .1
			pigment {Black}
		}
	}
}

//object { bcWheel rotate y*0}

#declare bcBody=
object {
//	union {
		difference {
			union {
				difference {
					box { <0, 0, 0>    <12.5, 8, 8> }
					box { <3.5, 4, -1> <16, 9, 9> }
				}
				superellipsoid {
					<0.25 0.25>
					translate <-1,-1,-1>
					scale <3.5, 4, 4>
					translate <16, 8, 8>
				}
			}
			superellipsoid {
				<1, 0.25>
				scale <1, 1, 0.5>
				translate <3,0,0>
			}
			superellipsoid {
				<1, 0.25>
				scale <1.3, 1.3, 0.8>
				translate <12.5,0,0>
			}
			superellipsoid {
				<1, 0.25>
				scale <1, 1, 0.5>
				translate <3,0,8>
			}
			superellipsoid {
				<1, 0.25>
				scale <1.3, 1.3, 0.8>
				translate <12.5,0,8>
			}
		}
		texture {
			pigment {OrangeRed}
			#ifndef	(bcTest)
				normal {dents 1.0 scale 1}
			#end
		}
//	}
}
#declare bcSeatTexture=
texture {
	pigment {
		crackle
		scale 0.2
		pigment_map {
			[ 0.0 Black]
			[ 0.2 Black]
			[ 0.9 Silver]
		}
	}
}

#declare bcSeat=
object {
	union {
		box {
			<5,0,0.1>
			<8,1,7.9>
			pigment {Red}
		}
		superellipsoid {
			<0.25, 0.25>
			scale <1.5, 1, 4>
			translate <6.5,2,4>
			texture {bcSeatTexture}
		}
		superellipsoid {
			<0.25, 0.25>
			scale <0.5, 2, 4>
			translate <7.5,5,4>
			texture {bcSeatTexture}
		}

	}
}

#declare bcCage=
object {
	union {
		// The big quartercircles in front
		intersection {
			union {
				torus {			// port
				  8, 0.2
				  rotate x*90
				  translate <0,0,-3>
				}
				torus {			// starboard
				  8, 0.2
				  rotate x*90
				  translate <0,0,3>
				}
				torus {			// center
				  8, 0.1
				  rotate x*90
				  translate <0,0,0>
				}
				pigment {Red}
			}
			plane { <1,0,0>, 0 pigment {Clear}}
			plane { <0,-1,0>, 0 pigment {Clear}}
		}
		#declare bcY=0
		#while (bcY<91)
			box { <-8, 0, -3> <-7.8, .2, 3> rotate z*-bcY pigment {Red} }
			#declare bcY=bcY+10
		#end
		#declare bcY=7
		#while (bcY>-1)
			box { <1, 0, -3> <1.2, .2, 3> translate <0, bcY, 0> pigment {Red} }
			#declare bcY=bcY-1
		#end
		// The 3 vertical posts in the back
		cylinder { <1,-1,-3> <1,7,-3> 0.2 pigment {Red} }
		cylinder { <1,-1,3>  <1,7,3>  0.2 pigment {Red} }
		cylinder { <1,-1,0>  <1,7,0>  0.1 pigment {Red} }
		// The little quartercircles in back
		intersection {
			union {
				torus {
				  1, 0.2
				  rotate x*90
				  translate <0,0,-3>
				}
				torus {
				  1, 0.2
				  rotate x*90
				  translate <0,0,3>
				}
				torus {
				  1, 0.1
				  rotate x*90
				  translate <0,0,0>
				}
				pigment {Red}
			}
			plane { <-1,0,0>, 0 pigment {Clear} }
			plane { <0,-1,0>, 0 pigment {Clear} }
			translate <0,7,0>
		}
	}
}

#declare bcLogo=
object {
	box {
		<0, 0, 0 >
		<1, 1, 1 >
		pigment {
			image_map {
				gif "webhead.gif"
				transmit 15 1.0
			}
		}
		scale <1, .5, 1>
		scale <10,5,5>
		// rotate <90,180,0>
		translate <2.5,1,-0.0001>
	}
}

#declare bcCar=
object {
	union {
		object {bcBody}
		object {bcWheel scale 1.7 translate <3, 0, 0>}
		object {bcWheel scale 2.1 translate <12.5, .15, 0>}
		object {bcWheel scale 1.7 rotate y*180 translate <3, 0, 8>}
		object {bcWheel scale 2.1 rotate y*180 translate <12.5, .15, 8>}
		object {bcSeat scale <1,.8, 1> translate <1,4,0>}
		object {bcCage scale 1 translate <8,8,4> }
		object {bcLogo}
	}
	translate <-8,0.9,-4>
//	scale 0.5
}

#ifdef (bcTest)
object {bcCar rotate y*0}
//object {bcCage}
#end
