// Persistence of Vision Ray Tracer Scene Description File
// File: cactshelf.inc
// Vers: 3
// Desc: The shelf unit with the cactii
// Date: 970323
// Auth: Dick Balaska (cactii by Sonya Roberts)


#declare shelfleg =
object {
	box {
		<-0.1,  0, -0.1>
		< 0.1, 30,  0.1>
		texture { Silver1 }
	}
}

#declare shelftable =
object {
	box {		// table
		<-4, -0.2, -2>
		< 4,  0,    2>
		texture { Silver2 }
	}
}

#declare shelfunit =
object {
	union {
		object { shelftable translate <0, 0.4, 0> }
		object { shelftable translate <0, 3, 0> }
		object { shelftable translate <0, 6, 0> }
		object { shelftable translate <0, 9, 0> }
		object { shelftable translate <0, 12, 0> }
		object { shelftable translate <0, 15, 0> }
		object { shelftable translate <0, 18, 0> }
		object { shelftable translate <0, 21, 0> }
		object { shelftable translate <0, 24, 0> }
		object { shelftable translate <0, 27, 0> }
		object { shelftable translate <0, 30, 0> }
		object { shelfleg	translate <-3.8, 0, -1.8> }
		object { shelfleg	translate < 3.8, 0, -1.8> }
		object { shelfleg	translate < 3.8, 0,  1.8> }
		object { shelfleg	translate <-3.8, 0,  1.8> }
	}
}


#if (!NoCactii)
// The shelf of little cactii
#declare LittleCactiiShelf =
object {
	#debug "Creating LittleCactiiShelf "
	union {
#declare cactY = 6
#declare shelf2 = seed(1000)
#declare sz = -1.6
#while (sz < 1.7)
	#declare sx = -3.3
	#while (sx < 3.8)
		#debug "."
		#declare cR = rand(shelf2)
		#declare cpX = sx -0.1 + (rand(shelf2) * 0.2)	// push the x a little
		#declare cpZ = sz -0.1 + (rand(shelf2) * 0.2)	// push the z a little
		#switch (cR)				// select 3 different cactii
			#range ( 0,  0.2)		// 1 in 10 not drawn
			#break;
			#range (0.2, 0.45)
				object { Cactus1 translate <cpX, cactY, cpZ> }
			#break;
			#range (0.45, 0.7)
				object { Cactus2 translate <cpX, cactY, cpZ> }
			#break;
			#range (0.7, 1.0)
				object { Cactus3 translate <cpX, cactY, cpZ> }
			#break;
		#end
		#declare sx = sx + 0.8
	#end
#declare sz = sz + 0.8
#end
	}
#debug "\n"
}

// The shelf of medium size cactii
#declare MediumCactiiShelf =
object {
	#debug "Creating MediumCactiiShelf "
	union {
#declare cactY = 3
#declare shelf2 = seed(1001)
#declare sz = -1.6
#while (sz < 1.7)
	#declare sx = -2.9
	#while (sx < 3.8)
		#debug "."
		#declare cR = rand(shelf2)
		#declare cpX = sx -0.1 + (rand(shelf2) * 0.3)	// push the x a little
		#declare cpZ = sz -0.1 + (rand(shelf2) * 0.3)	// push the z a little
		#switch (cR)				// select 3 different cactii
			#range ( 0,  0.2)		// 1 in 10 not drawn
			#break;
			#range (0.2, 0.45)
				object { Cactus1 scale 2 translate <cpX, cactY, cpZ> }
			#break;
			#range (0.45, 0.7)
				object { Cactus2 scale 2 translate <cpX, cactY, cpZ> }
			#break;
			#range (0.7, 1.0)
				object { Cactus3 scale 2 translate <cpX, cactY, cpZ> }
			#break;
		#end
		#declare sx = sx + 1.4
	#end
#declare sz = sz + 1.4
#end
	}
#debug "\n"
}

// The shelf of pots
#declare PotShelf0=
object {
	#declare psRand = seed(1002)
	#debug "Creating PotShelf0 "
	union {
	#declare cactY = 9
	#declare sz = -1.4
	#while (sz < 1.7)
		#declare sx = -2.9
		#while (sx < 3.8)
			#debug "."
			#declare cR = rand(psRand)
			#declare cpX = sx -0.1 + (rand(psRand) * 0.3)	// push the x a little
			#declare cpZ = sz -0.1 + (rand(psRand) * 0.3)	// push the z a little
			#declare cpHeight = int(cR * 6)
			#declare cpY = cpHeight
			#while (cpY > 0)
				object { DickCactusPot scale 0.5 translate <cpX, cactY+(cpY*0.4)-0.4, cpZ> }
				#declare cpY = cpY - 1
			#end
			#declare sx = sx + 1.4
		#end
	#declare sz = sz + 1.35
	#end
	}
#debug "\n"
}

// The shelf of pots
#declare PotShelf1=
object {
//	#declare psRand = seed(1002)
	#debug "Creating PotShelf1 "
	union {
	#declare cactY = 12
	#declare sz = -1.6
	#while (sz < 1.7)
		#declare sx = -2.9
		#while (sx < 3.8)
			#debug "."
			#declare cR = rand(psRand)
			#declare cpX = sx -0.1 + (rand(psRand) * 0.3)	// push the x a little
			#declare cpZ = sz -0.1 + (rand(psRand) * 0.3)	// push the z a little
			#declare cpHeight = int(cR * 7)
			#declare cpY = cpHeight
			#while (cpY > 0)
				object { DickCactusPot scale 0.3 translate <cpX, cactY+(cpY*0.3)-0.3, cpZ> }
				#declare cpY = cpY - 1
			#end
			#declare sx = sx + 1.4
		#end
	#declare sz = sz + 1.4
	#end
	}
#debug "\n"
}
#end	// !NoCactii


#declare CactusBig=
union {
	object {DickCactusPot}
	object {Pod	scale <.35,0.8,.35>	translate <0,1,0>}
	scale 0.2
}


#declare CactiiShelfUnit =
object {
	union {
		object { shelfunit }
		#if (!NoCactii)
			object { PotShelf0 }
			object { PotShelf1 }
			object { LittleCactiiShelf }
			object { MediumCactiiShelf }
			object { CactusBig scale <5,3.1,5> rotate y*5 translate <-2.1, 0.4, -0.9> }
			object { CactusBig scale <5,3,5> translate < 2, 0.4, -1> }
		#end
	}
}
