// Persistence of Vision Ray Tracer Scene Description File
// File: cactus.inc
// Vers: 3.00e Watcom Win32
// Desc: Sonya's cactus from IRTC "Space" entry "cul101"
// Date: Oct. 7/96
// Auth: Sonya Roberts
// Note:

// ==== Cactus Thing ====
#declare Part=
object {
	union {
		cylinder {<0,0,.5>,<0,2,.5>,.5}
		sphere {<0,2,.5>,.5}
	}
	scale <.5,1,1.5>
}

#declare Pod=
union {
	object {Part	rotate y*0}
	object {Part	rotate y*30}
	object {Part	rotate y*60}
	object {Part	rotate y*90}
	object {Part	rotate y*120}
	object {Part	rotate y*150}
	object {Part	rotate y*180}
	object {Part	rotate y*210}
	object {Part	rotate y*240}
	object {Part	rotate y*270}
	object {Part	rotate y*300}
	object {Part	rotate y*330}

	#declare PD1=seed(1)
	#declare PX=1
	#while (PX<=12)
		#declare PY=1
		#while (PY<=8)
			#declare PZ=1
			union {
				#while (PZ<=5)
					cone{
						<0,(.25*PY),1.24>,.06,
						<.25-(rand(PD1)*.5),((.25*PY)+.25)-(rand(PD1)*.5),2-(rand(PD1)*.25)>,.01
						pigment {color rgb <.92,.91,.82>}
					}
					#declare PZ=PZ+1
				#end
				rotate y*(30*PX)
			}
			#declare PY=PY+1
		#end
		#declare PX=PX+1
	#end
	texture {T_Stone1}
}

#declare SonyaCactusPot=
object {
	union {
		cone {<0,0,0>,.6,<0,.81,0>,1}
		cone {<0,.8,0>,1.05,<0,1,0>,1.1}
	}
	pigment {color OrangeRed}
}

#declare DickCactusPot =
object {
	difference {
		merge {
			superellipsoid {
				<1, 0.25>
				rotate <90,0,0>
				scale <2, 0.5, 2>
				translate <0, 1.7, 0>
			}
			cone {
				<0, 2, 0>, 2.0,
				<0, 0, 0>, 1.5
			}
		}
		cone {
			<0, 2.3, 0>, 1.4,
			<0, 0, 0>, 0.7
		}
	}
	texture {
		pigment {
			marble
			color_map { [0.0 color ClayColor3] [0.1 color ClayColor2] [0.3 ClayColor] }
			turbulence 0.6
			//crand 0.2
			scale 0.1
		}
		normal {
			//bumps 0.3
			marble
			//scale <0.5, 0.5, 0.5>
		}
		finish {
			phong 0.1
			specular 0.025
			ambient 0.6
		}
		rotate z*90
	}
	scale 0.6
}

#declare Cactus1=
union {
	object {SonyaCactusPot}
	object {Pod	scale <.35,1,.35>	translate <0,1,0>}
	scale 0.2
}

#declare Cactus2=
union {
	object {SonyaCactusPot}
	object {Pod	scale <.35,0.8,.35>	translate <0,1,0>}
	scale 0.2
}

#declare Cactus3=
union {
	object {SonyaCactusPot}
	object {Pod	scale <.35,0.7,.35>	translate <0,1,0>}
	scale 0.2
}
