// Persistence of Vision Ray Tracer Scene Description File
// File: nschool.pov
// Vers: 3
// Desc: IRTC 'School' Entry - Nursery School
// Date: 970318
// Auth: Dick Balaska

// nschool.pov
// try out some sonya trees


#include "colors.inc"
#include "textures.inc"
#include "skies.inc"
#include "golds.inc"
#include "stones.inc"
#include "glass.inc"
#include "metals.inc"
#include "woods.inc"
#include "orngwood.map"
#include "ash.map"

#declare True=1
#declare False=0

#declare Test=0
#declare NoTrees=0
#declare TeacherOnly=0
#declare NoCactii=0

global_settings {
	ambient_light rgb<1,1,1>
}

camera { location < 0, 10, 0>
look_at < 9, 2, 32> }


light_source { < -5, 30, 0 > color rgb 0.5 }
light_source { < 24, 30, 0 > color rgb 0.5 }
light_source { < -5, 30, 29 > color rgb 0.5 }
light_source { < 24, 30, 29 > color rgb 0.5 }
//light_source { < -5, 30, 60 > color rgb 0.5 }
//light_source { < 24, 30, 60 > color rgb 0.5 }

//light_source { <    0, 10, 00 > color White shadowless }

background { Black }

plane { y, 0
	pigment { color rgb < 0.6, 0.6, 0.6 > }
	#if (!Test)
	normal { crackle 0.3 scale 3 }
	#end
}

#include "projector.inc"
#include "walls.inc"
//#include "markerballs.inc"
#include "palette.inc"
object { palette rotate y*90 translate <-3, 0, 48>}

#if (!NoTrees)
#include "treeclass.inc"

#include "cactus.inc"
#include "cactshelf.inc"
object { CactiiShelfUnit rotate y*90 translate <22,0,20>}

#end
#include "palmtree.inc"
object { palm_tree rotate y*190 translate <26, 0, 39> }
object { DickCactusPot scale <1.3, 1.5, 1.3> translate <26,0,39> }
object { palm_tree rotate y*100 translate <26, 0, 28> }

#include "beepcar.inc"
object {bcCar rotate y*-30 translate <-21.5,0,85> }

#include "saw.inc"
object { saw_table rotate y*20 translate <-6.5, 0, 28>}

#include "wires.inc"
object {projwire}
object {sawwire}

#include "lumber.inc"
object { lumber_rack translate <28, 0, 66> }
