// Persistence of Vision Ray Tracer Scene Description File
// File: treeclass.inc
// Vers: 3
// Desc:
// Date:
// Auth:

// declare the trees that make up the class

#if (!TeacherOnly)
// tree # 1
	#declare MaxSplits=4		// Maximum number of forks in a section of Tree (minimum of 1)
	#declare MinSplits=3		// Minimum number of forks in a section of Tree (minimum of 1)
	#declare IncSplits=1		// To Increase Max. Splits near Branch Tips, Make > 1 - KEEP IT SMALL!
	#declare BaseLen=1			// Base Length (length of smallest twig - determines scale of tree)
	#declare LengthInc=1.2		// Factor By Which to Increase Base Length
	#declare MinXDeg=35		// Minimum X-rotation of forks
	#declare MaxXDeg=55		// Maximum X-rotation of forks
	#declare IncXDeg=0		// Number of degrees to increment X by at each level
	#declare MinYDeg=30		// Minimum Y-rotation of forks
	#declare MaxYDeg=360		// Maximum Y-rotation of forks		// NOTE: 2nd-Level Branches always based on 360 degrees
	#declare IncYDeg=0		// Number of degrees to increment Y by at each level
	#declare MinZDeg=0		// Minimum Z-rotation of forks		// Z-rotations highly optional - not required at all
	#declare MaxZDeg=0		// Maximum Z-rotation of forks
	#declare IncZDeg=0		// Number of degrees to increment Z by at each level
	#declare PlusMinus=20		// Angle of change of terminal fork
	#declare SD1=seed(2)		// Seed for random numbers - changing only this will create a different tree of the same species
	#declare SD2=seed(1997)		// Seed for additional randum numbers - so tree shape won't change from optional code
	#declare BallJoint=True		// Turns on and off the spheres used to smooth intersections of the branches and trunks
	#declare BallLevels=2		// Maximum Number of Levels to smooth when BallJoint=True (integer from 1 to 5 inclusive)
	#declare LeafNum=3		// Number of Leaves (not counting leaf object at tip of twig)
	#declare LeafRosette=False	// If true, leaves are arranged in rosette around twig rather than spiral up twig
	#declare LeafRandRot=False	// Rotate the leaves around the twig at random angles (cannot be combined with LeafRosette)
	#declare Tip=1			// Select either 1=Leaf, 2=Fruit, or 3=Flower
#include "tree.inc"
object { Tree translate <1, 0, 17> }

// tree # 2
	#declare MaxSplits=5		// Maximum number of forks in a section of Tree (minimum of 1)
	#declare MinSplits=3		// Minimum number of forks in a section of Tree (minimum of 1)
	#declare IncSplits=1		// To Increase Max. Splits near Branch Tips, Make > 1 - KEEP IT SMALL!
	#declare BaseLen=1			// Base Length (length of smallest twig - determines scale of tree)
	#declare LengthInc=1.2		// Factor By Which to Increase Base Length
	#declare MinXDeg=35		// Minimum X-rotation of forks
	#declare MaxXDeg=55		// Maximum X-rotation of forks
	#declare IncXDeg=0		// Number of degrees to increment X by at each level
	#declare MinYDeg=0		// Minimum Y-rotation of forks
	#declare MaxYDeg=360		// Maximum Y-rotation of forks		// NOTE: 2nd-Level Branches always based on 360 degrees
	#declare IncYDeg=0		// Number of degrees to increment Y by at each level
	#declare MinZDeg=0		// Minimum Z-rotation of forks		// Z-rotations highly optional - not required at all
	#declare MaxZDeg=0		// Maximum Z-rotation of forks
	#declare IncZDeg=0		// Number of degrees to increment Z by at each level
	#declare PlusMinus=20		// Angle of change of terminal fork
	#declare SD1=seed(6)		// Seed for random numbers - changing only this will create a different tree of the same species
	#declare SD2=seed(1996)		// Seed for additional randum numbers - so tree shape won't change from optional code
	#declare BallJoint=True		// Turns on and off the spheres used to smooth intersections of the branches and trunks
	#declare BallLevels=2		// Maximum Number of Levels to smooth when BallJoint=True (integer from 1 to 5 inclusive)
	#declare LeafNum=3		// Number of Leaves (not counting leaf object at tip of twig)
	#declare LeafRosette=False	// If true, leaves are arranged in rosette around twig rather than spiral up twig
	#declare LeafRandRot=False	// Rotate the leaves around the twig at random angles (cannot be combined with LeafRosette)
	#declare Tip=3			// Select either 1=Leaf, 2=Fruit, or 3=Flower
#include "tree.inc"
object { Tree translate <4, 0, 20> }

// tree # 3
	#declare MaxSplits=5		// Maximum number of forks in a section of Tree (minimum of 1)
	#declare MinSplits=3		// Minimum number of forks in a section of Tree (minimum of 1)
	#declare IncSplits=1		// To Increase Max. Splits near Branch Tips, Make > 1 - KEEP IT SMALL!
	#declare BaseLen=1			// Base Length (length of smallest twig - determines scale of tree)
	#declare LengthInc=1.2		// Factor By Which to Increase Base Length
	#declare MinXDeg=35		// Minimum X-rotation of forks
	#declare MaxXDeg=55		// Maximum X-rotation of forks
	#declare IncXDeg=0		// Number of degrees to increment X by at each level
	#declare MinYDeg=0		// Minimum Y-rotation of forks
	#declare MaxYDeg=360		// Maximum Y-rotation of forks		// NOTE: 2nd-Level Branches always based on 360 degrees
	#declare IncYDeg=0		// Number of degrees to increment Y by at each level
	#declare MinZDeg=0		// Minimum Z-rotation of forks		// Z-rotations highly optional - not required at all
	#declare MaxZDeg=0		// Maximum Z-rotation of forks
	#declare IncZDeg=0		// Number of degrees to increment Z by at each level
	#declare PlusMinus=20		// Angle of change of terminal fork
	#declare SD1=seed(7)		// Seed for random numbers - changing only this will create a different tree of the same species
	#declare SD2=seed(1997)		// Seed for additional randum numbers - so tree shape won't change from optional code
	#declare BallJoint=True		// Turns on and off the spheres used to smooth intersections of the branches and trunks
	#declare BallLevels=2		// Maximum Number of Levels to smooth when BallJoint=True (integer from 1 to 5 inclusive)
	#declare LeafNum=3		// Number of Leaves (not counting leaf object at tip of twig)
	#declare LeafRosette=False	// If true, leaves are arranged in rosette around twig rather than spiral up twig
	#declare LeafRandRot=False	// Rotate the leaves around the twig at random angles (cannot be combined with LeafRosette)
	#declare Tip=1			// Select either 1=Leaf, 2=Fruit, or 3=Flower
#include "tree.inc"
object { Tree translate <8, 0, 16> }

// tree # 4
	#declare MaxSplits=5		// Maximum number of forks in a section of Tree (minimum of 1)
	#declare MinSplits=3		// Minimum number of forks in a section of Tree (minimum of 1)
	#declare IncSplits=1		// To Increase Max. Splits near Branch Tips, Make > 1 - KEEP IT SMALL!
	#declare BaseLen=1			// Base Length (length of smallest twig - determines scale of tree)
	#declare LengthInc=1.2		// Factor By Which to Increase Base Length
	#declare MinXDeg=35		// Minimum X-rotation of forks
	#declare MaxXDeg=55		// Maximum X-rotation of forks
	#declare IncXDeg=0		// Number of degrees to increment X by at each level
	#declare MinYDeg=0		// Minimum Y-rotation of forks
	#declare MaxYDeg=360		// Maximum Y-rotation of forks		// NOTE: 2nd-Level Branches always based on 360 degrees
	#declare IncYDeg=0		// Number of degrees to increment Y by at each level
	#declare MinZDeg=0		// Minimum Z-rotation of forks		// Z-rotations highly optional - not required at all
	#declare MaxZDeg=0		// Maximum Z-rotation of forks
	#declare IncZDeg=0		// Number of degrees to increment Z by at each level
	#declare PlusMinus=20		// Angle of change of terminal fork
	#declare SD1=seed(10)		// Seed for random numbers - changing only this will create a different tree of the same species
	#declare SD2=seed(1996)		// Seed for additional randum numbers - so tree shape won't change from optional code
	#declare BallJoint=True		// Turns on and off the spheres used to smooth intersections of the branches and trunks
	#declare BallLevels=2		// Maximum Number of Levels to smooth when BallJoint=True (integer from 1 to 5 inclusive)
	#declare LeafNum=3		// Number of Leaves (not counting leaf object at tip of twig)
	#declare LeafRosette=False	// If true, leaves are arranged in rosette around twig rather than spiral up twig
	#declare LeafRandRot=False	// Rotate the leaves around the twig at random angles (cannot be combined with LeafRosette)
	#declare Tip=2			// Select either 1=Leaf, 2=Fruit, or 3=Flower
#include "tree.inc"
object { Tree rotate <0,-45, 0> translate <13, 0, 20> }

// tree # 5
	#declare MaxSplits=5		// Maximum number of forks in a section of Tree (minimum of 1)
	#declare MinSplits=3		// Minimum number of forks in a section of Tree (minimum of 1)
	#declare IncSplits=1		// To Increase Max. Splits near Branch Tips, Make > 1 - KEEP IT SMALL!
	#declare BaseLen=1			// Base Length (length of smallest twig - determines scale of tree)
	#declare LengthInc=1.2		// Factor By Which to Increase Base Length
	#declare MinXDeg=35		// Minimum X-rotation of forks
	#declare MaxXDeg=55		// Maximum X-rotation of forks
	#declare IncXDeg=0		// Number of degrees to increment X by at each level
	#declare MinYDeg=0		// Minimum Y-rotation of forks
	#declare MaxYDeg=360		// Maximum Y-rotation of forks		// NOTE: 2nd-Level Branches always based on 360 degrees
	#declare IncYDeg=0		// Number of degrees to increment Y by at each level
	#declare MinZDeg=0		// Minimum Z-rotation of forks		// Z-rotations highly optional - not required at all
	#declare MaxZDeg=0		// Maximum Z-rotation of forks
	#declare IncZDeg=0		// Number of degrees to increment Z by at each level
	#declare PlusMinus=20		// Angle of change of terminal fork
	#declare SD1=seed(9)		// Seed for random numbers - changing only this will create a different tree of the same species
	#declare SD2=seed(1996)		// Seed for additional randum numbers - so tree shape won't change from optional code
	#declare BallJoint=True		// Turns on and off the spheres used to smooth intersections of the branches and trunks
	#declare BallLevels=2		// Maximum Number of Levels to smooth when BallJoint=True (integer from 1 to 5 inclusive)
	#declare LeafNum=3		// Number of Leaves (not counting leaf object at tip of twig)
	#declare LeafRosette=False	// If true, leaves are arranged in rosette around twig rather than spiral up twig
	#declare LeafRandRot=False	// Rotate the leaves around the twig at random angles (cannot be combined with LeafRosette)
	#declare Tip=1			// Select either 1=Leaf, 2=Fruit, or 3=Flower
#include "tree.inc"
object { Tree translate <11, 0, 14> }

// tree # 6
	#declare MaxSplits=5		// Maximum number of forks in a section of Tree (minimum of 1)
	#declare MinSplits=3		// Minimum number of forks in a section of Tree (minimum of 1)
	#declare IncSplits=1		// To Increase Max. Splits near Branch Tips, Make > 1 - KEEP IT SMALL!
	#declare BaseLen=1			// Base Length (length of smallest twig - determines scale of tree)
	#declare LengthInc=1.2		// Factor By Which to Increase Base Length
	#declare MinXDeg=35		// Minimum X-rotation of forks
	#declare MaxXDeg=55		// Maximum X-rotation of forks
	#declare IncXDeg=0		// Number of degrees to increment X by at each level
	#declare MinYDeg=0		// Minimum Y-rotation of forks
	#declare MaxYDeg=360		// Maximum Y-rotation of forks		// NOTE: 2nd-Level Branches always based on 360 degrees
	#declare IncYDeg=0		// Number of degrees to increment Y by at each level
	#declare MinZDeg=0		// Minimum Z-rotation of forks		// Z-rotations highly optional - not required at all
	#declare MaxZDeg=0		// Maximum Z-rotation of forks
	#declare IncZDeg=0		// Number of degrees to increment Z by at each level
	#declare PlusMinus=20		// Angle of change of terminal fork
	#declare SD1=seed(10)		// Seed for random numbers - changing only this will create a different tree of the same species
	#declare SD2=seed(1996)		// Seed for additional randum numbers - so tree shape won't change from optional code
	#declare BallJoint=True		// Turns on and off the spheres used to smooth intersections of the branches and trunks
	#declare BallLevels=2		// Maximum Number of Levels to smooth when BallJoint=True (integer from 1 to 5 inclusive)
	#declare LeafNum=3		// Number of Leaves (not counting leaf object at tip of twig)
	#declare LeafRosette=False	// If true, leaves are arranged in rosette around twig rather than spiral up twig
	#declare LeafRandRot=False	// Rotate the leaves around the twig at random angles (cannot be combined with LeafRosette)
	#declare Tip=3			// Select either 1=Leaf, 2=Fruit, or 3=Flower
#include "tree.inc"
object { Tree translate <9, 0, 9>}

// tree # 7
	#declare MaxSplits=4		// Maximum number of forks in a section of Tree (minimum of 1)
	#declare MinSplits=3		// Minimum number of forks in a section of Tree (minimum of 1)
	#declare IncSplits=1		// To Increase Max. Splits near Branch Tips, Make > 1 - KEEP IT SMALL!
	#declare BaseLen=1			// Base Length (length of smallest twig - determines scale of tree)
	#declare LengthInc=1.2		// Factor By Which to Increase Base Length
	#declare MinXDeg=35		// Minimum X-rotation of forks
	#declare MaxXDeg=55		// Maximum X-rotation of forks
	#declare IncXDeg=0		// Number of degrees to increment X by at each level
	#declare MinYDeg=30		// Minimum Y-rotation of forks
	#declare MaxYDeg=360		// Maximum Y-rotation of forks		// NOTE: 2nd-Level Branches always based on 360 degrees
	#declare IncYDeg=0		// Number of degrees to increment Y by at each level
	#declare MinZDeg=0		// Minimum Z-rotation of forks		// Z-rotations highly optional - not required at all
	#declare MaxZDeg=0		// Maximum Z-rotation of forks
	#declare IncZDeg=0		// Number of degrees to increment Z by at each level
	#declare PlusMinus=20		// Angle of change of terminal fork
	#declare SD1=seed(100)		// Seed for random numbers - changing only this will create a different tree of the same species
	#declare SD2=seed(1997)		// Seed for additional randum numbers - so tree shape won't change from optional code
	#declare BallJoint=True		// Turns on and off the spheres used to smooth intersections of the branches and trunks
	#declare BallLevels=2		// Maximum Number of Levels to smooth when BallJoint=True (integer from 1 to 5 inclusive)
	#declare LeafNum=2		// Number of Leaves (not counting leaf object at tip of twig)
	#declare LeafRosette=True	// If true, leaves are arranged in rosette around twig rather than spiral up twig
	#declare LeafRandRot=False	// Rotate the leaves around the twig at random angles (cannot be combined with LeafRosette)
	#declare Tip=2			// Select either 1=Leaf, 2=Fruit, or 3=Flower
#include "tree.inc"
object { Tree translate <1, 0, 17> }

#end	// #ifndef (TeacherOnly)

// tree # teacher
	#declare MaxSplits=5		// Maximum number of forks in a section of Tree (minimum of 1)
	#declare MinSplits=4		// Minimum number of forks in a section of Tree (minimum of 1)
	#declare IncSplits=1		// To Increase Max. Splits near Branch Tips, Make > 1 - KEEP IT SMALL!
	#declare BaseLen=2			// Base Length (length of smallest twig - determines scale of tree)
	#declare LengthInc=1.1		// Factor By Which to Increase Base Length
	#declare MinXDeg=35		// Minimum X-rotation of forks
	#declare MaxXDeg=55		// Maximum X-rotation of forks
	#declare IncXDeg=0		// Number of degrees to increment X by at each level
	#declare MinYDeg=90		// Minimum Y-rotation of forks
	#declare MaxYDeg=360		// Maximum Y-rotation of forks		// NOTE: 2nd-Level Branches always based on 360 degrees
	#declare IncYDeg=0		// Number of degrees to increment Y by at each level
	#declare MinZDeg=0		// Minimum Z-rotation of forks		// Z-rotations highly optional - not required at all
	#declare MaxZDeg=0		// Maximum Z-rotation of forks
	#declare IncZDeg=0		// Number of degrees to increment Z by at each level
	#declare PlusMinus=20		// Angle of change of terminal fork
	#declare SD1=seed(6)		// Seed for random numbers - changing only this will create a different tree of the same species
	#declare SD2=seed(1996)		// Seed for additional randum numbers - so tree shape won't change from optional code
	#declare BallJoint=True		// Turns on and off the spheres used to smooth intersections of the branches and trunks
	#declare BallLevels=2		// Maximum Number of Levels to smooth when BallJoint=True (integer from 1 to 5 inclusive)
	#declare LeafNum=3		// Number of Leaves (not counting leaf object at tip of twig)
	#declare LeafRosette=True	// If true, leaves are arranged in rosette around twig rather than spiral up twig
	#declare LeafRandRot=False	// Rotate the leaves around the twig at random angles (cannot be combined with LeafRosette)
	#declare Tip=3			// Select either 1=Leaf, 2=Fruit, or 3=Flower
#include "tree.inc"
object { Tree rotate <0, 45, 0> translate <16, 0, 29> }

// teacher's crayon
cylinder {
	<14.55, 7.45, 32>,
	<14.4,   7, 29>,
	.08
	texture {
		pigment {Red}
	}
}

// teacher's pointer
cylinder {
	<10, 6.5, 32>,
	<12.4, 4.8, 28.7>,
	.07
	pigment {Flesh}
}

