
//walls.inc
// various wall objects

// brick texture for the walls
#declare T2=
texture{
	pigment{
		brick pigment {Gray15}, pigment {Gray90}
		brick_size 0.9
		mortar 0.1
		scale <0.89,1.0,2>
	}
	normal{
		brick
		scale <0.1,0.3,0.1>
	}
//finish{phong 0.8 phong_size 200}
}

// wall behind the screen
box {
	<0,-0.1,37>
	<24, 40, 39>
	texture { T2 }
}

// right wall, behind shelves
box {
	<24,-0.1,28>
	<25, 40, 0>
	texture { T2 rotate y*90}
}

// back wall, behind bcCar and wood
#declare bwWallX0= -33
#declare bwWallX1=	 7
#declare bwWallZ=   90
#declare bwWallY=	40
#declare bwWallSlatInc=10
#declare bwWallSlatSize=0.6

box {
	<bwWallX0, -0.1, bwWallZ>
	<bwWallX1, 40,   bwWallZ>
	texture {
		pigment {
			bumps
			scale 0.01
			pigment_map {
				[ 0.0 White]
				[ 0.2 White]
				[ 0.9 SummerSky]
			}
		}
		finish {
//			ambient 0
			diffuse 0.6
			reflection 0.01
//			reflection 1
			refraction 1
//			ior 1.33
			specular 0.6
			roughness 0.001
		}
	}

/*
	pigment { SummerSky filter 0.2 }
	finish {
		ambient 0
		diffuse 0
		reflection 0.15
//		reflection 1
		refraction 1
		ior 1.33
		specular 1
		roughness 0.001
	}
*/
}
#declare bwX = bwWallX0
#declare halfslat = (bwWallSlatSize/2)
#while (bwX<=bwWallX1)
	box {
		<bwX-halfslat, -0.1, bwWallZ-0.3>
		<bwX+halfslat, 40.0, bwWallZ+0.3>
		pigment {White}
	}
	#declare bwX = bwX + bwWallSlatInc
#end
#declare bwY = 0
#while (bwY<=bwWallY)
	box {
		<bwWallX0, bwY-halfslat, bwWallZ-0.3>
		<bwWallX1, bwY+halfslat, bwWallZ+0.3>
		pigment {White}
	}
	#declare bwY = bwY + bwWallSlatInc
#end

// back wall, behind bcCar and wood
#declare bwWallZ0=	-8
#declare bwWallZ1=	90
#declare bwWallX=  -30
#declare bwWallSlatInc=10
#declare bwWallSlatSize=0.6

box {
	<bwWallX, -0.1, bwWallZ0>
	<bwWallX, 40,   bwWallZ1>
	texture {
		pigment {
			bumps
			scale 0.01
			pigment_map {
				[ 0.0 White]
				[ 0.2 White]
				[ 0.9 SummerSky]
			}
		}
		finish {
//			ambient 0
//			diffuse 0
			reflection 0.25
//			reflection 1
//			refraction 1
//			ior 1.33
			specular 0.7
			roughness 0.001
		}
	}
}
#declare bwZ = bwWallZ0
#declare halfslat = (bwWallSlatSize/2)
#while (bwZ<=bwWallZ1)
	box {
		<bwWallX-0.3, -0.1, bwZ-halfslat>
		<bwWallX+0.3, 40.0, bwZ+halfslat>
		pigment {White}
	}
	#declare bwZ = bwZ + bwWallSlatInc
#end
#declare bwY = 0
#while (bwY<=bwWallY)
	box {
		<bwWallX-0.3, bwY-halfslat, bwWallZ0>
		<bwWallX+0.3, bwY+halfslat, bwWallZ1>
		pigment {White}
	}
	#declare bwY = bwY + bwWallSlatInc
#end

