// Persistence of Vision Ray Tracer Scene Description File
// File: wires.inc
// Vers: 3
// Desc: Support file for nschool, the wires from the projector and the saw
// Date: 970402
// Auth: Dick Balaska

#ifndef	(True)				// test render? use these
#include "colors.inc"
#include "textures.inc"
#include "skies.inc"
#include "golds.inc"
#include "stones.inc"
#include "glass.inc"
#include "metals.inc"
#include "woods.inc"

#declare True=1
#declare False=0

#declare Test=1

//	camera { location <11.90525101693, 2, 25.17431409366>
//	look_at <11.90525101693, 0.05, 25.17431409366> }
	camera { location <16, 13, 24>
	look_at <16, 0, 24> }
//	camera { location <11.25, 2.05, 25>
//	look_at <11.25, 0.05, 25> }

light_source { < 0, 50, 0 > color rgb 0.5 }
light_source { < 24, 50, 0 > color rgb 0.5 }
light_source { < 0, 50, 0 > color rgb 0.5 }
light_source { < 0, 50, 0 > color rgb 0.5 }

        background { Black }
//        background { White }
        //sky_sphere { S_Cloud1 rotate y * 180 }

        plane { y, 0
                pigment { color rgb < 0.6, 0.6, 0.6 > }
                // normal { crackle 0.2 scale 3 }
				}
#declare Local=1
#end

#declare wiretexture=
texture { pigment { Black} }

#declare projwire=
object {
	union {
		intersection {
			torus {
			  0.5, 0.05
			  rotate x*90
			  //translate <0,0,0>
			  texture {wiretexture}
			}
			plane { <-1,0,0>, 0 pigment {Clear} }
			plane { <0,-1,0>, 0 pigment {Clear} }
			translate <10, 1, 25>
		}
		cylinder {
			<10.5, 1, 25>, <10.5, 0.55, 25>, 0.05
			texture {wiretexture}
		}
		intersection {
			torus {
			  0.5, 0.05
			  rotate x*90
			  //translate <0,0,0>
			  texture {wiretexture}
			}
			plane { <1,0,0>, 0 pigment {Clear} }
			plane { <0,1,0>, 0 pigment {Clear} }
			translate <11, 0.55, 25>
		}
		cylinder {
			<11, 0.05, 25>, <11.25, 0.05, 25> 0.05
			texture {wiretexture}
		}
		intersection {
			torus {
			  1.0, 0.05
			  texture {wiretexture}
			}
			plane { <-1,0,0>, 0 rotate y*0 pigment {Clear} }
			plane { <0,0,1>, 0 rotate y*70 pigment {Clear} }
			translate <11.25, 0.05, 26>
		}
		//////////////////////////////////////////////////////////////////
		// up
		#declare Cex=11.90525101693
		#declare Cez=25.17431409366
		cylinder {
			< 11.59202014333, 0.05, 25.06030737921>, <Cex, 0.05, Cez> 0.05
			texture {wiretexture}
		}
		//////////////////////////////////////////////////////////////////
		// top 1
		#declare Tr=2.5
		#declare Taid=20
		#declare Taod=55
		
		#declare Tair=radians(Taid)
		#declare Taor=radians(Taod)
		#declare Tpx=Cex+(sin(Tair)*Tr)
		#declare Tpz=Cez-(cos(Tair)*Tr)
//		#debug concat("sin20=", str(sin(Tair), 2,8), "\n")
//		#declare Tpz=Cez
		intersection {
			torus {
			  Tr, 0.05
			  texture {wiretexture}
			}
			plane { <0,0,-1>, 0 rotate y*(90-Taid) pigment {Clear} }
			plane { <1,0,0>, 0 rotate y*Taod pigment {Clear} }
			translate <Tpx, 0.05, Tpz>
		}
		//////////////////////////////////////////////////////////////////
		// down 1
		#declare Cl=0.4
		#declare Csx=Tpx+(sin(Taor)*Tr)
		#declare Csz=Tpz+(cos(Taor)*Tr)
		#declare Cex=Csx+(cos(Taor)*Cl)
		#declare Cez=Csz-(sin(Taor)*Cl)
		cylinder {
			<Csx, 0.05, Csz>, <Cex, 0.05, Cez> 0.05
			texture {wiretexture}
		}
		//////////////////////////////////////////////////////////////////
		// bottom 1
		#declare Tr=1.5
		#declare Taid=90-Taod
		#declare Taod=50
		
		#declare Tair=radians(Taid)
		#declare Taor=radians(Taod)
		#declare Tpx=Cex+(cos(Tair)*Tr)
		#declare Tpz=Cez+(sin(Tair)*Tr)
		intersection {
			torus {
			  Tr, 0.05
			  texture {wiretexture}
			}
			plane { <0,0,1>, 0 rotate y*(Taod) pigment {Clear} }
			plane { <-1,0,0>, 0 rotate y*(90-Taid) pigment {Clear} }
			translate <Tpx, 0.05, Tpz>
		}
		//////////////////////////////////////////////////////////////////
		// up 2
		#declare Cl=2.4
		#declare Csx=Tpx+(cos(Taor)*Tr)
		#declare Csz=Tpz-(sin(Taor)*Tr)
		#declare Cex=Csx+(sin(Taor)*Cl)
		#declare Cez=Csz+(cos(Taor)*Cl)
		cylinder {
			<Csx, 0.05, Csz>, <Cex, 0.05, Cez> 0.05
			texture {wiretexture}
		}
		//////////////////////////////////////////////////////////////////
		// top 2
		#declare Tr=1.0
		#declare Taid=90-Taod
		#declare Taod=35
		
		#declare Tair=radians(Taid)
		#declare Taor=radians(Taod)
		#declare Tpx=Cex+(sin(Tair)*Tr)
		#declare Tpz=Cez-(cos(Tair)*Tr)
//		#debug concat("sin20=", str(sin(Tair), 2,8), "\n")
//		#declare Tpz=Cez
		intersection {
			torus {
			  Tr, 0.05
			  texture {wiretexture}
			}
			plane { <0,0,-1>, 0 rotate y*(90-Taid) pigment {Clear} }
			plane { <1,0,0>, 0 rotate y*Taod pigment {Clear} }
			translate <Tpx, 0.05, Tpz>
		}
		//////////////////////////////////////////////////////////////////
		// down 2
		#declare Cl=1.6
		#declare Csx=Tpx+(sin(Taor)*Tr)
		#declare Csz=Tpz+(cos(Taor)*Tr)
		#declare Cex=Csx+(cos(Taor)*Cl)
		#declare Cez=Csz-(sin(Taor)*Cl)
		cylinder {
			<Csx, 0.05, Csz>, <Cex, 0.05, Cez> 0.05
			texture {wiretexture}
		}
		//////////////////////////////////////////////////////////////////
		// bottom 2
		#declare Tr=0.75
		#declare Taid=(90-Taod)
		#declare Taod=5
		
		#declare Tair=radians(Taid)
		#declare Taor=radians(Taod)
		#declare Tpx=Cex+(cos(Tair)*Tr)
		#declare Tpz=Cez+(sin(Tair)*Tr)
		intersection {
			torus {
			  Tr, 0.05
			  texture {wiretexture}
			}
			plane { <-1,0,0>, 0 rotate y*(90-Taid) pigment {Clear} }
			plane { <0,0,1>, 0 rotate y*(90-Taod) pigment {Clear} }
			translate <Tpx, 0.05, Tpz>
		}
	}
}
//#include "markerballs.inc"

#declare sawwire=
object {
	union {
		// out
		intersection {
			torus {
			  0.5, 0.05
			  rotate x*90
			  //translate <0,0,0>
			  texture {wiretexture}
			}
			plane { <-1,0,0>, 0 pigment {Clear} }
			plane { <0,-1,0>, 0 pigment {Clear} }
			rotate y*110
			translate <-7.1, 2.6, 27>
		}
		// down
		cylinder {
			<-7.271010071663, 2.6,  26.53015368961>, <-7.271010071663, 0.55,  26.53015368961>, 0.05
			texture {wiretexture}
		}
		// to floor
		intersection {
			torus {
			  0.5, 0.05
			  rotate x*90
			  //translate <0,0,0>
			  texture {wiretexture}
			}
			plane { <1,0,0>, 0 pigment {Clear} }
			plane { <0,1,0>, 0 pigment {Clear} }
			rotate y*110
			translate <-7.442020143326, 0.55, 26.06030737922>
		}
		cylinder {
			<-7.442020143326, 0.05, 26.06030737922>, <-7.613030214989, 0.05, 25.59046106883>, 0.05
			texture {wiretexture}
		}
		intersection {
			torus {
			  0.5, 0.05
			  //translate <0,0,0>
			  texture {wiretexture}
			}
			plane { <0,0,1>, 0 rotate y*20 pigment {Clear} }
			plane { <1,0,0>, 0 rotate y*80 pigment {Clear} }
			translate <-7.143183904596, 0.05, 25.41945099717>
		}
		cylinder {
			<-7.635587781102, 0.05, 25.33262690834>, <-7.461939603435, 0.05, 24.34781915533>, 0.05
			texture {wiretexture}
		}
		intersection {
			torus {
			  0.7, 0.05
			  //translate <0,0,0>
			  texture {wiretexture}
			}
			plane { <0,0,1>, 0 rotate y*-10 pigment {Clear} }
			plane { <-1,0,0>, 0 rotate y*-30 pigment {Clear} }
			translate <-8.151305030544, 0.05, 24.22626543096>
		}
		cylinder {
			<-7.801305030544, 0.05, 23.62004764831>, <-10.3993812419, 0.05, 22.12004764831>, 0.05
			texture {wiretexture}
		}
	}
}

#ifdef (Local)
object {sawwire}
object {projwire}
sphere { <22, 0.05, 24.1> 0.1 texture {pigment {Green}}}

#end

