#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "skies1.inc"
#include "ost01.inc"

#declare trees = 1
#declare scool = 1
#declare glass = 1
#declare kuglerad = 0.025

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 2.2
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

sky_sphere { S_Cloud5 rotate <93,0,0>}


fog {
  fog_type 2
  distance  100.0
  color <0.2,0.5,0.8>
  fog_offset -1
  fog_alt 1
  up        <0.0,     0.0,  1.0>
}


camera {  //  Camera StdCam
  location  <-5.565, -7.821, 0.5021>
//   location  <-2.77, -4.1, 5>
  direction <0.0,     0.0,  3.0026/1.025>  //1.6>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
 look_at   <-0.441, -1.174, 0.148>  //overall
// look_at   <-2.8, -4.1, 0>

 //look_at   <-0.4,-1.8,0.2>  //interior
}

// *******  L I G H T S *******

light_source {
  <-3, -3, .7>
//  <-3, -3, 7>
  color rgb <.75,.75,.75>
shadowless
}

light_source {
<0,0,0>
color rgb <3.5000, 3.5000, 1.75>
looks_like
   {
   sphere
      {
      <0, 0,0>.05
      pigment{ color rgb <1.5,1.5,.6>}
      finish {ambient 1}
      }
   }
translate <0.3,-1.4,0.5>
}

cylinder{ <.3 ,-1.4,.55>,<.3,-1.4,1.0>,.005
pigment {color rgb <0,0,0>}
}




#include "krop.pov"


difference{
plane { // Plane001
  z,0
}
cylinder{ <.5,.5,1>,<.5,.5,-10>,.4}
   pigment {
    image_map {
      gif "g:\fract004.gif"
      map_type 0
      interpolate 2
    }

  }
finish {ambient .3}

    scale <10.5,10.5,.3>
    rotate <0,0,180>
    translate <2,1,0>
translate <-0.3,1.4,0>
rotate <0,0,3>
translate <0.3,-1.4,0>
}



height_field{
gif "g:\fract001.gif"
translate <-.5,0,-.5>
//rotate <0,90,0>
rotate <180,0,0>
translate <.5,0,.5>
//scale <1,-1,1>
rotate <90,0,0>
   pigment {
    image_map {
      gif "g:\fract004.gif"
      map_type 0
      interpolate 2
              }
          }
    scale <10.5,10.5,5>
    translate <-2,-1+10.5,0>
    rotate <0,0,180>
translate <-0.3,1.4,0>
rotate <0,0,3>
translate <0.3,-1.4,0>
scale <1,1,-1>
translate <0,0,-5/255>
}

plane{z,-5/255+.0001
pigment{color rgbf <.8,1,1,.6>
}

finish{

reflection .4
}
//translate <0.3,-1.4,0>
translate <-3.45,-4.8,0>
}




#if (scool = 1)


#declare bord=
union { // bord
  cylinder { // bordben
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 0.7>
    translate  <-0.85, 0.55, 0.0>
  }
  cylinder { // bordben2
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 0.7>
    translate  <-0.85, -0.55, 0.0>
  }
  cylinder { // bordben4
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 0.7>
    translate  <0.85, -0.55, 0.0>
  }
  cylinder { // bordben3
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 0.7>
    translate  <0.85, 0.55, 0.0>
  }
  box { // bordplade
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.7, 0.05>
    translate  0.7*z
  }
  texture {
    DMFLightOak1
  }
  scale 0.127054
  translate  <-0.270581, 0.0, 0.116893>
}


#declare traekugle2 = difference {
  sphere { // traekugle
    <0,0,0>,1
    texture {
      Yellow_Pine1
    }
    scale 0.126643
    translate  0.974086*z
  }
  sphere { // ydre2
    <0,0,0>,1
    scale 0.93
  }
  texture {
    Yellow_Pine1
  }
}
#declare klokke = difference {
  sphere { // ydre1
    <0,0,0>,1
    scale 0.93
  }
  sphere { // Sphere001
    <0,0,0>,1
    scale 0.91
  }
}
#declare klokke2 = difference {
  object { klokke }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1
    translate  -0.921417*z
  }
}
#declare klokke3 = difference {
  object { klokke2 }
  sphere { // Sphere002
    <0,0,0>,1
    scale 0.312561
    translate  <-0.703031, -0.409595, 0.121825>
  }
  texture {
   Glass
  }
}
#declare CSG001 = difference {
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 0.11>
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1
    scale <0.95, 0.95, 0.14386>
    translate  0.077193*z
  }
}
#declare CSG002 = union {
  cylinder { // Cylndr2
    <0,0,1>, <0,0,0>, 1
    texture {
      Yellow_Pine1
    }
    scale <0.9, 0.9, 0.115789>
  }

 cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1.05
    scale <1.0, 1.0, 0.11*2/3>
}
 cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1.1
    scale <1.0, 1.0, 0.11*1/3>
 }

     object { CSG001 }
  texture {
    Yellow_Pine1
  }
}

#declare stol=

union { // nystol
  box { // stolesaede1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Yellow_Pine1
    }
    scale <0.02, 0.13, 0.01>
    rotate <180.0, -86.0, 180.0>
    translate  <-0.088884, 0.00342, 0.4>
  }

  box { // stolesaede1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Yellow_Pine1
    }
    scale <0.02, 0.13, 0.01>
    rotate <180.0, -86.0, 180.0>
    translate  <-0.088884, 0.00342, 0.34>
  }



     box { // stolesaede
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Yellow_Pine1
    }
    scale <0.11, 0.11, 0.01>
    translate  0.2*z
  }
  cylinder { // ben4
    <0,0,1>, <0,0,0>, 1
    texture {
      Yellow_Pine1
    }
    scale <0.01, 0.01, 0.2>
    translate  <0.1, -0.1, 0.0>
  }
  cylinder { // ben3
    <0,0,1>, <0,0,0>, 1
    texture {
      Yellow_Pine1
    }
    scale <0.01, 0.01, 0.2>
    translate  <0.1, 0.1, 0.0>
  }
  cylinder { // ben2
    <0,0,1>, <0,0,0>, 1
    texture {
      Yellow_Pine1
    }
    scale <0.01, 0.01, 0.4>
    translate  <-0.1, -0.1, 0.0>
  }
  cylinder { // ben1
    <0,0,1>, <0,0,0>, 1
    texture {
      Yellow_Pine1
    }
    scale <0.01, 0.01, 0.4>
    translate  <-0.1, 0.1, 0.0>
  }
  scale 0.3

  translate  0.115766*z
}




#declare tavlegruppe=

union { // tavlegruppe
  cylinder { // tavleben4
    <0,0,1>, <0,0,0>, 1
    texture {
      Silver2
    }
    scale <0.005, 0.005, 0.1>
    rotate <-60.0, -90.0, 0.0>
    translate  <-0.532204, 0.301893, 0.094336>
  }
  cylinder { // tavleben3
    <0,0,1>, <0,0,0>, 1
    texture {
      Silver2
    }
    scale <0.005, 0.005, 0.1>
    rotate <-60.0, -90.0, 0.0>
    translate  <-0.276866, 0.468417, 0.094336>
  }
  cylinder { // tavleben2
    <0,0,1>, <0,0,0>, 1
    texture {
      Silver2
    }
    scale <0.005, 0.005, 0.296666>
    rotate <34.0, -90.0, 0.0>
    translate  <-0.304621, 0.509123, 0.153528>
  }
  cylinder { // tavleben1
    <0,0,1>, <0,0,0>, 1
    texture {
      Silver2
    }
    scale <0.005, 0.005, 0.1>
    translate  <-0.300919, 0.509123, 0.092>
  }
  cylinder { // tavleben
    <0,0,1>, <0,0,0>, 1
    texture {
      Silver2
    }
    scale <0.005, 0.005, 0.1>
    translate  <-0.553766, 0.338182, 0.092487>
  }
  box { // tavle2
    <-1, -1, -1>, <1, 1, 1>
        pigment {
    image_map {
      gif "g:\113.gif"
      map_type 0
      interpolate 2
    }

     scale 2
    translate <-1,-1,0>
    rotate <0,90,0>

    rotate <90,0,0>

    }
    finish{ ambient .3}
    scale <0.008036, 0.19, 0.095>
    rotate -55.993515*z
    translate  <-0.425969, 0.425887, 0.291983>
  }
  box { // tavle1
    <-1, -1, -1>, <1, 1, 1>
    pigment {color rgb<0,0,0>}
    scale <0.008035, 0.2, 0.1>
    rotate -55.993515*z
    translate  <-0.425969, 0.425887, 0.291983>
  }
  box { // kridtrende
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Silver2
    }
    scale <0.02, 0.005, 0.2>
    rotate <90.0, 0.0, -56.0>

    translate  <-0.42498, 0.41943, 0.186342>
  }
  translate  <0.005549, 0.0, 0.036995>
  translate <0.25,-0.15,0>
}


#declare tavlegruppe2=

union { // tavlegruppe
  cylinder { // tavleben4
    <0,0,1>, <0,0,0>, 1
    texture {
      Silver2
    }
    scale <0.005, 0.005, 0.1>
    rotate <-60.0, -90.0, 0.0>
    translate  <-0.532204, 0.301893, 0.094336>
  }
  cylinder { // tavleben3
    <0,0,1>, <0,0,0>, 1
    texture {
      Silver2
    }
    scale <0.005, 0.005, 0.1>
    rotate <-60.0, -90.0, 0.0>
    translate  <-0.276866, 0.468417, 0.094336>
  }
  cylinder { // tavleben2
    <0,0,1>, <0,0,0>, 1
    texture {
      Silver2
    }
    scale <0.005, 0.005, 0.296666>
    rotate <34.0, -90.0, 0.0>
    translate  <-0.304621, 0.509123, 0.153528>
  }
  cylinder { // tavleben1
    <0,0,1>, <0,0,0>, 1
    texture {
      Silver2
    }
    scale <0.005, 0.005, 0.1>
    translate  <-0.300919, 0.509123, 0.092>
  }
  cylinder { // tavleben
    <0,0,1>, <0,0,0>, 1
    texture {
      Silver2
    }
    scale <0.005, 0.005, 0.1>
    translate  <-0.553766, 0.338182, 0.092487>
  }
  box { // tavle2
    <-1, -1, -1>, <1, 1, 1>
        pigment {
    image_map {
      gif "g:\112.gif"
      map_type 0
      interpolate 2
    }

     scale 2
    translate <-1,-1,0>
    rotate <0,90,0>

    rotate <90,0,0>

    }
    finish{ ambient .3}
    scale <0.008036, 0.19, 0.095>
    rotate -55.993515*z
    translate  <-0.425969, 0.425887, 0.291983>
  }
  box { // tavle1
    <-1, -1, -1>, <1, 1, 1>
    pigment {color rgb<0,0,0>}
    scale <0.008035, 0.2, 0.1>
    rotate -55.993515*z
    translate  <-0.425969, 0.425887, 0.291983>
  }
  box { // kridtrende
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Silver2
    }
    scale <0.02, 0.005, 0.2>
    rotate <90.0, 0.0, -56.0>

    translate  <-0.42498, 0.41943, 0.186342>
  }
  translate  <0.005549, 0.0, 0.036995>
  translate <0.25,-0.15,0>
}
#declare tavlegruppe3=

union { // tavlegruppe
  cylinder { // tavleben4
    <0,0,1>, <0,0,0>, 1
    texture {
      Silver2
    }
    scale <0.005, 0.005, 0.1>
    rotate <-60.0, -90.0, 0.0>
    translate  <-0.532204, 0.301893, 0.094336>
  }
  cylinder { // tavleben3
    <0,0,1>, <0,0,0>, 1
    texture {
      Silver2
    }
    scale <0.005, 0.005, 0.1>
    rotate <-60.0, -90.0, 0.0>
    translate  <-0.276866, 0.468417, 0.094336>
  }
  cylinder { // tavleben2
    <0,0,1>, <0,0,0>, 1
    texture {
      Silver2
    }
    scale <0.005, 0.005, 0.296666>
    rotate <34.0, -90.0, 0.0>
    translate  <-0.304621, 0.509123, 0.153528>
  }
  cylinder { // tavleben1
    <0,0,1>, <0,0,0>, 1
    texture {
      Silver2
    }
    scale <0.005, 0.005, 0.1>
    translate  <-0.300919, 0.509123, 0.092>
  }
  cylinder { // tavleben
    <0,0,1>, <0,0,0>, 1
    texture {
      Silver2
    }
    scale <0.005, 0.005, 0.1>
    translate  <-0.553766, 0.338182, 0.092487>
  }
  box { // tavle2
    <-1, -1, -1>, <1, 1, 1>
        pigment {
    image_map {
      gif "g:\plus.gif"
      map_type 0
      interpolate 2
    }

     scale 2
    translate <-1,-1,0>
    rotate <0,90,0>

    rotate <90,0,0>

    }
    finish{ ambient .3}
    scale <0.008036, 0.19, 0.095>
    rotate -55.993515*z
    translate  <-0.425969, 0.425887, 0.291983>
  }
  box { // tavle1
    <-1, -1, -1>, <1, 1, 1>
    pigment {color rgb<0,0,0>}
    scale <0.008035, 0.2, 0.1>
    rotate -55.993515*z
    translate  <-0.425969, 0.425887, 0.291983>
  }
  box { // kridtrende
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Silver2
    }
    scale <0.02, 0.005, 0.2>
    rotate <90.0, 0.0, -56.0>

    translate  <-0.42498, 0.41943, 0.186342>
  }
  translate  <0.005549, 0.0, 0.036995>
  translate <0.25,-0.15,0>
}




#end

#if (trees = 1)

#include "bstamme.inc"

#declare j=1
#while (j<3.5)
#declare i=-1
#while (i<2.1)
object{
Tree1
scale .04 + rand(SD1)*.02
rotate <90,0,0>
rotate <0,0,360*rand(SD1)>
translate <i-.15+.3*rand(SD1),j-.15+.3*rand(SD1),0>
}

#debug "."
#declare i=i+.5
#end
#debug "\n"
#declare j=j+.5
#end


object{
Tree1
rotate 120*y
scale .037
rotate <90,0,0>
translate <-1.7,-4.4,0>

}
object{
Tree1
rotate -120*y
scale .035
rotate <90,0,0>
translate <-2.0,-1.4,0>
}


object{
Tree2
rotate 180*y
scale .105
rotate <90,0,0>
rotate <0,0,-90>
translate  <-5.565*.75, -7.821*.75-0.96, 0>
}


#end

//----------------------------------------------------------------------//

#if (scool = 1)

union {
  object { traekugle2 }
#if (glass = 1)
  object { klokke3 }
#end
  object { CSG002 }

translate <0.3,-1.4,0>
}
object{bord
translate <.7,-2,0>
}

object { tavlegruppe2
translate <0.15,-1.4,0>
}

object { tavlegruppe3
rotate -75*z
translate <0.3,-1.4,0>
}

object { tavlegruppe
rotate -150*z
translate <0.45,-1.4,0>
}

object
{stol
rotate -115*z
translate <-0.1 , 0.02 , 0>
translate <0.3,-1.4,0>

}

object
{stol
rotate -75*z
translate <-0.38 , -0.013 , 0>
translate <0.3,-1.4,0>

}


object
{stol
rotate 115*z
translate <-0.20 , -0.4 , 0>
translate <0.3,-1.4,0>

}
object
{stol
rotate 65*z
translate <-0.35 , -0.38 , 0>
translate <0.3,-1.4,0>

}
#end


plane{y,0
rotate 180*z
translate 3*y
pigment{ color <1,1,1>}
  finish { reflection 1.0 ambient 0 diffuse 0 }
  }


plane{x,0
rotate 180*z
translate 2.5*x
pigment{ color <1,1,1>}
  finish { reflection 1.0 ambient 0 diffuse 0 }
  }


union{

sphere{
<-1.35,-4.02,kuglerad>,kuglerad
texture{Gold_Metal }
}


sphere{
<-1.85,-4.65,kuglerad>,kuglerad
texture{Gold_Metal }
}

sphere{
<-2.4,-2.7,kuglerad>,kuglerad
texture{Gold_Metal }
}

sphere{
<-3.43,-4.802,kuglerad*1.5>,kuglerad*1.5
texture{Gold_Metal }
}


sphere{
<-4.05,-4.98,kuglerad*.75>,.75*kuglerad
texture{Gold_Metal }
}

sphere{
<-3.28,-5.68,kuglerad*.75>,.75*kuglerad
texture{Gold_Metal }
}
texture{Gold_Metal }
finish{
reflection 0.5
}
translate .05*z
}
