// school.pov

global_settings {
   max_trace_level 6
   }

#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "woods.inc"
#include "schbookcase.inc"
#include "table.inc"
#include "schchairs.inc"
#include "schpainting.inc"
#include "schglobe.inc"
#include "schplants.inc"
#include "chandelier.inc"

#declare G1 = texture {
   pigment { color Gold } finish { specular .3 reflection .7 } }

// the floor
box { <-20,-1,-10>, <20,0,0>
   texture {

      checker texture { T_Stone31 finish { reflection .3 } },
              texture { T_Stone15 finish { reflection .3 } }

/*
      pigment { checker color Black color White }
      // finish { reflection .3 }
*/
      scale .4 rotate y*45
      }
   }

#declare Wwidth = 1.5
#declare Wbottom = .7
#declare Wheight = 2.5
// wall
difference {
   box { <-200,0,0>, <200,5,0.15> texture { pigment { color Gray60 } } }
   box { <-Wwidth/2,Wbottom,-.9>, <Wwidth/2,Wheight+Wbottom,0.3>
      texture { W1 scale <.2,5.,2> } }
   cylinder { <0,Wheight+Wbottom,-.9>, <0,Wheight+Wbottom,0.3>, Wwidth/2
      texture { W1 scale <.2,5,.2> } }
   texture { pigment { color Gray70 } }
   }
// ceiling
box { <-50,5,-30> <50,6,0> texture { pigment { color Gray80 } } }
// back wall
box { <-50,0,-30> <50,6,-30> texture { pigment { color Gray80 } } }


#include "window.inc"
object { WFrame translate y*(Wheight/2+Wbottom) }
object { Window1 translate <0,(Wheight/4+Wbottom),.06> }
object { Window1 translate <0,(Wheight/4+Wbottom+Wheight/2),0.10> }
object { Wupper translate <0,Wheight+Wbottom,0> }
object { F1 translate < 2+Wwidth/2+Fwidth,1,0> }
object { F1 translate <-2-Wwidth/2-Fwidth,1,0> }
object { F1 translate < 2+Wwidth/2+Fwidth,3,0> }
object { F1 translate <-2-Wwidth/2-Fwidth,3,0> }
object { F1 translate < 2,Fwidth,0> }
object { F1 translate <-2,Fwidth,0> }


// the sky
box { <-2000,2000,-2000> <20000,2001,200000>
   texture { pigment { color rgb <.6,.6,1> }
      finish { ambient .7 } }
   rotate <3,0,0>
   }


// a landscape outside
height_field {
   gif "fract004.gif"
   translate <-.5,-1,0> scale <100,10,100>
   texture {
      pigment { agate turbulence 1.5 lambda 1.5
         omega .8 octaves 8
         color_map {
            [0.00 color rgb <.15, .4, .1>]
            [0.33 color rgb <.06, .4, .2>]
            [0.86 color rgb <.4, .2, .05>]
            [1.00 color rgb <.15, .4, .1>]
            }
         }
      }
   rotate x*-5
   }


// the sun outside
#declare Sunx = -280
#declare Suny = 1750
#declare Sunz = 1300

// the sun
light_source { <Sunx, Suny, Sunz> color Gray90 }


// the sunbeams
box { <-1,-1,-1>, <1,1,.3>
   pigment { colour rgbt <1, 1, 1, 1> }
   halo {
      dust dust_type 1 box_mapping linear
      colour_map {
         [ 0 color rgbt <1, 1, 1, 1.0> ]
         [ 1 color rgbt <1, 1, 1, 0.85> ] // was .94
         }
      samples 15
      // aa_level 3 aa_threshold 0.2 jitter 0.1
      }
   scale <.5, 1.625, 10>
   rotate <-atan2(Suny,Sunz)*180/3.14159,0,0>
   rotate <0,-atan2(-Sunx,Sunz)*180/3.14159,0>
   translate <0,1.975,0>
   hollow
   }


object { BookCaseR1 translate <-2.3,0,-4> }
object { BookCaseR2 translate <-2.3,0,-2> }
object { BookCaseR3 translate <-2.3,0,0> }
object { BookCase1 translate < 3.3,0,0> }


// the tables and chairs
#declare Tx = -.2
#declare Tz = -2.1
object { Table1 translate <Tx,0,Tz> }
object { DO_Chair2 scale .9 rotate y*184 translate <Tx,0,Tz-0.5> }
object { DO_Chair2 scale .9 rotate y*-58 translate <Tx-0.5,0,Tz> }
object { DO_Chair2 scale .9 rotate y*-1 translate <Tx,0,Tz+0.5> no_shadow }

// the paintings
// Rembrandt
object { Painting1 translate <Wwidth/2+Paint1width/2+0.6, 1.4+Paint1height/2, 0> }
// DaVinci
object { Painting2 scale .4 translate <-Wwidth/2-.65, 1.7, 0> }

// the globe
object { DO_Globe1 scale 0.9 rotate y*30 translate <-1.45,0,-.55> }


// the plants
union {
   object { DO_Pot2 } object { DO_Plant2 scale .9 translate <0,.26,0> }
   scale <.8,1.1,.8>
   translate <-0.9,0,-.4>
   }
union {
   object { DO_Pot2 } object { DO_Plant3 rotate y*180 scale <1,1.2,1> translate <0,.26,0> }
   scale .8
   translate <2.4,0,-.4>
   }


// light up the room a little
light_source { < 3.0,2.3,-6> color Gray35 fade_distance 10  fade_power 2 }
light_source { <-1.1,2.0,-8> color Gray35 fade_distance 20  fade_power 2 }
light_source { <-1.0,1.5,-6> color Gray20 fade_distance 1.5 fade_power 2 }

object { Chandelier1 translate <1.15,3.6,-2> no_shadow }
cylinder { <1.15,3.6,-2>, <1.25,5,-2>, 0.01 texture { G1 } no_shadow }

// the final shot
camera { location <-1.7, 1.05, -5.2> look_at <-.5,1.05,0> }
