
// Plastics (clay.inc)
// Lorenzo Quintana Juez (voyager@redestb.es)
// April 30, 1997

// _____ Figures of clay _____

// __ Textures __

#declare T_BlClay = texture { // Plastilina verde
  pigment { rgb <0, .3, .6> }
  finish { diffuse .8 ambient .3 }
  normal { bumps .2 scale .5 }
}

#declare T_BluClay = texture { // Plastilina verde
  pigment { rgb <0, .5, .9> }
  finish { diffuse .8 ambient .3 }
  normal { bumps .2 scale .5 }
}

#declare T_GClay = texture { // Plastilina verde
  pigment { rgb <0, .5, 0> }
  finish { diffuse .8 ambient .3 }
  normal { bumps .2 scale .5 }
}

#declare T_GBClay = texture { // Plastilina verde
  pigment { rgb <0, .7, .5> }
  finish { diffuse .8 ambient .3 }
  normal { bumps .2 scale .8 }
}

#declare T_BrClay = texture { // Plastilina verde
  pigment { rgb <.6, .3, .1> }
  finish { diffuse .8 ambient .3 }
  normal { bumps .2 scale .5 }
}

#declare T_YClay = texture { // Amarilla
  pigment { rgb <1, .85, 0> }
  finish { diffuse .8 ambient .3 }
  normal { bumps .2 scale .5 }
}

#declare T_WClay = texture {
  pigment { rgb 1 }
  finish { diffuse .7 ambient .3 }
  normal { bumps .2 scale .5 }
}

#declare T_RClay = texture {
  pigment { rgb <1,0,0> }
  finish { diffuse .8 ambient .3 }
  normal { bumps .2 scale .5 }
}

#declare T_BClay = texture {
  pigment { rgb <.05,.05,.05> }
  finish { diffuse .8 ambient .3 }
  normal { bumps .2 scale .5 }
}

#declare T_BluClay2 = texture { // Plastilina verde
  pigment { rgb <0, .5, .9> }
  finish { diffuse .8 ambient .3 }
  normal { bumps .7 scale .7 }
  normal { dents .8 scale 1 }
}

#declare T_YClay2 = texture { // Amarilla
  pigment { rgb <1, .85, 0> }
  finish { diffuse .8 ambient .3 }
  normal { bumps .5 scale .5 }
  normal { dents .8 scale 1 }
}

#declare T_RClay2 = texture {
  pigment { rgb <1,0,0> }
  finish { diffuse .8 ambient .3 }
  normal { bumps .7 scale .5 }
  normal { dents 1 scale .8 }
}

#declare T_BrClay2 = texture { // Plastilina verde
  pigment { rgb <.6, .3, .1> }
  finish { diffuse .8 ambient .3 }
  normal { bumps .2 scale .5 }
  normal { dents 1 scale .7 }
}

// _____ Monster - Alien _____

#declare Monster = union {
  blob { threshold 0.6
  sphere { 0, 3, 1 scale <1,.6,1> translate <0,.5,0> }
  sphere { 0, 3, 1 translate <0,1,0> }
  sphere { 0, 2.5, 1 translate <0,2,-.5> }
  sphere { 0, 2, 1 translate <0,3,-1> }
  sphere { 0, 2, 1 translate <0,3,0.5> }
  sphere { 0, 2, 1 translate <0,4,-1.5> }
  sphere { 0, 2, 1 translate <0,5,-1> }
  sphere { 0, 1.5, 1 scale <1,.5,1.4> translate <0,3.5,-3.2> }
  sphere { 0, 1.5, 1 scale <1.2,.8,1.5> translate <0,5.2,-3.2> }
  sphere { 0, 1.4, 1 scale <1,1,1.1> translate <0,6.2,-1.8> }
  sphere { 0, .8, 1 translate <0,6.1,-3> }
  sphere { 0, 1.5, 1 scale <.4,1,1> translate <1,4.5,-2.5> }
  sphere { 0, 1.5, 1 scale <.4,1,1> translate <-1,4.5,-2.5> }
  // brazo izq.
  sphere { 0, 1.5, 1 translate <1,4,-1> }
  sphere { 0, 1, 1 translate <1.5,4,-1.5> }
  sphere { 0, 1, 1 translate <2,3.5,-1.5> }
  sphere { 0, 1, 1 translate <2.5,3,-2> }
  sphere { 0, 1, 1 translate <3,2.8,-2.5> }
  // fingers
  sphere { 0, .9, 1 scale <.5,.5,1.8> translate <3.2,2.8,-3.3> }
  sphere { 0, .9, 1 scale <.5,1.8,.5> rotate -50*x translate <3,3.5,-3.1> }
  sphere { 0, .9, 1 scale <.5,1.8,.5> rotate 55*x translate <3.2,2.2,-3.1> }
  // brazo der.
  sphere { 0, 1.5, 1 translate <-1,4,-1> }
  sphere { 0, 1, 1 translate <-1.5,4,-1.5> }
  sphere { 0, 1, 1 translate <-2,3.5,-1.5> }
  sphere { 0, 1, 1 translate <-2.5,3,-2> }
  sphere { 0, 1, 1 translate <-3,2.8,-2.5> }
  // fingers
  sphere { 0, .9, 1 scale <.5,.5,1.8> translate <-3.2,2.8,-3.3> }
  sphere { 0, .9, 1 scale <.5,1.8,.5> rotate -50*x translate <-3,3.5,-3.1> }
  sphere { 0, .9, 1 scale <.5,1.8,.5> rotate 55*x translate <-3.2,2.1,-3> }
  // unas y dientes fundidos
  sphere { 0, .5, 1 scale <.5,.5,1.8> rotate -10*y
    translate <-3.2,2.8,-4.2> texture { T_WClay } }
  sphere { 0, .5, 1 scale <.5,1.8,.5>
    rotate <-50,-10,0> translate <-2.9,4.1,-4> texture { T_WClay } }
  sphere { 0, .5, 1 scale <.5,1.8,.5> rotate <55,-10,0>
    translate <-3,1.7,-3.8> texture { T_WClay } }
  sphere { 0, .5, 1 scale <.5,1.8,.5> rotate <-50,10,0>
    translate <2.9,4.1,-4> texture { T_WClay } }
  }
  // unas y dientes enganchados
  blob { threshold 0.6
  // unas
  sphere { 0, .5, 1 scale <.5,1.8,.5>
    rotate <55,10,0> translate <3.1,1.7,-3.8> }
  sphere { 0, .5, 1 scale <.5,.5,1.8>
    rotate 10*y translate <3.2,2.8,-4.2> }
  // dientes
  sphere { 0, .5, 1 scale <.5,1.4,.5> translate <.35,4.6,-3.9> }
  sphere { 0, .5, 1 scale <.5,1.4,.5> translate <-.35,4.6,-3.9> }
  sphere { 0, .5, 1 scale <.5,1.6,.5> translate <.5,3.8,-3.5> }
  sphere { 0, .5, 1 scale <.5,1.6,.5> translate <-.5,3.8,-3.5> }
  sphere { 0, .5, 1 scale <.5,1.6,.5> translate <0,3.8,-4> }
  texture { T_WClay }
  }
  // eyes
  sphere { 0, .34  translate <1.35,5.2,-2.7> texture { T_YClay } }
  sphere { 0, .34  translate <-1.35,5.2,-2.7> texture { T_YClay } }
  texture { T_GClay }
}

// _____ Lisa _____

#declare T_Vestido = texture {
  pigment { image_map { gif "vestido.gif" map_type 2 transmit 1 1 once } }
  finish { diffuse .8 ambient .3 }
  scale <1,2.9,1>
  translate <0,-.5,1.9>
}

#declare Pestania = sphere { .5*y, .2 scale <.2, 1, .2> }

#declare Ojo_Lisa = union {
  sphere { <0, 5, 0>, .5 texture { T_WClay } }
  sphere { <0, 0, -.45>, .12 rotate <10,20,0> texture { T_BClay }
  translate 5*y }
  // pestanias
  union {
  object { Pestania rotate -20*z }
  object { Pestania rotate 20*z }
  object { Pestania rotate -60*z }
  object { Pestania rotate 60*z }
  translate 5*y texture { T_BClay }
  }
}

#declare Cuerpo_Lisa = union {
  // nariz
  cylinder { <0, 4.6, 1>, <0, 4.6, -.7>, .18 }
  sphere { <0, 4.6, -.7>, .18 }
  // oreja
  torus { .23,.16 rotate <-38, 0, 115> translate <-1.32, 4.5, .79> }
  // cuello
  cone { <0,3.2,2>, .7 <0,4.6,1.3>, 1.22 scale <1.02,1,.9>}
  // cabeza
  blob { threshold 0.6
  sphere { 0, 1.5, 1 scale <.8,.25,1> translate 4.2*y }
  sphere { 0, 1.3, 1 scale <.8,.4,1> translate <0,4.4,.4> }
  sphere { 0, 3.18, 1 scale <1,.98,.7> translate <0,5,1.1> }
  // pelo
  sphere { 0, 2, 1 scale <.3,1.1,.3> rotate -26*z translate <.2,6,1.1> }
  sphere { 0, 2, 1 scale <.3,1.1,.3> rotate 25*z translate <-.2,6,1.1> }
  sphere { 0, 2, 1 scale <.3,1,.3> rotate -63*z translate <.7,5.8,1> }
  sphere { 0, 2, 1 scale <.38,1.1,.3> rotate 65*z translate <-.7,5.8,1> }
  sphere { 0, 2, 1 scale <.32,.95,.3> rotate <30,0,90> translate <-1,5,1> }
  sphere { 0, 2, 1 scale <.3,1,.3> rotate <20,0,130> translate <-.8,4.5,1.4> }
  sphere { <-.5, 5, 0>, .5, -1  }
  sphere { <.5, 5, 0>, .5, -1  }
  }
  blob { threshold 0.4
  // tronco
  sphere { 0, 2.1, 1 scale <1,.4,1>  translate <0,2.4,1.9> }
  //brazos
  sphere { 0, .8, .9 scale <1,1,1>  translate <-1.3,2.1,1.6> }
  sphere { 0, .8, .9 scale <1,1,1>  translate <1.3,2.1,1.6> }
  sphere { 0, .8, .9 scale <1,1.5,1>  translate <-1.4,1.3,1.6> }
  sphere { 0, .8, .9 scale <1,1.5,1>  translate <1.4,1.3,1.6> }
  // manos
  sphere { 0, .6, .9 scale <1,1,1>  translate <-1.5,.7,1.1> }
  sphere { 0, .6, .9 scale <1,1,1>  translate <1.4,.7,1.1> }
  }
  // dedos
  sphere { 0, .3 scale <.5,.5,1>  translate <-1.25,.9,.82> }
  sphere { 0, .3 scale <.5,.5,1>  translate <1.25,.9,.82> }
  // piernas
  cone { <-.6,-1.7,1.9>, .4 <-.6,0,1.9>, .5 }
  cone { <.6,-1.7,1.9>, .4 <.6,0,1.9>, .5 }
  texture { T_YClay }
}

#declare Zapatos = union {
  cylinder { <-.6,-1.7,2.4>, <-.6,-1.7,1>, .45 }
  sphere { <-.6,-1.7,1>, .45 }
  cylinder { <.6,-1.7,2.4>, <.6,-1.7,1>, .45 }
  sphere { <.6,-1.7,1>, .45 }
  texture { T_RClay }
}

#declare Vestido = cone { <0,-.5,1.9>, 1.6 <0,2.4,1.9>, 1.3 open
  texture { T_Vestido }
}

#declare Collar = union {
  sphere { <-.7,3,1.8>, .16 }
  sphere { <-.69,2.97,1.05>, .16 }
  sphere { <-.4,2.95,.8>, .16 }
  sphere { <.4,2.95,1>, .16 }
  sphere { <0,2.9,.8>, .16 }
  texture { T_WClay }
}

#declare Lisa = union {
  object { Ojo_Lisa translate -.49*x }
  object { Ojo_Lisa translate .49*x }
  object { Cuerpo_Lisa }
  object { Collar }
  object { Vestido }
  object { Zapatos }
  translate 1.9*y
}

// _____ Bart _____

#declare Ojo_Bart = union {
  sphere { <0, 5, 0>, .5 texture { T_WClay } }
  sphere { <0, 0, -.45>, .12 rotate <10,-24,0> texture { T_BClay }
  translate 5*y }
}

#declare Cuerpo_Bart = union {
  // nariz
  cylinder { <0, 4.6, 1>, <0, 4.6, -.7>, .18 }
  sphere { <0, 4.6, -.7>, .18 }
  // oreja
  torus { .23,.16 rotate <-38, 0, -115> translate <1.32, 4.6, .9> }
  // cuello
  cone { <0,2.5,2>, .64 <0,4.6,1.3>, 1.22 scale <1.02,1,.9>}
  // cabeza
  blob { threshold 0.6
  sphere { 0, 1.5, 1 scale <.8,.28,1> translate 4.1*y }
  sphere { 0, 1.3, 1 scale <.8,.4,1> translate <0,4.4,.4> }
  sphere { 0, 3.18, 1 scale <1,.98,.7> translate <0,5,1.1> }
  texture { T_YClay }
  }

#declare PeloBart = union {
  blob { threshold 0.6
  sphere { 0, 3, 1 scale <1,.1,.7> translate 1.8*y }
  sphere { 0, 1, 2 scale <.25,.7,.25> translate <0,1.8,-.8> }
  sphere { 0, 1, 2 scale <.25,.7,.25>
  translate <0,1.8,-.92> rotate -40*y }
  sphere { 0, 1, 2 scale <.25,.7,.25>
  translate <0,1.8,-.92> rotate 40*y }
  sphere { 0, 1, 2 scale <.25,.7,.25> rotate -10*x
  translate <0,1.8,-1.15> rotate -65*y }
  sphere { 0, 1, 2 scale <.25,.7,.25> rotate -10*x
  translate <0,1.8,-1.2> rotate 71*y }
  sphere { 0, 1, 2 scale <.25,.7,.25> rotate -15*x
  translate <0,1.8,-1.25> rotate -90*y }
  }
  cylinder { <0,0,0>, <0,1.8,0>, 1.5 scale <1,1,.7> }
  texture { T_YClay }
  rotate 8*x translate <0,4.8,1.1>
  }
  blob { threshold 0.4
  //brazos
  cylinder { <1.4,1.8,1.6>, <1.4,.35,1.6>, .6, 1 }
  sphere { <1.4,.3,1.6>, .6, 1 }
  cylinder { <-1.4,1.8,1.6>, <-1.4,.35,1.6>, .6, 1 }
  sphere { <-1.4,.3,1.6>, .6, 1 }
  }
  // piernas
  cone { <-.6,-1.7,1.9>, .4 <-.6,0,1.9>, .5 }
  cone { <.6,-1.7,1.9>, .4 <.6,0,1.9>, .5 }
  texture { T_YClay }
}

#declare Pantalon = union {
  sphere { <0,1,1.7>, 1.35 }
  cylinder { <.6,.9,1.6>, <.6,-.4,1.6>, .68 }
  cylinder { <-.6,.9,1.6>, <-.6,-.4,1.6>, .68 }
  texture { T_BlClay }
}

#declare Camiseta = union {
  cylinder { <1.4,2.2,1.6>, <1.4,1.75,1.6>, .55 }
  sphere { <1.4,2.2,1.6>, .55 }
  cylinder { <-1.4,2.2,1.6>, <-1.4,1.75,1.6>, .55 }
  sphere { <-1.4,2.2,1.6>, .55 }
  blob { threshold 0.4
  sphere { 0, 2, 1 scale <.85,.2,.85> translate <0,1,1.7> }
  sphere { 0, 2, 1 scale <1.15,1.4,1.15> translate <0,1.6,1.7> }
  }
  texture { T_BluClay }
}

#declare Zapatillas = union {
  cylinder { <-.6,-1.8,2.4>, <-.6,-1.8,1>, .45 }
  sphere { <-.6,-1.8,1>, .45 }
  cylinder { <.6,-1.8,2.4>, <.6,-1.8,1>, .45 }
  sphere { <.6,-1.8,1>, .45 }
  texture { T_BlClay }
}

#declare Bart = union {
  object { Ojo_Bart translate -.49*x }
  object { Ojo_Bart translate .49*x }
  object { PeloBart }
  object { Cuerpo_Bart }
  object { Pantalon }
  object { Camiseta }
  object { Zapatillas }
  translate 2*y
}

// _____ Flower _____

#declare Petalo = sphere { 0, 3 scale <1,.1,.3> rotate -20*z
  translate -3*x  texture { T_WClay } }

#declare Corola = union {
  #declare Npe=0
  #while (Npe<12)
  object { Petalo rotate (30*Npe)*y }
  #declare Npe=Npe+1
  #end
}

#declare Flower = union {
  blob { threshold 0.6
  sphere { 0, 6, 1 scale <1,.4,1> }
  cylinder { 0, 4*y, 1.1, 1 }
  cylinder { 4*y, 7*y, 1.1, 1 }
  cylinder { 7*y, 11*y, 1.1, 1 }
  sphere { 0, 3.5, 1 scale <1,.2,.8> rotate -20*x translate <-2.2,4,0> }
  sphere { 0, 3.5, 1 scale <1,.2,.8> rotate -18*x translate <2.8,7.4,-.2> }
  texture { T_GClay }
  }
  sphere { 11*y, 1.4 texture { T_YClay } }
  object { Corola rotate <-30,-24,0> translate 11.4*y }
}

// _____ Panda _____

#declare Panda = union {
  blob { threshold 0.6
    sphere { 0, 1, 1 scale <6.5,5,6> translate <0,2,0> }
    cylinder { <3.5,1,-3>, <2,1,0>, 1.7, 1 }
    cylinder { <-3.5,1,-3>, <-2,1,0>, 1.7, 1 }
    sphere { 0, 1, 1 scale <6.5,5,6> translate <0,6,0> }
    cylinder { <3.8,6,-2.5>, <2,6,0>, 1.5, 1 }
    cylinder { <-3.8,6,-2.5>, <-2,6,0>, 1.5, 1 }
    // ears
    sphere { 0, 1, 1 scale <2.5,2.6,1.5> translate <-2.4,11.7,0> }
    sphere { 0, 1, 1 scale <2.5,2.6,1.5> translate <2.4,11.8,0> }
    // eyesA
    sphere { 0, 1, 1 scale <1.2,1.2,.5> translate <-.9,10.1,-2.8> }
    sphere { 0, 1, 1 scale <1.2,1.2,.5> translate <.9,10.1,-2.8> }
    // nose
    sphere { 0, 1, 1 scale <1,.8,.6> translate <0,9.2,-4.2> }
    texture { T_BClay }
  }

  // abdomen
  blob { threshold 0.6
    sphere { 0, 1, 1 scale <7.8,7.4,7.4> translate <0,3.8,0> }
    texture { T_WClay }
  }

  blob { threshold 0.6
    // head
    sphere { 0, 1, 1 scale <6.2,6,6.2> translate <0,9.5,0> }
    cylinder { <0,8.6,-3.3>, <0,8.6,0>, 1.35, 1 }
    texture { T_WClay }
  }
  // eyesB
  union {
    sphere { 0, .2 translate <-.85,9.9,-3> }
    sphere { 0, .2 translate <.84,10,-3> }
    texture { T_WClay }
  }
}

// _____ Snail _____

#declare SnailA = union {
  sphere { -2*x, 2.2 }
  difference {
    torus { 2,2.2 } box { <-5,-3,0>, <5,3,6> }
  rotate 90*x
  }
  difference {
    torus { 3,2.2 } box { <-6,-3,0>, <6,3,6> }
  rotate -90*x translate -1*x
  }
    difference {
    torus { 4.4,2.2 }
    union {
    box { <-7,-3,0>, <7,3,7> }
    box { -3*y, <8,3,8> rotate 40*y }
    }
  rotate 90*x translate .44*x
  }
  scale <1,1,1.9> rotate -40*z
  texture { T_BrClay }
}

#declare SnailB =   blob { threshold 0.6
  sphere { 0, 1, 1 scale <22,5,8> translate <1,-4,0> }
  sphere { 0, 1, -1 scale <5,4,10> translate <-.5,0,0> }
  sphere { 0, 1, 1 scale <3,3,4> translate <5,0,0> }
  sphere { 0, 1, 1 scale <4,2,4> translate <5,-2.5,0> }
  sphere { 0, 1, 1 scale <3.5,3.4,4.4> translate <10,-1.5,0> }
  sphere { 0, 1, -1  scale <4,.5,6> rotate -25*z translate <13.8,-3.6,0> }
  cylinder { <10,-1.5,-1.2>, <10,3,-1.5>, 1, 1 }
  cylinder { <10,-1.5,1.2>, <10.3,3,1.5>, 1, 1 }
  texture { T_GBClay }
}

#declare SnaEyes = union {
  sphere { <10,3.2,-1.5>, 1 texture { T_WClay } }
  sphere { <10.3,3.2,1.5>, 1  texture { T_WClay } }
  sphere { <10.8,3.2,-1.5>, .4  texture { T_BClay } }
  sphere { <11.1,3.2,1.5>, .4  texture { T_BClay } }
}

#declare Snail = union {
  object { SnailA } object { SnailB } object { SnaEyes }
  scale .8 translate 4.2*y
}

// _____ Fragments of clay _____

#declare FClay1 = blob { threshold 0.6
  sphere { 0, 5, 1 scale <1,.5,1> translate .5*y }
  sphere { 0, 2, 1 scale <1,1,1> translate <1,1.5,1> }
  sphere { 0, 1, 1 scale <1,.6,1> translate <2,.4,0> }
  sphere { 0, 1, -1 scale <1.4,1,1> translate <.4,1.2,-2.5> }
  sphere { 0, 1, -1 scale <2,1,2> translate <1,2,1> }
  texture  { T_YClay2 }
  scale .8
}

#declare FClay2 = blob { threshold 0.6
  sphere { 0, 2, 1 scale <1,.5,1.5> translate .201*y }
  sphere { 0, 1, -1  translate <.1,.801,-1> }
  texture  { T_YClay2 }
  scale .6 rotate 45*y
}

#declare FClay3 = blob { threshold 0.6
  sphere { 0, 5, 1 scale <1,.5,1> translate .4*y }
  sphere { 0, 3, .9 scale <1,.5,1> translate <1,2,-1> }
  sphere { 0, 2, .8 scale <1,1,1.2> translate <3,1,1> }
  sphere { 0, 4, -1 scale <1.7,.5,2> translate <1,2.6,0> }
  texture  { T_GClay }
}

#declare FClay4 = blob { threshold 0.6
  sphere { 0, 2.2, 1 scale <2.4,1,1> translate <0,1,.2> }
  sphere { 0, 4, -1 scale <.8,1,1> translate <4,1,0> }
  sphere { 0, 1.9, -1 scale <.5,.5,2> translate <0,2.5,0> }
  sphere { 0, 2.2, 1 scale <2.4,1,1> translate <-5,1,-.2> }
  sphere { 0, 1.5, 1 scale <1,.9,1> translate <-7.8,.8,0> }
  texture  { T_BlClay }
}

#declare FClay5 = blob { threshold 0.6
  sphere { 0, 5, 1 scale <1.5,.9,1> translate .8*y }
  sphere { 0, 3, 1 scale <1,.6,1> translate <3,1,1> }
  texture  { T_BlClay }
  rotate -10*y
  scale 1.2
}

#declare FClay6 = blob { threshold 0.6
  sphere { 0, 4, 1 scale <1.5,.9,1> translate .7*y }
  sphere { 0, 2.1, 1 scale <1,.6,1> translate <2,.8,0> }
  sphere { 0, 2, -1 scale <1.2,.8,2> translate <-.5,2,-1.5> }
  sphere { 0, 2, 1 scale <1,.6,1> translate <0,1,-1.6> }
  sphere { 0, 2, -1 scale <1,.2,2> rotate <-30,60,0>
  translate <3.2,2.6,-1> } rotate -10*y
  texture  { T_YClay2 }
  scale 1.3
}

#declare FClay7 = blob { threshold 0.6
  sphere { 0, 3, 1 scale <1,.9,1.5> translate .7*y }
  sphere { 0, 1.2, 1 scale <3,.6,1> rotate -30*y translate <0,.8,0> }
  sphere { 0, 1, -1 scale <1.5,1,1> translate <0,1.6,-1.5> }
  texture  { T_BClay }
  scale .9
}

#declare FClay8 = union {
  blob { threshold 0.6
    sphere { 0, 5, 1 scale <2,1,2> translate .9*y }
    sphere { 0, 3, -1 scale <1.5,.6,1> translate <1,2,2> }
    sphere { 0, 2, -1 scale <2,1,2> translate <-2,3,-2> }
    sphere { 0, 3, -1 scale <1.5,1,1> translate <2,1,-2> }
    sphere { 0, 2, -1 scale <1.2,1,1> translate <.5,0,0> }
    scale <.6,1,1> rotate 10*x
  }
  blob { threshold 0.6
    sphere { 0, 2, 1 scale <2,1,.5> translate 1*y }
    sphere { 0, 1.5, 1 scale <1.5,.6,1> translate <1,1,.5> }
    sphere { 0, 1, 1 scale <2,1,2> translate <-1,1,-1> }
    sphere { 0, 1.5, 1 scale <1.5,1,1> translate <1,1,-1> }
    sphere { 0, 1, 1 scale <1.2,1,1> translate <.5,0,0> }
    scale <1,.8,2> rotate -30*x translate <0,1,1>
  }
  blob { threshold 0.6
    sphere { 0, 1, 1 scale <2,1,1> translate .2*y }
    sphere { 0, .8, 1 scale <1.5,.8,.7> rotate 70*y translate <1,.3,-.5> }
    translate <3,0,-1>
  }
  scale .9 texture  { T_RClay2 }
}

#declare FClay9 = blob { threshold 0.6
  sphere { 0, 3, 1 scale <2,1,1> translate .7*y }
  sphere { 0, 2, 1 scale <2,1,1> rotate -70*y translate <3,.5,2> }
  sphere { 0, 2, -1 scale <2,1,1> translate <4,0,0> }
  sphere { 0, 1, 1 scale <1,1,3> rotate <-30,0,0> translate <-.5,.5,0> }
  sphere { 0, 2, -1 scale <2,.5,1> rotate 20*z translate <-1,1,-1> }
  texture  { T_BluClay2 }
  scale .6 rotate 6*x
}

#declare FClay10 = union {
  superellipsoid { <.5, .2> rotate 85*z scale <3,2,2> }
  superellipsoid { <.5, .2> rotate 89*z scale <3,2,2> translate 2.5*x }
  texture { T_GClay }
}

#declare FClay11 = blob { threshold 0.6
  sphere { 0, 2, 1  translate 2*y }
  sphere { 0, 2.1, 1 translate <1.9,2,.5> }
  sphere { 0, 2, 1 translate <2,2,2> }
  sphere { 0, 1.8, 1 translate <0,2,2> }
  sphere { 0, 2, 1 translate <1,3,1> }
  sphere { 0, 2, 1 translate <0,3,2> }
  sphere { 0, 1.7, -1 translate <-.5,3.9,0> }
  texture  { T_BrClay2 }
  scale .9
}

#declare FClay12 = blob { threshold 0.6
  sphere { 0, 1, 1 scale <2,1,1> translate 2*y }
  sphere { 0, 1, 1 scale <2,1,1> rotate 45*y translate <1,2,-.5> }
  sphere { 0, 1, 1 scale <1.4,1,1> translate <1.8,1.5,.4> }
  texture  { T_GBClay }
  scale 1
}

// _____ Espatula _____

// textures

#declare T_Esp1 = texture {
  pigment { rgb <1,.5,1> }
  finish { diffuse .8 ambient .2 phong 0.95 phong_size 40 }
}

#declare T_Esp2 = texture {
  pigment { rgb <1,1,.5> }
  finish { diffuse .8 ambient .2 phong 0.95 phong_size 40 }
}

#declare T_Esp3 = texture {
  pigment { rgb <.5,1,1> }
  finish { diffuse .8 ambient .2 phong 0.95 phong_size 40 }
}

// objects

#declare Esp = blob { threshold 0.5
  cylinder { 0, 10*x, 1.6, 1 scale <1,.7,1> }
  sphere { 0, 1.5, 1 scale <3,.3,1> translate 13*x }
  scale .75
}

// _____ Box _____

// textures

#declare T_Box1 = texture {
  pigment { rgb <1,.2,.05> }
  finish { diffuse .8 ambient .2 phong .9 phong_size 90 }
}

#declare T_Box2 = texture {
  pigment { bozo color_map {
  [ 0 rgb 1]
  [ 1 rgb .95 ] } }
  finish { diffuse .8 ambient .2 }
}

// __ objects __

#declare Number5 = text { ttf "kidsn.ttf" "5" .1, 0 pigment { rgb 0 } }

#declare BoxA = union {
  sphere { .2*y, .2 }
  sphere { <18,.2,0>, .2 }
  sphere { <18,.2,22>, .2 }
  sphere { <0,.2,22>, .2 }
  cylinder { .2*y, <18,.2,0>, .2 }
  cylinder { <18,.2,0>, <18,.2,22>, .2 }
  cylinder { <18,.2,22>, <0,.2,22>, .2 }
  cylinder { <0,.2,22>, .2*y, .2 }

}

#declare BoxB = union {
  box { <0,.2,-.2>, <18,6,.2> }
  box { <18.2,.2,0>, <17.8,6,22> }
  box { <18,.2,22.2>, <0,6,21.8> }
  box { <-.2,.2,22>, <.2,6,0> }
  box { 0, <18,.4,22> }
  cylinder { .2*y, 6*y, .2 }
  cylinder { <18,.2,0>, <18,6,0>,.2 }
  cylinder { <18,.2,22>, <18,6,22>, .2 }
  cylinder { <0,.2,22>, <0,6,22>, .2 }
}

#declare Box1 = difference {
  union {
  object { Number5 scale 3 translate <5,1.6,-.25> }
  object { BoxA }
  object { BoxA translate 5.8*y }
  object { BoxB }
  texture { T_Box1 }
  }
  box { <.19,.39,.19>, <17.81,4.5,21.81> texture { T_Box2 } }
}
