
// Plastics (head3.inc)
// Lorenzo Quintana Juez (voyager@redestb.es)
// April 30, 1997

// _____ Head 3 _____

// testures

#declare T_Piel3 = texture {
  pigment { rgb <1,.8,.631> }
  finish { diffuse .7 ambient .2 }
}

#declare T_Pestania3 = texture {
  pigment { radial frequency 80
    color_map {
    [ 0.0 rgb <.1,0,0> ]
    [ 0.4 rgb <.1,0,0> ]
    [ 0.4 rgbt 1 ]
    [ 1.0 rgbt 1 ] }
    }
 }

#declare T_Eye3A_L1 = texture {
    pigment { radial frequency 40 turbulence .2
    color_map {
    [ 0.0 rgb <0,0,0> ]
    [ 0.5 rgb <0,0,0> ]
    [ 0.5 rgb <0,.8,1> ]
    [ 1.0 rgb <0,.8,1> ] } rotate 90*x }
    finish { diffuse .8 ambient .3 }
}

#declare T_Eye3A_L2 = texture {
    pigment { gradient z color_map {
    [ 0 rgb 0 ]
    [ 0.0045 rgb 0 ]
    [ 0.0045 rgbt 1 ]
    [ 0.02 rgbt 1 ]
    [ 0.034 rgb 0 ]
    [ 0.034 rgb 1 ]
    [ 1 rgb 1 ] }  }
    finish { diffuse .8 ambient .3 phong 1 phong_size 100 }
    scale <1,1,4>
    translate -2*z }

#declare T_Eye3B = texture {
  pigment { rgbf <1,1,1,.999> }
  finish { specular 1 roughness .001 }
}

// objects

// _____ Eye 3 _____

#declare Eye3 = union {
  sphere { 0, 2 texture { T_Eye3A_L1 } texture { T_Eye3A_L2 } }
  sphere { 0, .78 texture { T_Eye3B } scale <1,1,.6> translate -1.75*z }
}

// _____ Eyelid 3 _____

#declare Abertura3 = prism { linear_sweep linear_spline
  -1.85, 2.25, 4, <0,-1.2>, <1.6, -3.5>, <-1.6, -3.5>, <0,-1.2> rotate 90*z
  pigment { rgb <.3,.1,0> } }

#declare Eyelid3 = difference {
  blob { threshold .5
    sphere { 0, 3, 2 }
    sphere { 0, 2, 1 scale <1,1,1> translate 2*x }
  }
  object { Abertura3 }
}

// _____ Pestania 3 _____

#declare Pestania3 = intersection {
  torus { 1.8, .7 translate <0,.8,-1.2> texture { T_Pestania3 } }
  box { <-2,.3,-.5>, <2,-1,-5> pigment { rgbt 1 } }
}

// _____ Craneo 3A _____

#declare Craneo3A = difference {
  union {
  sphere { 0, 8.3 scale <.9,.85,.853> }
  sphere { 3.8*z, 8.3 scale <.9,.85,1.1> }
  cylinder { 0, 3.8*z, 8.3 scale <.9,.85,1> }
  }
  box { -9, <9,0,-3> }
  translate <0,2.5,4.05>
}

// _____ Craneo 3B _____

#declare Craneo3B = union {
  blob { threshold .5
  sphere { 0, 11.7, 2  scale <.9,.4,.849> translate <0,2.5,4> }
  sphere { 0, 11.737, 2  scale <.8,.4,.7> translate <0,-2.5,4> }
  sphere { 0, 2.8, .6 translate <-3.4,-2.6,-.6> }
  sphere { 0, 2.8, .6 translate <-3.9,-2.7,-.5> }
  sphere { 0, 2.8, .6 translate <-4.2,-2.7,1> }
  sphere { 0, 2.8, .6 translate <-4.2,-2.7,2> }
  sphere { 0, 2.8, .6 translate <-5,-2.7,3> }
  sphere { 0, 2.8, .58 translate <-3.6,-4.4,0> }
  sphere { 0, 2.5, .6 translate <-3.6,-4.4,-.9> }
  sphere { 0, 2.6, .6 translate <-2.6,-5,-1> }
  sphere { 0, 2.2, .6 scale <1,1.2,1> translate <-3.1,-3.6,-1.4> }
  sphere { 0, 1.7, .9 scale <1,1.2,.9> translate <-3,-5.5,-1.3> }
  sphere { 0, 3, .6 scale <1.4,1,1> translate <0,-4,-1.35> }
  sphere { 0, 3, .6 scale <1.5,1,1> translate <0,-6,-.9> }
  sphere { 0, 1.8, .8 scale <1,1,3> rotate <-7,-35,0> translate <-3.7,-6,1.1> }
  cylinder { <-4.6,-4.5,1.5>, <-1,-6.8,-1>, 2, 1.6 }
  sphere { 0, 3, .6 scale <2.1,.8,.85> translate <0,-7.2,-2> }
  sphere { 0, 2, .6  scale <.9,1.4,1> translate <0, .4, -1.6> }
  sphere { 0, 2, .6  scale <1.2,1.2,1> translate <0, 1.1, -1.48> }
  sphere { 0, 2.1, .6  scale <1.8,1,1> translate <0,   2, -1> }
  sphere { 0, 2.1, .6  scale <1.4,1,1> translate <0,  1, -.7>  }
  sphere { 0, 2.1, .6  scale <1.1,1,1> translate <0,  0, -.7> }
  sphere { 0, 2.1, .6  scale <1.2,1,1> translate <0,  -1, -.8> }
  sphere { 0, 2.1, .6  scale <1.8,1,1> translate <0,  -2, -1> }
  sphere { 0, 2, .6  translate <-1,   2.1, -1> }
  sphere { 0, 2, .6  translate <-1.5,   2.1, -.7> }
  sphere { 0, 2, .6  translate <-2,   2, -.7> }
  sphere { 0, 2, .6  translate <-3,   1.7, -.45> }
  sphere { 0, 2, .6  translate <-3.8,   1.5, -.1> }
  sphere { 0, 2, .6  translate <-4.4,  .7, .5> }
  sphere { 0, 3, .6  translate <-4.4,   0, .5> }
  sphere { 0, 2, .6  translate <-4.4, -.8, .5> }
  sphere { 0, 2, .6  translate <-4.5,  .7, 1> }
  sphere { 0, 3, .6  translate <-4.5,   0, 1> }
  sphere { 0, 2, .6  translate <-4.5, -.8, 1> }
  sphere { 0, 2, .6  translate <-4.5,  .7, 2.2> }
  sphere { 0, 3, .6  translate <-4.5,   0, 2.2> }
  sphere { 0, 2, .6  translate <-4.5, -.8, 2.2> }
  sphere { 0, 2, .6  translate <-4.9,  .7, 3> }
  sphere { 0, 3, .6  translate <-4.9,   0, 3> }
  sphere { 0, 2, .6  translate <-4.9, -.8, 3> }
  }

  // _____ Cuello _____

  blob { threshold .5
  sphere { 0, 11.736, 2 scale <.9,.85,1.1> }
  cylinder { -5*y, <0,-25,-2>, 8.5, 1 scale <.9,1,1> }
  translate <0,2.5,8>
  }
}

// _____ Hair 3 _____

// __ textures __

#declare T_Hair3 = texture {
  pigment { image_map {
  gif "hair3.gif" map_type 1 transmit 41, 1 interpolate 2 } }
  finish { diffuse .8 ambient .2 }
  rotate -90*y rotate 5*x translate <0,-3,8>
}

// __ objects __

#declare Hair3 = blob { threshold .5
  cylinder { 0, 2.4*z, 18, .9 scale <.8,.72,1> translate <0,3.4,5.2> }
  cylinder { 0, 2.4*z, 18, .9 scale <.9,1,1> translate <0,-8.4,5.5> }
  texture { T_Hair3  }
}

// _____ Head 3 _____

#declare Head3 = union {
  object { Hair3 }
  object { Craneo3A }
  object { Craneo3B }
  object { Eye3 rotate <4,-8,0> translate <-3.4,-.06,.25> }
  object { Pestania3 rotate 10*x translate <-3.4,-.06,.28> }
  object { Eyelid3 translate <-3.4,-.06,.3> }
  texture { T_Piel3 }
  scale <.9,1,1>
}
